/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.api.service;

import de.adorsys.ledgers.deposit.api.domain.DepositAccountBO;
import de.adorsys.ledgers.deposit.api.domain.DepositAccountDetailsBO;
import de.adorsys.ledgers.deposit.api.domain.FundsConfirmationRequestBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionDetailsBO;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Currency;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public interface DepositAccountService {
    public List<DepositAccountBO> getAccountsByIbanAndParamCurrency(String var1, String var2);

    public DepositAccountBO getAccountByIbanAndCurrency(String var1, Currency var2);

    public DepositAccountBO getAccountById(String var1);

    public Optional<DepositAccountBO> getOptionalAccountByIbanAndCurrency(String var1, Currency var2);

    public Optional<DepositAccountBO> getOptionalAccountById(String var1);

    public DepositAccountBO createNewAccount(DepositAccountBO var1, String var2, String var3);

    public DepositAccountDetailsBO getAccountDetailsByIbanAndCurrency(String var1, Currency var2, LocalDateTime var3, boolean var4);

    public DepositAccountDetailsBO getAccountDetailsById(String var1, LocalDateTime var2, boolean var3);

    public TransactionDetailsBO getTransactionById(String var1, String var2);

    public List<TransactionDetailsBO> getTransactionsByDates(String var1, LocalDateTime var2, LocalDateTime var3);

    public Page<TransactionDetailsBO> getTransactionsByDatesPaged(String var1, LocalDateTime var2, LocalDateTime var3, Pageable var4);

    public boolean confirmationOfFunds(FundsConfirmationRequestBO var1);

    public String readIbanById(String var1);

    public List<DepositAccountDetailsBO> findDetailsByBranch(String var1);

    public Page<DepositAccountDetailsBO> findDetailsByBranchPaged(String var1, String var2, Pageable var3);

    public void deleteTransactions(String var1);

    public void deleteBranch(String var1);

    public void deleteUser(String var1);

    public void deleteAccount(String var1);

    public void rollBackBranch(String var1, LocalDateTime var2);

    public void changeAccountsBlockedStatus(String var1, boolean var2, boolean var3);

    public Page<DepositAccountBO> findByBranchIdsAndMultipleParams(Collection<String> var1, String var2, Boolean var3, Pageable var4);

    public void changeAccountsBlockedStatus(Set<String> var1, boolean var2, boolean var3);

    public void changeCreditLimit(String var1, BigDecimal var2);
}

