/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.api.domain;

import de.adorsys.ledgers.deposit.api.domain.AccountReferenceBO;
import de.adorsys.ledgers.deposit.api.domain.AccountTypeBO;
import de.adorsys.ledgers.deposit.api.domain.AccountUsageBO;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Currency;

public class DepositAccountBO {
    private String id;
    private String iban;
    private String bban;
    private String pan;
    private String maskedPan;
    private String msisdn;
    private Currency currency;
    private String name;
    private String product;
    private AccountTypeBO accountType;
    private String bic;
    private String linkedAccounts;
    private AccountUsageBO usageType;
    private String details;
    private boolean blocked;
    private boolean systemBlocked;
    private String branch;
    private LocalDateTime created;
    private BigDecimal creditLimit = BigDecimal.ZERO;

    public boolean isEnabled() {
        return !this.blocked && !this.systemBlocked;
    }

    public AccountReferenceBO getReference() {
        AccountReferenceBO reference = new AccountReferenceBO();
        reference.setIban(this.iban);
        reference.setCurrency(this.currency);
        reference.setBban(this.bban);
        reference.setMsisdn(this.msisdn);
        reference.setPan(this.pan);
        reference.setMaskedPan(this.maskedPan);
        return reference;
    }

    public static DepositAccountBOBuilder builder() {
        return new DepositAccountBOBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getIban() {
        return this.iban;
    }

    public String getBban() {
        return this.bban;
    }

    public String getPan() {
        return this.pan;
    }

    public String getMaskedPan() {
        return this.maskedPan;
    }

    public String getMsisdn() {
        return this.msisdn;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public String getName() {
        return this.name;
    }

    public String getProduct() {
        return this.product;
    }

    public AccountTypeBO getAccountType() {
        return this.accountType;
    }

    public String getBic() {
        return this.bic;
    }

    public String getLinkedAccounts() {
        return this.linkedAccounts;
    }

    public AccountUsageBO getUsageType() {
        return this.usageType;
    }

    public String getDetails() {
        return this.details;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public boolean isSystemBlocked() {
        return this.systemBlocked;
    }

    public String getBranch() {
        return this.branch;
    }

    public LocalDateTime getCreated() {
        return this.created;
    }

    public BigDecimal getCreditLimit() {
        return this.creditLimit;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public void setBban(String bban) {
        this.bban = bban;
    }

    public void setPan(String pan) {
        this.pan = pan;
    }

    public void setMaskedPan(String maskedPan) {
        this.maskedPan = maskedPan;
    }

    public void setMsisdn(String msisdn) {
        this.msisdn = msisdn;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public void setAccountType(AccountTypeBO accountType) {
        this.accountType = accountType;
    }

    public void setBic(String bic) {
        this.bic = bic;
    }

    public void setLinkedAccounts(String linkedAccounts) {
        this.linkedAccounts = linkedAccounts;
    }

    public void setUsageType(AccountUsageBO usageType) {
        this.usageType = usageType;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public void setSystemBlocked(boolean systemBlocked) {
        this.systemBlocked = systemBlocked;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public void setCreated(LocalDateTime created) {
        this.created = created;
    }

    public void setCreditLimit(BigDecimal creditLimit) {
        this.creditLimit = creditLimit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DepositAccountBO)) {
            return false;
        }
        DepositAccountBO other = (DepositAccountBO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$iban = this.getIban();
        String other$iban = other.getIban();
        if (this$iban == null ? other$iban != null : !this$iban.equals(other$iban)) {
            return false;
        }
        String this$bban = this.getBban();
        String other$bban = other.getBban();
        if (this$bban == null ? other$bban != null : !this$bban.equals(other$bban)) {
            return false;
        }
        String this$pan = this.getPan();
        String other$pan = other.getPan();
        if (this$pan == null ? other$pan != null : !this$pan.equals(other$pan)) {
            return false;
        }
        String this$maskedPan = this.getMaskedPan();
        String other$maskedPan = other.getMaskedPan();
        if (this$maskedPan == null ? other$maskedPan != null : !this$maskedPan.equals(other$maskedPan)) {
            return false;
        }
        String this$msisdn = this.getMsisdn();
        String other$msisdn = other.getMsisdn();
        if (this$msisdn == null ? other$msisdn != null : !this$msisdn.equals(other$msisdn)) {
            return false;
        }
        Currency this$currency = this.getCurrency();
        Currency other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$product = this.getProduct();
        String other$product = other.getProduct();
        if (this$product == null ? other$product != null : !this$product.equals(other$product)) {
            return false;
        }
        AccountTypeBO this$accountType = this.getAccountType();
        AccountTypeBO other$accountType = other.getAccountType();
        if (this$accountType == null ? other$accountType != null : !((Object)((Object)this$accountType)).equals((Object)other$accountType)) {
            return false;
        }
        String this$bic = this.getBic();
        String other$bic = other.getBic();
        if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) {
            return false;
        }
        String this$linkedAccounts = this.getLinkedAccounts();
        String other$linkedAccounts = other.getLinkedAccounts();
        if (this$linkedAccounts == null ? other$linkedAccounts != null : !this$linkedAccounts.equals(other$linkedAccounts)) {
            return false;
        }
        AccountUsageBO this$usageType = this.getUsageType();
        AccountUsageBO other$usageType = other.getUsageType();
        if (this$usageType == null ? other$usageType != null : !((Object)((Object)this$usageType)).equals((Object)other$usageType)) {
            return false;
        }
        String this$details = this.getDetails();
        String other$details = other.getDetails();
        if (this$details == null ? other$details != null : !this$details.equals(other$details)) {
            return false;
        }
        if (this.isBlocked() != other.isBlocked()) {
            return false;
        }
        if (this.isSystemBlocked() != other.isSystemBlocked()) {
            return false;
        }
        String this$branch = this.getBranch();
        String other$branch = other.getBranch();
        if (this$branch == null ? other$branch != null : !this$branch.equals(other$branch)) {
            return false;
        }
        LocalDateTime this$created = this.getCreated();
        LocalDateTime other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        BigDecimal this$creditLimit = this.getCreditLimit();
        BigDecimal other$creditLimit = other.getCreditLimit();
        return !(this$creditLimit == null ? other$creditLimit != null : !((Object)this$creditLimit).equals(other$creditLimit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DepositAccountBO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $iban = this.getIban();
        result = result * 59 + ($iban == null ? 43 : $iban.hashCode());
        String $bban = this.getBban();
        result = result * 59 + ($bban == null ? 43 : $bban.hashCode());
        String $pan = this.getPan();
        result = result * 59 + ($pan == null ? 43 : $pan.hashCode());
        String $maskedPan = this.getMaskedPan();
        result = result * 59 + ($maskedPan == null ? 43 : $maskedPan.hashCode());
        String $msisdn = this.getMsisdn();
        result = result * 59 + ($msisdn == null ? 43 : $msisdn.hashCode());
        Currency $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $product = this.getProduct();
        result = result * 59 + ($product == null ? 43 : $product.hashCode());
        AccountTypeBO $accountType = this.getAccountType();
        result = result * 59 + ($accountType == null ? 43 : ((Object)((Object)$accountType)).hashCode());
        String $bic = this.getBic();
        result = result * 59 + ($bic == null ? 43 : $bic.hashCode());
        String $linkedAccounts = this.getLinkedAccounts();
        result = result * 59 + ($linkedAccounts == null ? 43 : $linkedAccounts.hashCode());
        AccountUsageBO $usageType = this.getUsageType();
        result = result * 59 + ($usageType == null ? 43 : ((Object)((Object)$usageType)).hashCode());
        String $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : $details.hashCode());
        result = result * 59 + (this.isBlocked() ? 79 : 97);
        result = result * 59 + (this.isSystemBlocked() ? 79 : 97);
        String $branch = this.getBranch();
        result = result * 59 + ($branch == null ? 43 : $branch.hashCode());
        LocalDateTime $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        BigDecimal $creditLimit = this.getCreditLimit();
        result = result * 59 + ($creditLimit == null ? 43 : ((Object)$creditLimit).hashCode());
        return result;
    }

    public String toString() {
        return "DepositAccountBO(id=" + this.getId() + ", iban=" + this.getIban() + ", bban=" + this.getBban() + ", pan=" + this.getPan() + ", maskedPan=" + this.getMaskedPan() + ", msisdn=" + this.getMsisdn() + ", currency=" + this.getCurrency() + ", name=" + this.getName() + ", product=" + this.getProduct() + ", accountType=" + this.getAccountType() + ", bic=" + this.getBic() + ", linkedAccounts=" + this.getLinkedAccounts() + ", usageType=" + this.getUsageType() + ", details=" + this.getDetails() + ", blocked=" + this.isBlocked() + ", systemBlocked=" + this.isSystemBlocked() + ", branch=" + this.getBranch() + ", created=" + this.getCreated() + ", creditLimit=" + this.getCreditLimit() + ")";
    }

    public DepositAccountBO() {
    }

    public DepositAccountBO(String id, String iban, String bban, String pan, String maskedPan, String msisdn, Currency currency, String name, String product, AccountTypeBO accountType, String bic, String linkedAccounts, AccountUsageBO usageType, String details, boolean blocked, boolean systemBlocked, String branch, LocalDateTime created, BigDecimal creditLimit) {
        this.id = id;
        this.iban = iban;
        this.bban = bban;
        this.pan = pan;
        this.maskedPan = maskedPan;
        this.msisdn = msisdn;
        this.currency = currency;
        this.name = name;
        this.product = product;
        this.accountType = accountType;
        this.bic = bic;
        this.linkedAccounts = linkedAccounts;
        this.usageType = usageType;
        this.details = details;
        this.blocked = blocked;
        this.systemBlocked = systemBlocked;
        this.branch = branch;
        this.created = created;
        this.creditLimit = creditLimit;
    }

    public static class DepositAccountBOBuilder {
        private String id;
        private String iban;
        private String bban;
        private String pan;
        private String maskedPan;
        private String msisdn;
        private Currency currency;
        private String name;
        private String product;
        private AccountTypeBO accountType;
        private String bic;
        private String linkedAccounts;
        private AccountUsageBO usageType;
        private String details;
        private boolean blocked;
        private boolean systemBlocked;
        private String branch;
        private LocalDateTime created;
        private BigDecimal creditLimit;

        DepositAccountBOBuilder() {
        }

        public DepositAccountBOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public DepositAccountBOBuilder iban(String iban) {
            this.iban = iban;
            return this;
        }

        public DepositAccountBOBuilder bban(String bban) {
            this.bban = bban;
            return this;
        }

        public DepositAccountBOBuilder pan(String pan) {
            this.pan = pan;
            return this;
        }

        public DepositAccountBOBuilder maskedPan(String maskedPan) {
            this.maskedPan = maskedPan;
            return this;
        }

        public DepositAccountBOBuilder msisdn(String msisdn) {
            this.msisdn = msisdn;
            return this;
        }

        public DepositAccountBOBuilder currency(Currency currency) {
            this.currency = currency;
            return this;
        }

        public DepositAccountBOBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DepositAccountBOBuilder product(String product) {
            this.product = product;
            return this;
        }

        public DepositAccountBOBuilder accountType(AccountTypeBO accountType) {
            this.accountType = accountType;
            return this;
        }

        public DepositAccountBOBuilder bic(String bic) {
            this.bic = bic;
            return this;
        }

        public DepositAccountBOBuilder linkedAccounts(String linkedAccounts) {
            this.linkedAccounts = linkedAccounts;
            return this;
        }

        public DepositAccountBOBuilder usageType(AccountUsageBO usageType) {
            this.usageType = usageType;
            return this;
        }

        public DepositAccountBOBuilder details(String details) {
            this.details = details;
            return this;
        }

        public DepositAccountBOBuilder blocked(boolean blocked) {
            this.blocked = blocked;
            return this;
        }

        public DepositAccountBOBuilder systemBlocked(boolean systemBlocked) {
            this.systemBlocked = systemBlocked;
            return this;
        }

        public DepositAccountBOBuilder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public DepositAccountBOBuilder created(LocalDateTime created) {
            this.created = created;
            return this;
        }

        public DepositAccountBOBuilder creditLimit(BigDecimal creditLimit) {
            this.creditLimit = creditLimit;
            return this;
        }

        public DepositAccountBO build() {
            return new DepositAccountBO(this.id, this.iban, this.bban, this.pan, this.maskedPan, this.msisdn, this.currency, this.name, this.product, this.accountType, this.bic, this.linkedAccounts, this.usageType, this.details, this.blocked, this.systemBlocked, this.branch, this.created, this.creditLimit);
        }

        public String toString() {
            return "DepositAccountBO.DepositAccountBOBuilder(id=" + this.id + ", iban=" + this.iban + ", bban=" + this.bban + ", pan=" + this.pan + ", maskedPan=" + this.maskedPan + ", msisdn=" + this.msisdn + ", currency=" + this.currency + ", name=" + this.name + ", product=" + this.product + ", accountType=" + this.accountType + ", bic=" + this.bic + ", linkedAccounts=" + this.linkedAccounts + ", usageType=" + this.usageType + ", details=" + this.details + ", blocked=" + this.blocked + ", systemBlocked=" + this.systemBlocked + ", branch=" + this.branch + ", created=" + this.created + ", creditLimit=" + this.creditLimit + ")";
        }
    }
}

