/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.api.domain;

import de.adorsys.ledgers.deposit.api.domain.AccountReferenceBO;
import de.adorsys.ledgers.deposit.api.domain.AddressBO;
import de.adorsys.ledgers.deposit.api.domain.AmountBO;
import de.adorsys.ledgers.deposit.api.domain.ChargeBearerBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentBO;
import de.adorsys.ledgers.deposit.api.domain.PurposeCodeBO;
import de.adorsys.ledgers.deposit.api.domain.RemittanceInformationStructuredBO;
import java.util.Currency;
import java.util.Optional;

public class PaymentTargetBO {
    private String paymentId;
    private String endToEndIdentification;
    private AmountBO instructedAmount;
    private AccountReferenceBO creditorAccount;
    private String creditorAgent;
    private String creditorName;
    private AddressBO creditorAddress;
    private PurposeCodeBO purposeCode;
    private String remittanceInformationUnstructured;
    private RemittanceInformationStructuredBO remittanceInformationStructured;
    private ChargeBearerBO chargeBearer;
    private PaymentBO payment;

    public boolean isAllCurrenciesMatch() {
        Currency amount = this.instructedAmount.getCurrency();
        boolean debtor = amount.equals(Optional.ofNullable(this.payment).map(PaymentBO::getDebtorAccount).map(AccountReferenceBO::getCurrency).orElse(null));
        return debtor && amount.equals(this.creditorAccount.getCurrency());
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public String getEndToEndIdentification() {
        return this.endToEndIdentification;
    }

    public AmountBO getInstructedAmount() {
        return this.instructedAmount;
    }

    public AccountReferenceBO getCreditorAccount() {
        return this.creditorAccount;
    }

    public String getCreditorAgent() {
        return this.creditorAgent;
    }

    public String getCreditorName() {
        return this.creditorName;
    }

    public AddressBO getCreditorAddress() {
        return this.creditorAddress;
    }

    public PurposeCodeBO getPurposeCode() {
        return this.purposeCode;
    }

    public String getRemittanceInformationUnstructured() {
        return this.remittanceInformationUnstructured;
    }

    public RemittanceInformationStructuredBO getRemittanceInformationStructured() {
        return this.remittanceInformationStructured;
    }

    public ChargeBearerBO getChargeBearer() {
        return this.chargeBearer;
    }

    public PaymentBO getPayment() {
        return this.payment;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public void setEndToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
    }

    public void setInstructedAmount(AmountBO instructedAmount) {
        this.instructedAmount = instructedAmount;
    }

    public void setCreditorAccount(AccountReferenceBO creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public void setCreditorAgent(String creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public void setCreditorName(String creditorName) {
        this.creditorName = creditorName;
    }

    public void setCreditorAddress(AddressBO creditorAddress) {
        this.creditorAddress = creditorAddress;
    }

    public void setPurposeCode(PurposeCodeBO purposeCode) {
        this.purposeCode = purposeCode;
    }

    public void setRemittanceInformationUnstructured(String remittanceInformationUnstructured) {
        this.remittanceInformationUnstructured = remittanceInformationUnstructured;
    }

    public void setRemittanceInformationStructured(RemittanceInformationStructuredBO remittanceInformationStructured) {
        this.remittanceInformationStructured = remittanceInformationStructured;
    }

    public void setChargeBearer(ChargeBearerBO chargeBearer) {
        this.chargeBearer = chargeBearer;
    }

    public void setPayment(PaymentBO payment) {
        this.payment = payment;
    }

    public String toString() {
        return "PaymentTargetBO(paymentId=" + this.getPaymentId() + ", endToEndIdentification=" + this.getEndToEndIdentification() + ", instructedAmount=" + this.getInstructedAmount() + ", creditorAccount=" + this.getCreditorAccount() + ", creditorAgent=" + this.getCreditorAgent() + ", creditorName=" + this.getCreditorName() + ", creditorAddress=" + this.getCreditorAddress() + ", purposeCode=" + (Object)((Object)this.getPurposeCode()) + ", remittanceInformationUnstructured=" + this.getRemittanceInformationUnstructured() + ", remittanceInformationStructured=" + this.getRemittanceInformationStructured() + ", chargeBearer=" + (Object)((Object)this.getChargeBearer()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentTargetBO)) {
            return false;
        }
        PaymentTargetBO other = (PaymentTargetBO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$paymentId = this.getPaymentId();
        String other$paymentId = other.getPaymentId();
        if (this$paymentId == null ? other$paymentId != null : !this$paymentId.equals(other$paymentId)) {
            return false;
        }
        String this$endToEndIdentification = this.getEndToEndIdentification();
        String other$endToEndIdentification = other.getEndToEndIdentification();
        if (this$endToEndIdentification == null ? other$endToEndIdentification != null : !this$endToEndIdentification.equals(other$endToEndIdentification)) {
            return false;
        }
        AmountBO this$instructedAmount = this.getInstructedAmount();
        AmountBO other$instructedAmount = other.getInstructedAmount();
        if (this$instructedAmount == null ? other$instructedAmount != null : !((Object)this$instructedAmount).equals(other$instructedAmount)) {
            return false;
        }
        AccountReferenceBO this$creditorAccount = this.getCreditorAccount();
        AccountReferenceBO other$creditorAccount = other.getCreditorAccount();
        if (this$creditorAccount == null ? other$creditorAccount != null : !((Object)this$creditorAccount).equals(other$creditorAccount)) {
            return false;
        }
        String this$creditorAgent = this.getCreditorAgent();
        String other$creditorAgent = other.getCreditorAgent();
        if (this$creditorAgent == null ? other$creditorAgent != null : !this$creditorAgent.equals(other$creditorAgent)) {
            return false;
        }
        String this$creditorName = this.getCreditorName();
        String other$creditorName = other.getCreditorName();
        if (this$creditorName == null ? other$creditorName != null : !this$creditorName.equals(other$creditorName)) {
            return false;
        }
        AddressBO this$creditorAddress = this.getCreditorAddress();
        AddressBO other$creditorAddress = other.getCreditorAddress();
        if (this$creditorAddress == null ? other$creditorAddress != null : !((Object)this$creditorAddress).equals(other$creditorAddress)) {
            return false;
        }
        PurposeCodeBO this$purposeCode = this.getPurposeCode();
        PurposeCodeBO other$purposeCode = other.getPurposeCode();
        if (this$purposeCode == null ? other$purposeCode != null : !((Object)((Object)this$purposeCode)).equals((Object)other$purposeCode)) {
            return false;
        }
        String this$remittanceInformationUnstructured = this.getRemittanceInformationUnstructured();
        String other$remittanceInformationUnstructured = other.getRemittanceInformationUnstructured();
        if (this$remittanceInformationUnstructured == null ? other$remittanceInformationUnstructured != null : !this$remittanceInformationUnstructured.equals(other$remittanceInformationUnstructured)) {
            return false;
        }
        RemittanceInformationStructuredBO this$remittanceInformationStructured = this.getRemittanceInformationStructured();
        RemittanceInformationStructuredBO other$remittanceInformationStructured = other.getRemittanceInformationStructured();
        if (this$remittanceInformationStructured == null ? other$remittanceInformationStructured != null : !((Object)this$remittanceInformationStructured).equals(other$remittanceInformationStructured)) {
            return false;
        }
        ChargeBearerBO this$chargeBearer = this.getChargeBearer();
        ChargeBearerBO other$chargeBearer = other.getChargeBearer();
        return !(this$chargeBearer == null ? other$chargeBearer != null : !((Object)((Object)this$chargeBearer)).equals((Object)other$chargeBearer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaymentTargetBO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $paymentId = this.getPaymentId();
        result = result * 59 + ($paymentId == null ? 43 : $paymentId.hashCode());
        String $endToEndIdentification = this.getEndToEndIdentification();
        result = result * 59 + ($endToEndIdentification == null ? 43 : $endToEndIdentification.hashCode());
        AmountBO $instructedAmount = this.getInstructedAmount();
        result = result * 59 + ($instructedAmount == null ? 43 : ((Object)$instructedAmount).hashCode());
        AccountReferenceBO $creditorAccount = this.getCreditorAccount();
        result = result * 59 + ($creditorAccount == null ? 43 : ((Object)$creditorAccount).hashCode());
        String $creditorAgent = this.getCreditorAgent();
        result = result * 59 + ($creditorAgent == null ? 43 : $creditorAgent.hashCode());
        String $creditorName = this.getCreditorName();
        result = result * 59 + ($creditorName == null ? 43 : $creditorName.hashCode());
        AddressBO $creditorAddress = this.getCreditorAddress();
        result = result * 59 + ($creditorAddress == null ? 43 : ((Object)$creditorAddress).hashCode());
        PurposeCodeBO $purposeCode = this.getPurposeCode();
        result = result * 59 + ($purposeCode == null ? 43 : ((Object)((Object)$purposeCode)).hashCode());
        String $remittanceInformationUnstructured = this.getRemittanceInformationUnstructured();
        result = result * 59 + ($remittanceInformationUnstructured == null ? 43 : $remittanceInformationUnstructured.hashCode());
        RemittanceInformationStructuredBO $remittanceInformationStructured = this.getRemittanceInformationStructured();
        result = result * 59 + ($remittanceInformationStructured == null ? 43 : ((Object)$remittanceInformationStructured).hashCode());
        ChargeBearerBO $chargeBearer = this.getChargeBearer();
        result = result * 59 + ($chargeBearer == null ? 43 : ((Object)((Object)$chargeBearer)).hashCode());
        return result;
    }

    public PaymentTargetBO() {
    }

    public PaymentTargetBO(String paymentId, String endToEndIdentification, AmountBO instructedAmount, AccountReferenceBO creditorAccount, String creditorAgent, String creditorName, AddressBO creditorAddress, PurposeCodeBO purposeCode, String remittanceInformationUnstructured, RemittanceInformationStructuredBO remittanceInformationStructured, ChargeBearerBO chargeBearer, PaymentBO payment) {
        this.paymentId = paymentId;
        this.endToEndIdentification = endToEndIdentification;
        this.instructedAmount = instructedAmount;
        this.creditorAccount = creditorAccount;
        this.creditorAgent = creditorAgent;
        this.creditorName = creditorName;
        this.creditorAddress = creditorAddress;
        this.purposeCode = purposeCode;
        this.remittanceInformationUnstructured = remittanceInformationUnstructured;
        this.remittanceInformationStructured = remittanceInformationStructured;
        this.chargeBearer = chargeBearer;
        this.payment = payment;
    }
}

