/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.api.domain;

import de.adorsys.ledgers.deposit.api.domain.AccountReferenceBO;
import de.adorsys.ledgers.deposit.api.domain.FrequencyCodeBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentTargetBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentTypeBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionStatusBO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;

public class PaymentBO {
    private String paymentId;
    private Boolean batchBookingPreferred;
    private LocalDate requestedExecutionDate;
    private LocalTime requestedExecutionTime;
    private PaymentTypeBO paymentType;
    private String paymentProduct;
    private LocalDate startDate;
    private LocalDate endDate;
    private String executionRule;
    private FrequencyCodeBO frequency;
    private Integer dayOfExecution;
    private AccountReferenceBO debtorAccount;
    private String debtorName;
    private String debtorAgent;
    private TransactionStatusBO transactionStatus;
    private List<PaymentTargetBO> targets = new ArrayList<PaymentTargetBO>();
    private String accountId;

    public boolean isValidAmount() {
        return this.targets.stream().map(PaymentTargetBO::getInstructedAmount).allMatch(a -> a.getAmount().compareTo(BigDecimal.ZERO) > 0 && a.getAmount().scale() < 3);
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public Boolean getBatchBookingPreferred() {
        return this.batchBookingPreferred;
    }

    public LocalDate getRequestedExecutionDate() {
        return this.requestedExecutionDate;
    }

    public LocalTime getRequestedExecutionTime() {
        return this.requestedExecutionTime;
    }

    public PaymentTypeBO getPaymentType() {
        return this.paymentType;
    }

    public String getPaymentProduct() {
        return this.paymentProduct;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public String getExecutionRule() {
        return this.executionRule;
    }

    public FrequencyCodeBO getFrequency() {
        return this.frequency;
    }

    public Integer getDayOfExecution() {
        return this.dayOfExecution;
    }

    public AccountReferenceBO getDebtorAccount() {
        return this.debtorAccount;
    }

    public String getDebtorName() {
        return this.debtorName;
    }

    public String getDebtorAgent() {
        return this.debtorAgent;
    }

    public TransactionStatusBO getTransactionStatus() {
        return this.transactionStatus;
    }

    public List<PaymentTargetBO> getTargets() {
        return this.targets;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public void setBatchBookingPreferred(Boolean batchBookingPreferred) {
        this.batchBookingPreferred = batchBookingPreferred;
    }

    public void setRequestedExecutionDate(LocalDate requestedExecutionDate) {
        this.requestedExecutionDate = requestedExecutionDate;
    }

    public void setRequestedExecutionTime(LocalTime requestedExecutionTime) {
        this.requestedExecutionTime = requestedExecutionTime;
    }

    public void setPaymentType(PaymentTypeBO paymentType) {
        this.paymentType = paymentType;
    }

    public void setPaymentProduct(String paymentProduct) {
        this.paymentProduct = paymentProduct;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public void setExecutionRule(String executionRule) {
        this.executionRule = executionRule;
    }

    public void setFrequency(FrequencyCodeBO frequency) {
        this.frequency = frequency;
    }

    public void setDayOfExecution(Integer dayOfExecution) {
        this.dayOfExecution = dayOfExecution;
    }

    public void setDebtorAccount(AccountReferenceBO debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public void setDebtorName(String debtorName) {
        this.debtorName = debtorName;
    }

    public void setDebtorAgent(String debtorAgent) {
        this.debtorAgent = debtorAgent;
    }

    public void setTransactionStatus(TransactionStatusBO transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public void setTargets(List<PaymentTargetBO> targets) {
        this.targets = targets;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentBO)) {
            return false;
        }
        PaymentBO other = (PaymentBO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$paymentId = this.getPaymentId();
        String other$paymentId = other.getPaymentId();
        if (this$paymentId == null ? other$paymentId != null : !this$paymentId.equals(other$paymentId)) {
            return false;
        }
        Boolean this$batchBookingPreferred = this.getBatchBookingPreferred();
        Boolean other$batchBookingPreferred = other.getBatchBookingPreferred();
        if (this$batchBookingPreferred == null ? other$batchBookingPreferred != null : !((Object)this$batchBookingPreferred).equals(other$batchBookingPreferred)) {
            return false;
        }
        LocalDate this$requestedExecutionDate = this.getRequestedExecutionDate();
        LocalDate other$requestedExecutionDate = other.getRequestedExecutionDate();
        if (this$requestedExecutionDate == null ? other$requestedExecutionDate != null : !((Object)this$requestedExecutionDate).equals(other$requestedExecutionDate)) {
            return false;
        }
        LocalTime this$requestedExecutionTime = this.getRequestedExecutionTime();
        LocalTime other$requestedExecutionTime = other.getRequestedExecutionTime();
        if (this$requestedExecutionTime == null ? other$requestedExecutionTime != null : !((Object)this$requestedExecutionTime).equals(other$requestedExecutionTime)) {
            return false;
        }
        PaymentTypeBO this$paymentType = this.getPaymentType();
        PaymentTypeBO other$paymentType = other.getPaymentType();
        if (this$paymentType == null ? other$paymentType != null : !((Object)((Object)this$paymentType)).equals((Object)other$paymentType)) {
            return false;
        }
        String this$paymentProduct = this.getPaymentProduct();
        String other$paymentProduct = other.getPaymentProduct();
        if (this$paymentProduct == null ? other$paymentProduct != null : !this$paymentProduct.equals(other$paymentProduct)) {
            return false;
        }
        LocalDate this$startDate = this.getStartDate();
        LocalDate other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        LocalDate this$endDate = this.getEndDate();
        LocalDate other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        String this$executionRule = this.getExecutionRule();
        String other$executionRule = other.getExecutionRule();
        if (this$executionRule == null ? other$executionRule != null : !this$executionRule.equals(other$executionRule)) {
            return false;
        }
        FrequencyCodeBO this$frequency = this.getFrequency();
        FrequencyCodeBO other$frequency = other.getFrequency();
        if (this$frequency == null ? other$frequency != null : !((Object)((Object)this$frequency)).equals((Object)other$frequency)) {
            return false;
        }
        Integer this$dayOfExecution = this.getDayOfExecution();
        Integer other$dayOfExecution = other.getDayOfExecution();
        if (this$dayOfExecution == null ? other$dayOfExecution != null : !((Object)this$dayOfExecution).equals(other$dayOfExecution)) {
            return false;
        }
        AccountReferenceBO this$debtorAccount = this.getDebtorAccount();
        AccountReferenceBO other$debtorAccount = other.getDebtorAccount();
        if (this$debtorAccount == null ? other$debtorAccount != null : !((Object)this$debtorAccount).equals(other$debtorAccount)) {
            return false;
        }
        String this$debtorName = this.getDebtorName();
        String other$debtorName = other.getDebtorName();
        if (this$debtorName == null ? other$debtorName != null : !this$debtorName.equals(other$debtorName)) {
            return false;
        }
        String this$debtorAgent = this.getDebtorAgent();
        String other$debtorAgent = other.getDebtorAgent();
        if (this$debtorAgent == null ? other$debtorAgent != null : !this$debtorAgent.equals(other$debtorAgent)) {
            return false;
        }
        TransactionStatusBO this$transactionStatus = this.getTransactionStatus();
        TransactionStatusBO other$transactionStatus = other.getTransactionStatus();
        if (this$transactionStatus == null ? other$transactionStatus != null : !((Object)((Object)this$transactionStatus)).equals((Object)other$transactionStatus)) {
            return false;
        }
        List<PaymentTargetBO> this$targets = this.getTargets();
        List<PaymentTargetBO> other$targets = other.getTargets();
        if (this$targets == null ? other$targets != null : !((Object)this$targets).equals(other$targets)) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        return !(this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaymentBO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $paymentId = this.getPaymentId();
        result = result * 59 + ($paymentId == null ? 43 : $paymentId.hashCode());
        Boolean $batchBookingPreferred = this.getBatchBookingPreferred();
        result = result * 59 + ($batchBookingPreferred == null ? 43 : ((Object)$batchBookingPreferred).hashCode());
        LocalDate $requestedExecutionDate = this.getRequestedExecutionDate();
        result = result * 59 + ($requestedExecutionDate == null ? 43 : ((Object)$requestedExecutionDate).hashCode());
        LocalTime $requestedExecutionTime = this.getRequestedExecutionTime();
        result = result * 59 + ($requestedExecutionTime == null ? 43 : ((Object)$requestedExecutionTime).hashCode());
        PaymentTypeBO $paymentType = this.getPaymentType();
        result = result * 59 + ($paymentType == null ? 43 : ((Object)((Object)$paymentType)).hashCode());
        String $paymentProduct = this.getPaymentProduct();
        result = result * 59 + ($paymentProduct == null ? 43 : $paymentProduct.hashCode());
        LocalDate $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        LocalDate $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        String $executionRule = this.getExecutionRule();
        result = result * 59 + ($executionRule == null ? 43 : $executionRule.hashCode());
        FrequencyCodeBO $frequency = this.getFrequency();
        result = result * 59 + ($frequency == null ? 43 : ((Object)((Object)$frequency)).hashCode());
        Integer $dayOfExecution = this.getDayOfExecution();
        result = result * 59 + ($dayOfExecution == null ? 43 : ((Object)$dayOfExecution).hashCode());
        AccountReferenceBO $debtorAccount = this.getDebtorAccount();
        result = result * 59 + ($debtorAccount == null ? 43 : ((Object)$debtorAccount).hashCode());
        String $debtorName = this.getDebtorName();
        result = result * 59 + ($debtorName == null ? 43 : $debtorName.hashCode());
        String $debtorAgent = this.getDebtorAgent();
        result = result * 59 + ($debtorAgent == null ? 43 : $debtorAgent.hashCode());
        TransactionStatusBO $transactionStatus = this.getTransactionStatus();
        result = result * 59 + ($transactionStatus == null ? 43 : ((Object)((Object)$transactionStatus)).hashCode());
        List<PaymentTargetBO> $targets = this.getTargets();
        result = result * 59 + ($targets == null ? 43 : ((Object)$targets).hashCode());
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        return result;
    }

    public String toString() {
        return "PaymentBO(paymentId=" + this.getPaymentId() + ", batchBookingPreferred=" + this.getBatchBookingPreferred() + ", requestedExecutionDate=" + this.getRequestedExecutionDate() + ", requestedExecutionTime=" + this.getRequestedExecutionTime() + ", paymentType=" + (Object)((Object)this.getPaymentType()) + ", paymentProduct=" + this.getPaymentProduct() + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ", executionRule=" + this.getExecutionRule() + ", frequency=" + (Object)((Object)this.getFrequency()) + ", dayOfExecution=" + this.getDayOfExecution() + ", debtorAccount=" + this.getDebtorAccount() + ", debtorName=" + this.getDebtorName() + ", debtorAgent=" + this.getDebtorAgent() + ", transactionStatus=" + (Object)((Object)this.getTransactionStatus()) + ", targets=" + this.getTargets() + ", accountId=" + this.getAccountId() + ")";
    }

    public PaymentBO() {
    }

    public PaymentBO(String paymentId, Boolean batchBookingPreferred, LocalDate requestedExecutionDate, LocalTime requestedExecutionTime, PaymentTypeBO paymentType, String paymentProduct, LocalDate startDate, LocalDate endDate, String executionRule, FrequencyCodeBO frequency, Integer dayOfExecution, AccountReferenceBO debtorAccount, String debtorName, String debtorAgent, TransactionStatusBO transactionStatus, List<PaymentTargetBO> targets, String accountId) {
        this.paymentId = paymentId;
        this.batchBookingPreferred = batchBookingPreferred;
        this.requestedExecutionDate = requestedExecutionDate;
        this.requestedExecutionTime = requestedExecutionTime;
        this.paymentType = paymentType;
        this.paymentProduct = paymentProduct;
        this.startDate = startDate;
        this.endDate = endDate;
        this.executionRule = executionRule;
        this.frequency = frequency;
        this.dayOfExecution = dayOfExecution;
        this.debtorAccount = debtorAccount;
        this.debtorName = debtorName;
        this.debtorAgent = debtorAgent;
        this.transactionStatus = transactionStatus;
        this.targets = targets;
        this.accountId = accountId;
    }
}

