/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.api.domain;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public final class BankTransactionCode
extends Enum<BankTransactionCode> {
    public static final /* enum */ BankTransactionCode SEPA;
    public static final /* enum */ BankTransactionCode INSTANT_SEPA;
    public static final /* enum */ BankTransactionCode CROSS_BORDER;
    public static final /* enum */ BankTransactionCode INSTANT_CROSS_BORDER;
    public static final /* enum */ BankTransactionCode SPECIFIC;
    private static final Map<String, BankTransactionCode> container;
    private String value;
    private static final /* synthetic */ BankTransactionCode[] $VALUES;

    public static BankTransactionCode[] values() {
        return (BankTransactionCode[])$VALUES.clone();
    }

    public static BankTransactionCode valueOf(String name) {
        return Enum.valueOf(BankTransactionCode.class, name);
    }

    private BankTransactionCode(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static Optional<BankTransactionCode> getByValue(String value) {
        return Optional.ofNullable(container.get(value));
    }

    public static String getByPaymentProduct(String paymentProduct) {
        return BankTransactionCode.resolveByProduct(paymentProduct, "sepa", SEPA::getValue, INSTANT_SEPA::getValue).orElseGet(() -> BankTransactionCode.resolveByProduct(paymentProduct, "cross-border", CROSS_BORDER::getValue, INSTANT_CROSS_BORDER::getValue).orElse(null));
    }

    private static Optional<String> resolveByProduct(String paymentProduct, String attribute, Supplier<String> supplier, Supplier<String> instantSupplier) {
        return Optional.ofNullable(paymentProduct).map(p -> {
            if (paymentProduct.contains(attribute)) {
                return BankTransactionCode.checkInstant(p, instantSupplier).orElse((String)supplier.get());
            }
            return null;
        });
    }

    private static Optional<String> checkInstant(String paymentProduct, Supplier<String> instantSupplier) {
        return paymentProduct.contains("instant") ? Optional.of(instantSupplier.get()) : Optional.empty();
    }

    static {
        BankTransactionCode[] var0;
        SEPA = new BankTransactionCode("PMNT-ICDT-STDO");
        INSTANT_SEPA = new BankTransactionCode("PMNT-IRCT-STDO");
        CROSS_BORDER = new BankTransactionCode("PMNT-ICDT-XBST");
        INSTANT_CROSS_BORDER = new BankTransactionCode("PMNT-IRCT-XBST");
        SPECIFIC = new BankTransactionCode("PMNT-MCOP-OTHR");
        $VALUES = new BankTransactionCode[]{SEPA, INSTANT_SEPA, CROSS_BORDER, INSTANT_CROSS_BORDER, SPECIFIC};
        container = new HashMap<String, BankTransactionCode>();
        for (BankTransactionCode code : var0 = BankTransactionCode.values()) {
            container.put(code.getValue(), code);
        }
    }
}

