/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.db.domain;

import de.adorsys.ledgers.deposit.db.domain.AccountReference;
import de.adorsys.ledgers.deposit.db.domain.Address;
import de.adorsys.ledgers.deposit.db.domain.Amount;
import de.adorsys.ledgers.deposit.db.domain.ChargeBearer;
import de.adorsys.ledgers.deposit.db.domain.Payment;
import de.adorsys.ledgers.deposit.db.domain.PurposeCode;
import de.adorsys.ledgers.deposit.db.domain.RemittanceInformationStructured;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.ManyToOne;

@Entity
public class PaymentTarget {
    @Id
    private String paymentId;
    private String endToEndIdentification;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="amount", column=@Column(name="AMT")), @AttributeOverride(name="currency", column=@Column(name="CUR"))})
    @Column(nullable=false)
    private Amount instructedAmount;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="iban", column=@Column(name="CRED_IBAN")), @AttributeOverride(name="bban", column=@Column(name="CRED_BBAN")), @AttributeOverride(name="pan", column=@Column(name="CRED_PAN")), @AttributeOverride(name="maskedPan", column=@Column(name="CRED_MASKED_PAN")), @AttributeOverride(name="msisdn", column=@Column(name="CRED_MSISDN"))})
    @Column(nullable=false)
    private AccountReference creditorAccount;
    private String creditorAgent;
    private String creditorName;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="street", column=@Column(name="CRED_STREET")), @AttributeOverride(name="buildingNumber", column=@Column(name="CRED_BLD_NBR")), @AttributeOverride(name="city", column=@Column(name="CRED_CITY")), @AttributeOverride(name="postalCode", column=@Column(name="CRED_ZIP")), @AttributeOverride(name="country", column=@Column(name="CRED_CTRY")), @AttributeOverride(name="line1", column=@Column(name="line_1")), @AttributeOverride(name="line2", column=@Column(name="line_2"))})
    private Address creditorAddress;
    @Enumerated(value=EnumType.STRING)
    private PurposeCode purposeCode;
    @Enumerated(value=EnumType.STRING)
    private ChargeBearer chargeBearer;
    private String remittanceInformationUnstructured;
    @Embedded
    private RemittanceInformationStructured remittanceInformationStructured;
    @ManyToOne(optional=false)
    private Payment payment;

    public String getPaymentId() {
        return this.paymentId;
    }

    public String getEndToEndIdentification() {
        return this.endToEndIdentification;
    }

    public Amount getInstructedAmount() {
        return this.instructedAmount;
    }

    public AccountReference getCreditorAccount() {
        return this.creditorAccount;
    }

    public String getCreditorAgent() {
        return this.creditorAgent;
    }

    public String getCreditorName() {
        return this.creditorName;
    }

    public Address getCreditorAddress() {
        return this.creditorAddress;
    }

    public PurposeCode getPurposeCode() {
        return this.purposeCode;
    }

    public ChargeBearer getChargeBearer() {
        return this.chargeBearer;
    }

    public String getRemittanceInformationUnstructured() {
        return this.remittanceInformationUnstructured;
    }

    public RemittanceInformationStructured getRemittanceInformationStructured() {
        return this.remittanceInformationStructured;
    }

    public Payment getPayment() {
        return this.payment;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public void setEndToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
    }

    public void setInstructedAmount(Amount instructedAmount) {
        this.instructedAmount = instructedAmount;
    }

    public void setCreditorAccount(AccountReference creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public void setCreditorAgent(String creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public void setCreditorName(String creditorName) {
        this.creditorName = creditorName;
    }

    public void setCreditorAddress(Address creditorAddress) {
        this.creditorAddress = creditorAddress;
    }

    public void setPurposeCode(PurposeCode purposeCode) {
        this.purposeCode = purposeCode;
    }

    public void setChargeBearer(ChargeBearer chargeBearer) {
        this.chargeBearer = chargeBearer;
    }

    public void setRemittanceInformationUnstructured(String remittanceInformationUnstructured) {
        this.remittanceInformationUnstructured = remittanceInformationUnstructured;
    }

    public void setRemittanceInformationStructured(RemittanceInformationStructured remittanceInformationStructured) {
        this.remittanceInformationStructured = remittanceInformationStructured;
    }

    public void setPayment(Payment payment) {
        this.payment = payment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentTarget)) {
            return false;
        }
        PaymentTarget other = (PaymentTarget)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$paymentId = this.getPaymentId();
        String other$paymentId = other.getPaymentId();
        if (this$paymentId == null ? other$paymentId != null : !this$paymentId.equals(other$paymentId)) {
            return false;
        }
        String this$endToEndIdentification = this.getEndToEndIdentification();
        String other$endToEndIdentification = other.getEndToEndIdentification();
        if (this$endToEndIdentification == null ? other$endToEndIdentification != null : !this$endToEndIdentification.equals(other$endToEndIdentification)) {
            return false;
        }
        Amount this$instructedAmount = this.getInstructedAmount();
        Amount other$instructedAmount = other.getInstructedAmount();
        if (this$instructedAmount == null ? other$instructedAmount != null : !((Object)this$instructedAmount).equals(other$instructedAmount)) {
            return false;
        }
        AccountReference this$creditorAccount = this.getCreditorAccount();
        AccountReference other$creditorAccount = other.getCreditorAccount();
        if (this$creditorAccount == null ? other$creditorAccount != null : !((Object)this$creditorAccount).equals(other$creditorAccount)) {
            return false;
        }
        String this$creditorAgent = this.getCreditorAgent();
        String other$creditorAgent = other.getCreditorAgent();
        if (this$creditorAgent == null ? other$creditorAgent != null : !this$creditorAgent.equals(other$creditorAgent)) {
            return false;
        }
        String this$creditorName = this.getCreditorName();
        String other$creditorName = other.getCreditorName();
        if (this$creditorName == null ? other$creditorName != null : !this$creditorName.equals(other$creditorName)) {
            return false;
        }
        Address this$creditorAddress = this.getCreditorAddress();
        Address other$creditorAddress = other.getCreditorAddress();
        if (this$creditorAddress == null ? other$creditorAddress != null : !((Object)this$creditorAddress).equals(other$creditorAddress)) {
            return false;
        }
        PurposeCode this$purposeCode = this.getPurposeCode();
        PurposeCode other$purposeCode = other.getPurposeCode();
        if (this$purposeCode == null ? other$purposeCode != null : !((Object)((Object)this$purposeCode)).equals((Object)other$purposeCode)) {
            return false;
        }
        ChargeBearer this$chargeBearer = this.getChargeBearer();
        ChargeBearer other$chargeBearer = other.getChargeBearer();
        if (this$chargeBearer == null ? other$chargeBearer != null : !((Object)((Object)this$chargeBearer)).equals((Object)other$chargeBearer)) {
            return false;
        }
        String this$remittanceInformationUnstructured = this.getRemittanceInformationUnstructured();
        String other$remittanceInformationUnstructured = other.getRemittanceInformationUnstructured();
        if (this$remittanceInformationUnstructured == null ? other$remittanceInformationUnstructured != null : !this$remittanceInformationUnstructured.equals(other$remittanceInformationUnstructured)) {
            return false;
        }
        RemittanceInformationStructured this$remittanceInformationStructured = this.getRemittanceInformationStructured();
        RemittanceInformationStructured other$remittanceInformationStructured = other.getRemittanceInformationStructured();
        if (this$remittanceInformationStructured == null ? other$remittanceInformationStructured != null : !((Object)this$remittanceInformationStructured).equals(other$remittanceInformationStructured)) {
            return false;
        }
        Payment this$payment = this.getPayment();
        Payment other$payment = other.getPayment();
        return !(this$payment == null ? other$payment != null : !((Object)this$payment).equals(other$payment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaymentTarget;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $paymentId = this.getPaymentId();
        result = result * 59 + ($paymentId == null ? 43 : $paymentId.hashCode());
        String $endToEndIdentification = this.getEndToEndIdentification();
        result = result * 59 + ($endToEndIdentification == null ? 43 : $endToEndIdentification.hashCode());
        Amount $instructedAmount = this.getInstructedAmount();
        result = result * 59 + ($instructedAmount == null ? 43 : ((Object)$instructedAmount).hashCode());
        AccountReference $creditorAccount = this.getCreditorAccount();
        result = result * 59 + ($creditorAccount == null ? 43 : ((Object)$creditorAccount).hashCode());
        String $creditorAgent = this.getCreditorAgent();
        result = result * 59 + ($creditorAgent == null ? 43 : $creditorAgent.hashCode());
        String $creditorName = this.getCreditorName();
        result = result * 59 + ($creditorName == null ? 43 : $creditorName.hashCode());
        Address $creditorAddress = this.getCreditorAddress();
        result = result * 59 + ($creditorAddress == null ? 43 : ((Object)$creditorAddress).hashCode());
        PurposeCode $purposeCode = this.getPurposeCode();
        result = result * 59 + ($purposeCode == null ? 43 : ((Object)((Object)$purposeCode)).hashCode());
        ChargeBearer $chargeBearer = this.getChargeBearer();
        result = result * 59 + ($chargeBearer == null ? 43 : ((Object)((Object)$chargeBearer)).hashCode());
        String $remittanceInformationUnstructured = this.getRemittanceInformationUnstructured();
        result = result * 59 + ($remittanceInformationUnstructured == null ? 43 : $remittanceInformationUnstructured.hashCode());
        RemittanceInformationStructured $remittanceInformationStructured = this.getRemittanceInformationStructured();
        result = result * 59 + ($remittanceInformationStructured == null ? 43 : ((Object)$remittanceInformationStructured).hashCode());
        Payment $payment = this.getPayment();
        result = result * 59 + ($payment == null ? 43 : ((Object)$payment).hashCode());
        return result;
    }

    public String toString() {
        return "PaymentTarget(paymentId=" + this.getPaymentId() + ", endToEndIdentification=" + this.getEndToEndIdentification() + ", instructedAmount=" + this.getInstructedAmount() + ", creditorAccount=" + this.getCreditorAccount() + ", creditorAgent=" + this.getCreditorAgent() + ", creditorName=" + this.getCreditorName() + ", creditorAddress=" + this.getCreditorAddress() + ", purposeCode=" + this.getPurposeCode() + ", chargeBearer=" + this.getChargeBearer() + ", remittanceInformationUnstructured=" + this.getRemittanceInformationUnstructured() + ", remittanceInformationStructured=" + this.getRemittanceInformationStructured() + ")";
    }
}

