/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.db.domain;

import de.adorsys.ledgers.deposit.db.domain.AccountType;
import de.adorsys.ledgers.deposit.db.domain.AccountUsage;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"iban", "currency"}, name="DepositAccount_iban_currency_unique")})
public class DepositAccount {
    @Id
    private String id;
    @Column(nullable=false)
    private String iban;
    private String msisdn;
    @Column(nullable=false)
    private String currency;
    private String name;
    private String product;
    private String branch;
    @Enumerated(value=EnumType.STRING)
    private AccountType accountType;
    private String bic;
    private String linkedAccounts;
    @Enumerated(value=EnumType.STRING)
    private AccountUsage usageType;
    private String details;
    @Column(name="block")
    private boolean blocked;
    @Column(name="systemBlock")
    private boolean systemBlocked;

    public boolean isEnabled() {
        return !this.blocked && !this.systemBlocked;
    }

    public String getId() {
        return this.id;
    }

    public String getIban() {
        return this.iban;
    }

    public String getMsisdn() {
        return this.msisdn;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getName() {
        return this.name;
    }

    public String getProduct() {
        return this.product;
    }

    public String getBranch() {
        return this.branch;
    }

    public AccountType getAccountType() {
        return this.accountType;
    }

    public String getBic() {
        return this.bic;
    }

    public String getLinkedAccounts() {
        return this.linkedAccounts;
    }

    public AccountUsage getUsageType() {
        return this.usageType;
    }

    public String getDetails() {
        return this.details;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public boolean isSystemBlocked() {
        return this.systemBlocked;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public void setMsisdn(String msisdn) {
        this.msisdn = msisdn;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public void setAccountType(AccountType accountType) {
        this.accountType = accountType;
    }

    public void setBic(String bic) {
        this.bic = bic;
    }

    public void setLinkedAccounts(String linkedAccounts) {
        this.linkedAccounts = linkedAccounts;
    }

    public void setUsageType(AccountUsage usageType) {
        this.usageType = usageType;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public void setSystemBlocked(boolean systemBlocked) {
        this.systemBlocked = systemBlocked;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DepositAccount)) {
            return false;
        }
        DepositAccount other = (DepositAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$iban = this.getIban();
        String other$iban = other.getIban();
        if (this$iban == null ? other$iban != null : !this$iban.equals(other$iban)) {
            return false;
        }
        String this$msisdn = this.getMsisdn();
        String other$msisdn = other.getMsisdn();
        if (this$msisdn == null ? other$msisdn != null : !this$msisdn.equals(other$msisdn)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$product = this.getProduct();
        String other$product = other.getProduct();
        if (this$product == null ? other$product != null : !this$product.equals(other$product)) {
            return false;
        }
        String this$branch = this.getBranch();
        String other$branch = other.getBranch();
        if (this$branch == null ? other$branch != null : !this$branch.equals(other$branch)) {
            return false;
        }
        AccountType this$accountType = this.getAccountType();
        AccountType other$accountType = other.getAccountType();
        if (this$accountType == null ? other$accountType != null : !((Object)((Object)this$accountType)).equals((Object)other$accountType)) {
            return false;
        }
        String this$bic = this.getBic();
        String other$bic = other.getBic();
        if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) {
            return false;
        }
        String this$linkedAccounts = this.getLinkedAccounts();
        String other$linkedAccounts = other.getLinkedAccounts();
        if (this$linkedAccounts == null ? other$linkedAccounts != null : !this$linkedAccounts.equals(other$linkedAccounts)) {
            return false;
        }
        AccountUsage this$usageType = this.getUsageType();
        AccountUsage other$usageType = other.getUsageType();
        if (this$usageType == null ? other$usageType != null : !((Object)((Object)this$usageType)).equals((Object)other$usageType)) {
            return false;
        }
        String this$details = this.getDetails();
        String other$details = other.getDetails();
        if (this$details == null ? other$details != null : !this$details.equals(other$details)) {
            return false;
        }
        if (this.isBlocked() != other.isBlocked()) {
            return false;
        }
        return this.isSystemBlocked() == other.isSystemBlocked();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DepositAccount;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $iban = this.getIban();
        result = result * 59 + ($iban == null ? 43 : $iban.hashCode());
        String $msisdn = this.getMsisdn();
        result = result * 59 + ($msisdn == null ? 43 : $msisdn.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $product = this.getProduct();
        result = result * 59 + ($product == null ? 43 : $product.hashCode());
        String $branch = this.getBranch();
        result = result * 59 + ($branch == null ? 43 : $branch.hashCode());
        AccountType $accountType = this.getAccountType();
        result = result * 59 + ($accountType == null ? 43 : ((Object)((Object)$accountType)).hashCode());
        String $bic = this.getBic();
        result = result * 59 + ($bic == null ? 43 : $bic.hashCode());
        String $linkedAccounts = this.getLinkedAccounts();
        result = result * 59 + ($linkedAccounts == null ? 43 : $linkedAccounts.hashCode());
        AccountUsage $usageType = this.getUsageType();
        result = result * 59 + ($usageType == null ? 43 : ((Object)((Object)$usageType)).hashCode());
        String $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : $details.hashCode());
        result = result * 59 + (this.isBlocked() ? 79 : 97);
        result = result * 59 + (this.isSystemBlocked() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "DepositAccount(id=" + this.getId() + ", iban=" + this.getIban() + ", msisdn=" + this.getMsisdn() + ", currency=" + this.getCurrency() + ", name=" + this.getName() + ", product=" + this.getProduct() + ", branch=" + this.getBranch() + ", accountType=" + (Object)((Object)this.getAccountType()) + ", bic=" + this.getBic() + ", linkedAccounts=" + this.getLinkedAccounts() + ", usageType=" + (Object)((Object)this.getUsageType()) + ", details=" + this.getDetails() + ", blocked=" + this.isBlocked() + ", systemBlocked=" + this.isSystemBlocked() + ")";
    }

    public DepositAccount() {
    }

    public DepositAccount(String id, String iban, String msisdn, String currency, String name, String product, String branch, AccountType accountType, String bic, String linkedAccounts, AccountUsage usageType, String details, boolean blocked, boolean systemBlocked) {
        this.id = id;
        this.iban = iban;
        this.msisdn = msisdn;
        this.currency = currency;
        this.name = name;
        this.product = product;
        this.branch = branch;
        this.accountType = accountType;
        this.bic = bic;
        this.linkedAccounts = linkedAccounts;
        this.usageType = usageType;
        this.details = details;
        this.blocked = blocked;
        this.systemBlocked = systemBlocked;
    }
}

