/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.db.domain;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import de.adorsys.ledgers.deposit.db.domain.AccountReference;
import de.adorsys.ledgers.deposit.db.domain.FrequencyCode;
import de.adorsys.ledgers.deposit.db.domain.PaymentTarget;
import de.adorsys.ledgers.deposit.db.domain.PaymentType;
import de.adorsys.ledgers.deposit.db.domain.TransactionStatus;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Transient;
import org.hibernate.annotations.UpdateTimestamp;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.jpa.convert.threeten.Jsr310JpaConverters;

@Entity
public class Payment {
    @Id
    private String paymentId;
    private Boolean batchBookingPreferred;
    @JsonDeserialize(using=LocalDateDeserializer.class)
    @Convert(converter=Jsr310JpaConverters.LocalDateConverter.class)
    private LocalDate requestedExecutionDate;
    private LocalTime requestedExecutionTime;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false)
    private PaymentType paymentType;
    private String paymentProduct;
    @JsonDeserialize(using=LocalDateDeserializer.class)
    @Convert(converter=Jsr310JpaConverters.LocalDateConverter.class)
    private LocalDate startDate;
    @JsonDeserialize(using=LocalDateDeserializer.class)
    @Convert(converter=Jsr310JpaConverters.LocalDateConverter.class)
    private LocalDate endDate;
    private String executionRule;
    @Enumerated(value=EnumType.STRING)
    private FrequencyCode frequency;
    private Integer dayOfExecution;
    private LocalDateTime executedDate;
    private LocalDateTime nextScheduledExecution;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="iban", column=@Column(name="DEBT_IBAN")), @AttributeOverride(name="bban", column=@Column(name="DEBT_BBAN")), @AttributeOverride(name="pan", column=@Column(name="DEBT_PAN")), @AttributeOverride(name="maskedPan", column=@Column(name="DEBT_MASKED_PAN")), @AttributeOverride(name="msisdn", column=@Column(name="DEBT_MSISDN"))})
    @Column(nullable=false)
    @NotNull
    private AccountReference debtorAccount;
    private String debtorName;
    private String debtorAgent;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false)
    private TransactionStatus transactionStatus;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private List<PaymentTarget> targets = new ArrayList<PaymentTarget>();
    @Column(nullable=false)
    private String accountId;
    @Column
    @UpdateTimestamp
    private LocalDateTime updated;
    @Transient
    private TransactionStatus previousTransactionStatus;

    public boolean isLastExecuted(LocalDate nextPossibleExecutionDate) {
        return this.endDate != null && nextPossibleExecutionDate.isAfter(this.endDate);
    }

    @PostLoad
    public void paymentPostLoad() {
        this.previousTransactionStatus = this.transactionStatus;
    }

    @PreUpdate
    public void paymentPreUpdate() {
        if (this.previousTransactionStatus != this.transactionStatus) {
            this.updated = LocalDateTime.now();
        }
    }

    @PrePersist
    public void paymentPrePersist() {
        if (this.updated == null) {
            this.updated = LocalDateTime.now();
        }
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public Boolean getBatchBookingPreferred() {
        return this.batchBookingPreferred;
    }

    public LocalDate getRequestedExecutionDate() {
        return this.requestedExecutionDate;
    }

    public LocalTime getRequestedExecutionTime() {
        return this.requestedExecutionTime;
    }

    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    public String getPaymentProduct() {
        return this.paymentProduct;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public String getExecutionRule() {
        return this.executionRule;
    }

    public FrequencyCode getFrequency() {
        return this.frequency;
    }

    public Integer getDayOfExecution() {
        return this.dayOfExecution;
    }

    public LocalDateTime getExecutedDate() {
        return this.executedDate;
    }

    public LocalDateTime getNextScheduledExecution() {
        return this.nextScheduledExecution;
    }

    public AccountReference getDebtorAccount() {
        return this.debtorAccount;
    }

    public String getDebtorName() {
        return this.debtorName;
    }

    public String getDebtorAgent() {
        return this.debtorAgent;
    }

    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public List<PaymentTarget> getTargets() {
        return this.targets;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public LocalDateTime getUpdated() {
        return this.updated;
    }

    public TransactionStatus getPreviousTransactionStatus() {
        return this.previousTransactionStatus;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public void setBatchBookingPreferred(Boolean batchBookingPreferred) {
        this.batchBookingPreferred = batchBookingPreferred;
    }

    public void setRequestedExecutionDate(LocalDate requestedExecutionDate) {
        this.requestedExecutionDate = requestedExecutionDate;
    }

    public void setRequestedExecutionTime(LocalTime requestedExecutionTime) {
        this.requestedExecutionTime = requestedExecutionTime;
    }

    public void setPaymentType(PaymentType paymentType) {
        this.paymentType = paymentType;
    }

    public void setPaymentProduct(String paymentProduct) {
        this.paymentProduct = paymentProduct;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public void setExecutionRule(String executionRule) {
        this.executionRule = executionRule;
    }

    public void setFrequency(FrequencyCode frequency) {
        this.frequency = frequency;
    }

    public void setDayOfExecution(Integer dayOfExecution) {
        this.dayOfExecution = dayOfExecution;
    }

    public void setExecutedDate(LocalDateTime executedDate) {
        this.executedDate = executedDate;
    }

    public void setNextScheduledExecution(LocalDateTime nextScheduledExecution) {
        this.nextScheduledExecution = nextScheduledExecution;
    }

    public void setDebtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public void setDebtorName(String debtorName) {
        this.debtorName = debtorName;
    }

    public void setDebtorAgent(String debtorAgent) {
        this.debtorAgent = debtorAgent;
    }

    public void setTransactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public void setTargets(List<PaymentTarget> targets) {
        this.targets = targets;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public void setUpdated(LocalDateTime updated) {
        this.updated = updated;
    }

    public void setPreviousTransactionStatus(TransactionStatus previousTransactionStatus) {
        this.previousTransactionStatus = previousTransactionStatus;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Payment)) {
            return false;
        }
        Payment other = (Payment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$paymentId = this.getPaymentId();
        String other$paymentId = other.getPaymentId();
        if (this$paymentId == null ? other$paymentId != null : !this$paymentId.equals(other$paymentId)) {
            return false;
        }
        Boolean this$batchBookingPreferred = this.getBatchBookingPreferred();
        Boolean other$batchBookingPreferred = other.getBatchBookingPreferred();
        if (this$batchBookingPreferred == null ? other$batchBookingPreferred != null : !((Object)this$batchBookingPreferred).equals(other$batchBookingPreferred)) {
            return false;
        }
        LocalDate this$requestedExecutionDate = this.getRequestedExecutionDate();
        LocalDate other$requestedExecutionDate = other.getRequestedExecutionDate();
        if (this$requestedExecutionDate == null ? other$requestedExecutionDate != null : !((Object)this$requestedExecutionDate).equals(other$requestedExecutionDate)) {
            return false;
        }
        LocalTime this$requestedExecutionTime = this.getRequestedExecutionTime();
        LocalTime other$requestedExecutionTime = other.getRequestedExecutionTime();
        if (this$requestedExecutionTime == null ? other$requestedExecutionTime != null : !((Object)this$requestedExecutionTime).equals(other$requestedExecutionTime)) {
            return false;
        }
        PaymentType this$paymentType = this.getPaymentType();
        PaymentType other$paymentType = other.getPaymentType();
        if (this$paymentType == null ? other$paymentType != null : !((Object)((Object)this$paymentType)).equals((Object)other$paymentType)) {
            return false;
        }
        String this$paymentProduct = this.getPaymentProduct();
        String other$paymentProduct = other.getPaymentProduct();
        if (this$paymentProduct == null ? other$paymentProduct != null : !this$paymentProduct.equals(other$paymentProduct)) {
            return false;
        }
        LocalDate this$startDate = this.getStartDate();
        LocalDate other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        LocalDate this$endDate = this.getEndDate();
        LocalDate other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        String this$executionRule = this.getExecutionRule();
        String other$executionRule = other.getExecutionRule();
        if (this$executionRule == null ? other$executionRule != null : !this$executionRule.equals(other$executionRule)) {
            return false;
        }
        FrequencyCode this$frequency = this.getFrequency();
        FrequencyCode other$frequency = other.getFrequency();
        if (this$frequency == null ? other$frequency != null : !((Object)((Object)this$frequency)).equals((Object)other$frequency)) {
            return false;
        }
        Integer this$dayOfExecution = this.getDayOfExecution();
        Integer other$dayOfExecution = other.getDayOfExecution();
        if (this$dayOfExecution == null ? other$dayOfExecution != null : !((Object)this$dayOfExecution).equals(other$dayOfExecution)) {
            return false;
        }
        LocalDateTime this$executedDate = this.getExecutedDate();
        LocalDateTime other$executedDate = other.getExecutedDate();
        if (this$executedDate == null ? other$executedDate != null : !((Object)this$executedDate).equals(other$executedDate)) {
            return false;
        }
        LocalDateTime this$nextScheduledExecution = this.getNextScheduledExecution();
        LocalDateTime other$nextScheduledExecution = other.getNextScheduledExecution();
        if (this$nextScheduledExecution == null ? other$nextScheduledExecution != null : !((Object)this$nextScheduledExecution).equals(other$nextScheduledExecution)) {
            return false;
        }
        AccountReference this$debtorAccount = this.getDebtorAccount();
        AccountReference other$debtorAccount = other.getDebtorAccount();
        if (this$debtorAccount == null ? other$debtorAccount != null : !((Object)this$debtorAccount).equals(other$debtorAccount)) {
            return false;
        }
        String this$debtorName = this.getDebtorName();
        String other$debtorName = other.getDebtorName();
        if (this$debtorName == null ? other$debtorName != null : !this$debtorName.equals(other$debtorName)) {
            return false;
        }
        String this$debtorAgent = this.getDebtorAgent();
        String other$debtorAgent = other.getDebtorAgent();
        if (this$debtorAgent == null ? other$debtorAgent != null : !this$debtorAgent.equals(other$debtorAgent)) {
            return false;
        }
        TransactionStatus this$transactionStatus = this.getTransactionStatus();
        TransactionStatus other$transactionStatus = other.getTransactionStatus();
        if (this$transactionStatus == null ? other$transactionStatus != null : !((Object)((Object)this$transactionStatus)).equals((Object)other$transactionStatus)) {
            return false;
        }
        List<PaymentTarget> this$targets = this.getTargets();
        List<PaymentTarget> other$targets = other.getTargets();
        if (this$targets == null ? other$targets != null : !((Object)this$targets).equals(other$targets)) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
            return false;
        }
        LocalDateTime this$updated = this.getUpdated();
        LocalDateTime other$updated = other.getUpdated();
        if (this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated)) {
            return false;
        }
        TransactionStatus this$previousTransactionStatus = this.getPreviousTransactionStatus();
        TransactionStatus other$previousTransactionStatus = other.getPreviousTransactionStatus();
        return !(this$previousTransactionStatus == null ? other$previousTransactionStatus != null : !((Object)((Object)this$previousTransactionStatus)).equals((Object)other$previousTransactionStatus));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Payment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $paymentId = this.getPaymentId();
        result = result * 59 + ($paymentId == null ? 43 : $paymentId.hashCode());
        Boolean $batchBookingPreferred = this.getBatchBookingPreferred();
        result = result * 59 + ($batchBookingPreferred == null ? 43 : ((Object)$batchBookingPreferred).hashCode());
        LocalDate $requestedExecutionDate = this.getRequestedExecutionDate();
        result = result * 59 + ($requestedExecutionDate == null ? 43 : ((Object)$requestedExecutionDate).hashCode());
        LocalTime $requestedExecutionTime = this.getRequestedExecutionTime();
        result = result * 59 + ($requestedExecutionTime == null ? 43 : ((Object)$requestedExecutionTime).hashCode());
        PaymentType $paymentType = this.getPaymentType();
        result = result * 59 + ($paymentType == null ? 43 : ((Object)((Object)$paymentType)).hashCode());
        String $paymentProduct = this.getPaymentProduct();
        result = result * 59 + ($paymentProduct == null ? 43 : $paymentProduct.hashCode());
        LocalDate $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        LocalDate $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        String $executionRule = this.getExecutionRule();
        result = result * 59 + ($executionRule == null ? 43 : $executionRule.hashCode());
        FrequencyCode $frequency = this.getFrequency();
        result = result * 59 + ($frequency == null ? 43 : ((Object)((Object)$frequency)).hashCode());
        Integer $dayOfExecution = this.getDayOfExecution();
        result = result * 59 + ($dayOfExecution == null ? 43 : ((Object)$dayOfExecution).hashCode());
        LocalDateTime $executedDate = this.getExecutedDate();
        result = result * 59 + ($executedDate == null ? 43 : ((Object)$executedDate).hashCode());
        LocalDateTime $nextScheduledExecution = this.getNextScheduledExecution();
        result = result * 59 + ($nextScheduledExecution == null ? 43 : ((Object)$nextScheduledExecution).hashCode());
        AccountReference $debtorAccount = this.getDebtorAccount();
        result = result * 59 + ($debtorAccount == null ? 43 : ((Object)$debtorAccount).hashCode());
        String $debtorName = this.getDebtorName();
        result = result * 59 + ($debtorName == null ? 43 : $debtorName.hashCode());
        String $debtorAgent = this.getDebtorAgent();
        result = result * 59 + ($debtorAgent == null ? 43 : $debtorAgent.hashCode());
        TransactionStatus $transactionStatus = this.getTransactionStatus();
        result = result * 59 + ($transactionStatus == null ? 43 : ((Object)((Object)$transactionStatus)).hashCode());
        List<PaymentTarget> $targets = this.getTargets();
        result = result * 59 + ($targets == null ? 43 : ((Object)$targets).hashCode());
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        LocalDateTime $updated = this.getUpdated();
        result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
        TransactionStatus $previousTransactionStatus = this.getPreviousTransactionStatus();
        result = result * 59 + ($previousTransactionStatus == null ? 43 : ((Object)((Object)$previousTransactionStatus)).hashCode());
        return result;
    }

    public String toString() {
        return "Payment(paymentId=" + this.getPaymentId() + ", batchBookingPreferred=" + this.getBatchBookingPreferred() + ", requestedExecutionDate=" + this.getRequestedExecutionDate() + ", requestedExecutionTime=" + this.getRequestedExecutionTime() + ", paymentType=" + (Object)((Object)this.getPaymentType()) + ", paymentProduct=" + this.getPaymentProduct() + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ", executionRule=" + this.getExecutionRule() + ", frequency=" + (Object)((Object)this.getFrequency()) + ", dayOfExecution=" + this.getDayOfExecution() + ", executedDate=" + this.getExecutedDate() + ", nextScheduledExecution=" + this.getNextScheduledExecution() + ", debtorAccount=" + this.getDebtorAccount() + ", debtorName=" + this.getDebtorName() + ", debtorAgent=" + this.getDebtorAgent() + ", transactionStatus=" + (Object)((Object)this.getTransactionStatus()) + ", targets=" + this.getTargets() + ", accountId=" + this.getAccountId() + ", updated=" + this.getUpdated() + ", previousTransactionStatus=" + (Object)((Object)this.getPreviousTransactionStatus()) + ")";
    }
}

