/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.db.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class AccountType
extends Enum<AccountType> {
    public static final /* enum */ AccountType CACC;
    public static final /* enum */ AccountType CASH;
    public static final /* enum */ AccountType CHAR;
    public static final /* enum */ AccountType CISH;
    public static final /* enum */ AccountType COMM;
    public static final /* enum */ AccountType CPAC;
    public static final /* enum */ AccountType LLSV;
    public static final /* enum */ AccountType LOAN;
    public static final /* enum */ AccountType MGLD;
    public static final /* enum */ AccountType MOMA;
    public static final /* enum */ AccountType NREX;
    public static final /* enum */ AccountType ODFT;
    public static final /* enum */ AccountType ONDP;
    public static final /* enum */ AccountType OTHR;
    public static final /* enum */ AccountType SACC;
    public static final /* enum */ AccountType SLRY;
    public static final /* enum */ AccountType SVGS;
    public static final /* enum */ AccountType TAXE;
    public static final /* enum */ AccountType TRAN;
    public static final /* enum */ AccountType TRAS;
    private static final Map<String, AccountType> container;
    private String value;
    private static final /* synthetic */ AccountType[] $VALUES;

    public static AccountType[] values() {
        return (AccountType[])$VALUES.clone();
    }

    public static AccountType valueOf(String name) {
        return Enum.valueOf(AccountType.class, name);
    }

    @JsonCreator
    private AccountType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    @JsonIgnore
    public static Optional<AccountType> getByValue(String value) {
        return Optional.ofNullable(container.get(value));
    }

    static {
        AccountType[] var0;
        CACC = new AccountType("Current");
        CASH = new AccountType("CashPayment");
        CHAR = new AccountType("Charges");
        CISH = new AccountType("CashIncome");
        COMM = new AccountType("Commission");
        CPAC = new AccountType("ClearingParticipantSettlementAccount");
        LLSV = new AccountType("LimitedLiquiditySavingsAccount");
        LOAN = new AccountType("Loan");
        MGLD = new AccountType("Marginal Lending");
        MOMA = new AccountType("Money Market");
        NREX = new AccountType("NonResidentExternal");
        ODFT = new AccountType("Overdraft");
        ONDP = new AccountType("OverNightDeposit");
        OTHR = new AccountType("OtherAccount");
        SACC = new AccountType("Settlement");
        SLRY = new AccountType("Salary");
        SVGS = new AccountType("Savings");
        TAXE = new AccountType("Tax");
        TRAN = new AccountType("TransactingAccount");
        TRAS = new AccountType("Cash Trading");
        $VALUES = new AccountType[]{CACC, CASH, CHAR, CISH, COMM, CPAC, LLSV, LOAN, MGLD, MOMA, NREX, ODFT, ONDP, OTHR, SACC, SLRY, SVGS, TAXE, TRAN, TRAS};
        container = new HashMap<String, AccountType>();
        for (AccountType accountType : var0 = AccountType.values()) {
            container.put(accountType.getValue(), accountType);
        }
    }
}

