/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.db.domain;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import de.adorsys.ledgers.deposit.db.domain.AccountReference;
import de.adorsys.ledgers.deposit.db.domain.FrequencyCode;
import de.adorsys.ledgers.deposit.db.domain.PaymentProduct;
import de.adorsys.ledgers.deposit.db.domain.PaymentTarget;
import de.adorsys.ledgers.deposit.db.domain.PaymentType;
import de.adorsys.ledgers.deposit.db.domain.TransactionStatus;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.jpa.convert.threeten.Jsr310JpaConverters;

@Entity
public class Payment {
    @Id
    private String paymentId;
    private Boolean batchBookingPreferred;
    @JsonDeserialize(using=LocalDateDeserializer.class)
    @Convert(converter=Jsr310JpaConverters.LocalDateConverter.class)
    private LocalDate requestedExecutionDate;
    private LocalTime requestedExecutionTime;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false)
    private PaymentType paymentType;
    @JsonDeserialize(using=LocalDateDeserializer.class)
    @Convert(converter=Jsr310JpaConverters.LocalDateConverter.class)
    private LocalDate startDate;
    @JsonDeserialize(using=LocalDateDeserializer.class)
    @Convert(converter=Jsr310JpaConverters.LocalDateConverter.class)
    private LocalDate endDate;
    private String executionRule;
    @Enumerated(value=EnumType.STRING)
    private FrequencyCode frequency;
    private Integer dayOfExecution;
    private LocalDateTime executedDate;
    private LocalDateTime nextScheduledExecution;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="iban", column=@Column(name="DEBT_IBAN")), @AttributeOverride(name="bban", column=@Column(name="DEBT_BBAN")), @AttributeOverride(name="pan", column=@Column(name="DEBT_PAN")), @AttributeOverride(name="maskedPan", column=@Column(name="DEBT_MASKED_PAN")), @AttributeOverride(name="msisdn", column=@Column(name="DEBT_MSISDN"))})
    @Column(nullable=false)
    @NotNull
    private AccountReference debtorAccount;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false)
    private TransactionStatus transactionStatus;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private List<PaymentTarget> targets = new ArrayList<PaymentTarget>();

    public boolean isInstant() {
        return this.getTargets().stream().findFirst().map(t -> t.getPaymentProduct() == PaymentProduct.INSTANT_SEPA || t.getPaymentProduct() == PaymentProduct.TARGET2).orElse(false);
    }

    public boolean isLastExecuted(LocalDate nextPossibleExecutionDate) {
        return this.endDate != null && nextPossibleExecutionDate.isAfter(this.endDate);
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public Boolean getBatchBookingPreferred() {
        return this.batchBookingPreferred;
    }

    public LocalDate getRequestedExecutionDate() {
        return this.requestedExecutionDate;
    }

    public LocalTime getRequestedExecutionTime() {
        return this.requestedExecutionTime;
    }

    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public String getExecutionRule() {
        return this.executionRule;
    }

    public FrequencyCode getFrequency() {
        return this.frequency;
    }

    public Integer getDayOfExecution() {
        return this.dayOfExecution;
    }

    public LocalDateTime getExecutedDate() {
        return this.executedDate;
    }

    public LocalDateTime getNextScheduledExecution() {
        return this.nextScheduledExecution;
    }

    public AccountReference getDebtorAccount() {
        return this.debtorAccount;
    }

    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public List<PaymentTarget> getTargets() {
        return this.targets;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public void setBatchBookingPreferred(Boolean batchBookingPreferred) {
        this.batchBookingPreferred = batchBookingPreferred;
    }

    public void setRequestedExecutionDate(LocalDate requestedExecutionDate) {
        this.requestedExecutionDate = requestedExecutionDate;
    }

    public void setRequestedExecutionTime(LocalTime requestedExecutionTime) {
        this.requestedExecutionTime = requestedExecutionTime;
    }

    public void setPaymentType(PaymentType paymentType) {
        this.paymentType = paymentType;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public void setExecutionRule(String executionRule) {
        this.executionRule = executionRule;
    }

    public void setFrequency(FrequencyCode frequency) {
        this.frequency = frequency;
    }

    public void setDayOfExecution(Integer dayOfExecution) {
        this.dayOfExecution = dayOfExecution;
    }

    public void setExecutedDate(LocalDateTime executedDate) {
        this.executedDate = executedDate;
    }

    public void setNextScheduledExecution(LocalDateTime nextScheduledExecution) {
        this.nextScheduledExecution = nextScheduledExecution;
    }

    public void setDebtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public void setTransactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public void setTargets(List<PaymentTarget> targets) {
        this.targets = targets;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Payment)) {
            return false;
        }
        Payment other = (Payment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$paymentId = this.getPaymentId();
        String other$paymentId = other.getPaymentId();
        if (this$paymentId == null ? other$paymentId != null : !this$paymentId.equals(other$paymentId)) {
            return false;
        }
        Boolean this$batchBookingPreferred = this.getBatchBookingPreferred();
        Boolean other$batchBookingPreferred = other.getBatchBookingPreferred();
        if (this$batchBookingPreferred == null ? other$batchBookingPreferred != null : !((Object)this$batchBookingPreferred).equals(other$batchBookingPreferred)) {
            return false;
        }
        LocalDate this$requestedExecutionDate = this.getRequestedExecutionDate();
        LocalDate other$requestedExecutionDate = other.getRequestedExecutionDate();
        if (this$requestedExecutionDate == null ? other$requestedExecutionDate != null : !((Object)this$requestedExecutionDate).equals(other$requestedExecutionDate)) {
            return false;
        }
        LocalTime this$requestedExecutionTime = this.getRequestedExecutionTime();
        LocalTime other$requestedExecutionTime = other.getRequestedExecutionTime();
        if (this$requestedExecutionTime == null ? other$requestedExecutionTime != null : !((Object)this$requestedExecutionTime).equals(other$requestedExecutionTime)) {
            return false;
        }
        PaymentType this$paymentType = this.getPaymentType();
        PaymentType other$paymentType = other.getPaymentType();
        if (this$paymentType == null ? other$paymentType != null : !((Object)((Object)this$paymentType)).equals((Object)other$paymentType)) {
            return false;
        }
        LocalDate this$startDate = this.getStartDate();
        LocalDate other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        LocalDate this$endDate = this.getEndDate();
        LocalDate other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        String this$executionRule = this.getExecutionRule();
        String other$executionRule = other.getExecutionRule();
        if (this$executionRule == null ? other$executionRule != null : !this$executionRule.equals(other$executionRule)) {
            return false;
        }
        FrequencyCode this$frequency = this.getFrequency();
        FrequencyCode other$frequency = other.getFrequency();
        if (this$frequency == null ? other$frequency != null : !((Object)((Object)this$frequency)).equals((Object)other$frequency)) {
            return false;
        }
        Integer this$dayOfExecution = this.getDayOfExecution();
        Integer other$dayOfExecution = other.getDayOfExecution();
        if (this$dayOfExecution == null ? other$dayOfExecution != null : !((Object)this$dayOfExecution).equals(other$dayOfExecution)) {
            return false;
        }
        LocalDateTime this$executedDate = this.getExecutedDate();
        LocalDateTime other$executedDate = other.getExecutedDate();
        if (this$executedDate == null ? other$executedDate != null : !((Object)this$executedDate).equals(other$executedDate)) {
            return false;
        }
        LocalDateTime this$nextScheduledExecution = this.getNextScheduledExecution();
        LocalDateTime other$nextScheduledExecution = other.getNextScheduledExecution();
        if (this$nextScheduledExecution == null ? other$nextScheduledExecution != null : !((Object)this$nextScheduledExecution).equals(other$nextScheduledExecution)) {
            return false;
        }
        AccountReference this$debtorAccount = this.getDebtorAccount();
        AccountReference other$debtorAccount = other.getDebtorAccount();
        if (this$debtorAccount == null ? other$debtorAccount != null : !((Object)this$debtorAccount).equals(other$debtorAccount)) {
            return false;
        }
        TransactionStatus this$transactionStatus = this.getTransactionStatus();
        TransactionStatus other$transactionStatus = other.getTransactionStatus();
        if (this$transactionStatus == null ? other$transactionStatus != null : !((Object)((Object)this$transactionStatus)).equals((Object)other$transactionStatus)) {
            return false;
        }
        List<PaymentTarget> this$targets = this.getTargets();
        List<PaymentTarget> other$targets = other.getTargets();
        return !(this$targets == null ? other$targets != null : !((Object)this$targets).equals(other$targets));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Payment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $paymentId = this.getPaymentId();
        result = result * 59 + ($paymentId == null ? 43 : $paymentId.hashCode());
        Boolean $batchBookingPreferred = this.getBatchBookingPreferred();
        result = result * 59 + ($batchBookingPreferred == null ? 43 : ((Object)$batchBookingPreferred).hashCode());
        LocalDate $requestedExecutionDate = this.getRequestedExecutionDate();
        result = result * 59 + ($requestedExecutionDate == null ? 43 : ((Object)$requestedExecutionDate).hashCode());
        LocalTime $requestedExecutionTime = this.getRequestedExecutionTime();
        result = result * 59 + ($requestedExecutionTime == null ? 43 : ((Object)$requestedExecutionTime).hashCode());
        PaymentType $paymentType = this.getPaymentType();
        result = result * 59 + ($paymentType == null ? 43 : ((Object)((Object)$paymentType)).hashCode());
        LocalDate $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        LocalDate $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        String $executionRule = this.getExecutionRule();
        result = result * 59 + ($executionRule == null ? 43 : $executionRule.hashCode());
        FrequencyCode $frequency = this.getFrequency();
        result = result * 59 + ($frequency == null ? 43 : ((Object)((Object)$frequency)).hashCode());
        Integer $dayOfExecution = this.getDayOfExecution();
        result = result * 59 + ($dayOfExecution == null ? 43 : ((Object)$dayOfExecution).hashCode());
        LocalDateTime $executedDate = this.getExecutedDate();
        result = result * 59 + ($executedDate == null ? 43 : ((Object)$executedDate).hashCode());
        LocalDateTime $nextScheduledExecution = this.getNextScheduledExecution();
        result = result * 59 + ($nextScheduledExecution == null ? 43 : ((Object)$nextScheduledExecution).hashCode());
        AccountReference $debtorAccount = this.getDebtorAccount();
        result = result * 59 + ($debtorAccount == null ? 43 : ((Object)$debtorAccount).hashCode());
        TransactionStatus $transactionStatus = this.getTransactionStatus();
        result = result * 59 + ($transactionStatus == null ? 43 : ((Object)((Object)$transactionStatus)).hashCode());
        List<PaymentTarget> $targets = this.getTargets();
        result = result * 59 + ($targets == null ? 43 : ((Object)$targets).hashCode());
        return result;
    }

    public String toString() {
        return "Payment(paymentId=" + this.getPaymentId() + ", batchBookingPreferred=" + this.getBatchBookingPreferred() + ", requestedExecutionDate=" + this.getRequestedExecutionDate() + ", requestedExecutionTime=" + this.getRequestedExecutionTime() + ", paymentType=" + (Object)((Object)this.getPaymentType()) + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ", executionRule=" + this.getExecutionRule() + ", frequency=" + (Object)((Object)this.getFrequency()) + ", dayOfExecution=" + this.getDayOfExecution() + ", executedDate=" + this.getExecutedDate() + ", nextScheduledExecution=" + this.getNextScheduledExecution() + ", debtorAccount=" + this.getDebtorAccount() + ", transactionStatus=" + (Object)((Object)this.getTransactionStatus()) + ", targets=" + this.getTargets() + ")";
    }
}

