/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.db.domain;

import de.adorsys.ledgers.deposit.db.domain.AccountStatus;
import de.adorsys.ledgers.deposit.db.domain.AccountType;
import de.adorsys.ledgers.deposit.db.domain.AccountUsage;
import java.util.Currency;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"iban", "currency"}, name="DepositAccount_iban_currency_unique")})
public class DepositAccount {
    @Id
    private String id;
    @Column(nullable=false)
    private String iban;
    private String msisdn;
    @Column(nullable=false)
    private String currency;
    private String name;
    private String product;
    private String branch;
    @Enumerated(value=EnumType.STRING)
    private AccountType accountType;
    @Enumerated(value=EnumType.STRING)
    @Column(name="account_status", nullable=false)
    private AccountStatus accountStatus = AccountStatus.ENABLED;
    private String bic;
    private String linkedAccounts;
    @Enumerated(value=EnumType.STRING)
    private AccountUsage usageType;
    private String details;

    public DepositAccount(String id, String iban, String msisdn, Currency currency, String name, String product, AccountType accountType, AccountStatus accountStatus, String bic, String linkedAccounts, AccountUsage usageType, String details) {
        this.id = id;
        this.iban = iban;
        this.msisdn = msisdn;
        this.currency = currency.getCurrencyCode();
        this.name = name;
        this.product = product;
        this.accountType = accountType;
        this.accountStatus = accountStatus;
        this.bic = bic;
        this.linkedAccounts = linkedAccounts;
        this.usageType = usageType;
        this.details = details;
    }

    public DepositAccount() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIban() {
        return this.iban;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public String getMsisdn() {
        return this.msisdn;
    }

    public void setMsisdn(String msisdn) {
        this.msisdn = msisdn;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public AccountType getAccountType() {
        return this.accountType;
    }

    public void setAccountType(AccountType accountType) {
        this.accountType = accountType;
    }

    public AccountStatus getAccountStatus() {
        return this.accountStatus;
    }

    public void setAccountStatus(AccountStatus accountStatus) {
        this.accountStatus = accountStatus;
    }

    public String getBic() {
        return this.bic;
    }

    public void setBic(String bic) {
        this.bic = bic;
    }

    public String getLinkedAccounts() {
        return this.linkedAccounts;
    }

    public void setLinkedAccounts(String linkedAccounts) {
        this.linkedAccounts = linkedAccounts;
    }

    public AccountUsage getUsageType() {
        return this.usageType;
    }

    public void setUsageType(AccountUsage usageType) {
        this.usageType = usageType;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }
}

