/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.db.domain;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public enum PaymentProduct {
    SEPA("sepa-credit-transfers"),
    INSTANT_SEPA("instant-sepa-credit-transfers"),
    TARGET2("target-2-payments"),
    CROSS_BORDER("cross-border-credit-transfers");

    private String value;
    private static Map<String, PaymentProduct> container;

    private PaymentProduct(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static PaymentProduct getByValue(String value) {
        return container.get(value);
    }

    static {
        container = new HashMap<String, PaymentProduct>();
        Arrays.stream(PaymentProduct.values()).forEach(product -> container.put(product.getValue(), (PaymentProduct)((Object)product)));
    }
}

