/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.db.domain;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import de.adorsys.ledgers.deposit.db.domain.AccountReference;
import de.adorsys.ledgers.deposit.db.domain.FrequencyCode;
import de.adorsys.ledgers.deposit.db.domain.PaymentProduct;
import de.adorsys.ledgers.deposit.db.domain.PaymentTarget;
import de.adorsys.ledgers.deposit.db.domain.PaymentType;
import de.adorsys.ledgers.deposit.db.domain.TransactionStatus;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.jpa.convert.threeten.Jsr310JpaConverters;

@Entity
public class Payment {
    @Id
    private String paymentId;
    private Boolean batchBookingPreferred;
    @JsonDeserialize(using=LocalDateDeserializer.class)
    @Convert(converter=Jsr310JpaConverters.LocalDateConverter.class)
    private LocalDate requestedExecutionDate;
    private LocalTime requestedExecutionTime;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false)
    private PaymentType paymentType;
    @JsonDeserialize(using=LocalDateDeserializer.class)
    @Convert(converter=Jsr310JpaConverters.LocalDateConverter.class)
    private LocalDate startDate;
    @JsonDeserialize(using=LocalDateDeserializer.class)
    @Convert(converter=Jsr310JpaConverters.LocalDateConverter.class)
    private LocalDate endDate;
    private String executionRule;
    @Enumerated(value=EnumType.STRING)
    private FrequencyCode frequency;
    private Integer dayOfExecution;
    private LocalDateTime executedDate;
    private LocalDateTime nextScheduledExecution;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="iban", column=@Column(name="DEBT_IBAN")), @AttributeOverride(name="bban", column=@Column(name="DEBT_BBAN")), @AttributeOverride(name="pan", column=@Column(name="DEBT_PAN")), @AttributeOverride(name="maskedPan", column=@Column(name="DEBT_MASKED_PAN")), @AttributeOverride(name="msisdn", column=@Column(name="DEBT_MSISDN"))})
    @Column(nullable=false)
    @NotNull
    private AccountReference debtorAccount;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false)
    private TransactionStatus transactionStatus;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private List<PaymentTarget> targets = new ArrayList<PaymentTarget>();

    public boolean isInstant() {
        return this.getTargets().stream().findFirst().map(t -> t.getPaymentProduct() == PaymentProduct.INSTANT_SEPA || t.getPaymentProduct() == PaymentProduct.TARGET2).orElse(false);
    }

    public boolean isLastExecuted(LocalDate nextPossibleExecutionDate) {
        return this.endDate != null && nextPossibleExecutionDate.isAfter(this.endDate);
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public Boolean getBatchBookingPreferred() {
        return this.batchBookingPreferred;
    }

    public void setBatchBookingPreferred(Boolean batchBookingPreferred) {
        this.batchBookingPreferred = batchBookingPreferred;
    }

    public LocalDate getRequestedExecutionDate() {
        return this.requestedExecutionDate;
    }

    public void setRequestedExecutionDate(LocalDate requestedExecutionDate) {
        this.requestedExecutionDate = requestedExecutionDate;
    }

    public LocalTime getRequestedExecutionTime() {
        return this.requestedExecutionTime;
    }

    public void setRequestedExecutionTime(LocalTime requestedExecutionTime) {
        this.requestedExecutionTime = requestedExecutionTime;
    }

    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(PaymentType paymentType) {
        this.paymentType = paymentType;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public String getExecutionRule() {
        return this.executionRule;
    }

    public void setExecutionRule(String executionRule) {
        this.executionRule = executionRule;
    }

    public FrequencyCode getFrequency() {
        return this.frequency;
    }

    public void setFrequency(FrequencyCode frequency) {
        this.frequency = frequency;
    }

    public Integer getDayOfExecution() {
        return this.dayOfExecution;
    }

    public void setDayOfExecution(Integer dayOfExecution) {
        this.dayOfExecution = dayOfExecution;
    }

    public LocalDateTime getExecutedDate() {
        return this.executedDate;
    }

    public void setExecutedDate(LocalDateTime executedDate) {
        this.executedDate = executedDate;
    }

    public LocalDateTime getNextScheduledExecution() {
        return this.nextScheduledExecution;
    }

    public void setNextScheduledExecution(LocalDateTime nextScheduledExecution) {
        this.nextScheduledExecution = nextScheduledExecution;
    }

    public AccountReference getDebtorAccount() {
        return this.debtorAccount;
    }

    public void setDebtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public void setTransactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public List<PaymentTarget> getTargets() {
        return this.targets;
    }

    public void setTargets(List<PaymentTarget> targets) {
        this.targets = targets;
    }
}

