/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.cleanup.repository;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.ResourceLoader;

public class BaseCleanupRepository {
    @PersistenceContext
    private final EntityManager entityManager;
    private final ResourceLoader resourceLoader;

    public BaseCleanupRepository(EntityManager entityManager, ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        this.entityManager = entityManager;
    }

    protected void executeUpdate(String queryFilePath, Map<Integer, Object> params) throws IOException {
        String query = this.loadQuery(queryFilePath);
        Query nativeQuery = this.entityManager.createNativeQuery(query);
        params.keySet().forEach(param -> nativeQuery.setParameter(param.intValue(), params.get(param)));
        nativeQuery.executeUpdate();
    }

    private String loadQuery(String queryFilePath) throws IOException {
        InputStream stream = this.resourceLoader.getResource("classpath:sql/" + queryFilePath).getInputStream();
        return IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
    }
}

