/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.cleanup.repository;

import de.adorsys.ledgers.cleanup.DepositAccountCleanupRepository;
import de.adorsys.ledgers.cleanup.exception.CleanupModuleException;
import de.adorsys.ledgers.cleanup.repository.BaseCleanupRepository;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Map;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Service;

@Service
public class DepositAccountCleanupRepositoryImpl
extends BaseCleanupRepository
implements DepositAccountCleanupRepository {
    private static final Logger log = LoggerFactory.getLogger(DepositAccountCleanupRepositoryImpl.class);
    private static final String BRANCH_SQL = "deleteBranch.sql";
    private static final String ROLL_BACK_BRANCH_SQL = "rollBackBranch.sql";
    private static final String POSTING_SQL = "deletePostings.sql";
    private static final String USER_SQL = "deleteUser.sql";
    private static final String ACCOUNT_SQL = "deleteAccount.sql";
    private static final String DELETE_BRANCH_ERROR_MSG = "Something went wrong during deletion of branch: %s, msg: %s";
    private static final String ROLL_BACK_BRANCH_ERROR_MSG = "Something went wrong during rollback of branch: %s, msg: %s";
    private static final String DELETE_POSTINGS_ERROR_MSG = "Something went wrong during deletion of postings for iban: %s, msg: %s";
    private static final String DELETE_USER_ERROR_MSG = "Something went wrong during deletion of user: %s, msg: %s";
    private static final String DELETE_ACCOUNT_ERROR_MSG = "Something went wrong during deletion of account: %s, msg: %s";

    public DepositAccountCleanupRepositoryImpl(EntityManager entityManager, ResourceLoader resourceLoader) {
        super(entityManager, resourceLoader);
    }

    @Override
    public void deleteBranch(String branchId) throws CleanupModuleException {
        try {
            this.executeUpdate(BRANCH_SQL, Map.of(1, branchId));
        }
        catch (IOException e) {
            throw CleanupModuleException.builder().devMsg(String.format(DELETE_BRANCH_ERROR_MSG, branchId, e.getMessage())).build();
        }
    }

    @Override
    public void deleteUser(String userId) throws CleanupModuleException {
        try {
            this.executeUpdate(USER_SQL, Map.of(1, userId));
        }
        catch (IOException e) {
            throw CleanupModuleException.builder().devMsg(String.format(DELETE_USER_ERROR_MSG, userId, e.getMessage())).build();
        }
    }

    @Override
    public void deleteAccount(String accountId) throws CleanupModuleException {
        try {
            this.executeUpdate(ACCOUNT_SQL, Map.of(1, accountId));
        }
        catch (IOException e) {
            throw CleanupModuleException.builder().devMsg(String.format(DELETE_ACCOUNT_ERROR_MSG, accountId, e.getMessage())).build();
        }
    }

    @Override
    public void deletePostings(String id) throws CleanupModuleException {
        try {
            this.executeUpdate(POSTING_SQL, Map.of(1, id));
        }
        catch (IOException e) {
            throw CleanupModuleException.builder().devMsg(String.format(DELETE_POSTINGS_ERROR_MSG, id, e.getMessage())).build();
        }
    }

    @Override
    public void rollBackBranch(String branch, LocalDateTime revertTimestamp) throws CleanupModuleException {
        try {
            this.executeUpdate(ROLL_BACK_BRANCH_SQL, Map.of(1, branch, 2, revertTimestamp));
        }
        catch (IOException e) {
            throw CleanupModuleException.builder().devMsg(String.format(ROLL_BACK_BRANCH_ERROR_MSG, branch, e.getMessage())).build();
        }
    }
}

