/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.app.server.auth;

import de.adorsys.ledgers.app.server.auth.DisableEndpointFilter;
import de.adorsys.ledgers.app.server.auth.PermittedResources;
import de.adorsys.ledgers.keycloak.client.mapper.KeycloakAuthMapper;
import de.adorsys.ledgers.middleware.api.domain.um.AccessTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import java.security.Principal;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.springboot.KeycloakSpringBootConfigResolver;
import org.keycloak.adapters.springsecurity.KeycloakConfiguration;
import org.keycloak.adapters.springsecurity.authentication.KeycloakAuthenticationProvider;
import org.keycloak.adapters.springsecurity.config.KeycloakWebSecurityConfigurerAdapter;
import org.keycloak.adapters.springsecurity.token.KeycloakAuthenticationToken;
import org.keycloak.representations.AccessToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.SimpleAuthorityMapper;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.session.SessionRegistryImpl;
import org.springframework.security.web.authentication.session.RegisterSessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.web.context.annotation.RequestScope;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
@KeycloakConfiguration
public class WebSecurityConfigKeycloak
extends KeycloakWebSecurityConfigurerAdapter {
    private final KeycloakAuthMapper authMapper;
    private final Environment environment;

    @Bean
    public KeycloakSpringBootConfigResolver getResolver() {
        return new KeycloakSpringBootConfigResolver();
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) {
        KeycloakAuthenticationProvider keycloakAuthenticationProvider = this.keycloakAuthenticationProvider();
        keycloakAuthenticationProvider.setGrantedAuthoritiesMapper((GrantedAuthoritiesMapper)new SimpleAuthorityMapper());
        auth.authenticationProvider((AuthenticationProvider)keycloakAuthenticationProvider);
    }

    @Bean
    protected SessionAuthenticationStrategy sessionAuthenticationStrategy() {
        return new RegisterSessionAuthenticationStrategy((SessionRegistry)new SessionRegistryImpl());
    }

    protected void configure(HttpSecurity http) throws Exception {
        super.configure(http);
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.csrf().disable()).cors().disable()).authorizeRequests().antMatchers(PermittedResources.APP_WHITELIST)).permitAll().and()).authorizeRequests().antMatchers(PermittedResources.INDEX_WHITELIST)).permitAll().and()).authorizeRequests().antMatchers(PermittedResources.SWAGGER_WHITELIST)).permitAll().and()).authorizeRequests().antMatchers(PermittedResources.CONSOLE_WHITELIST)).permitAll().and()).authorizeRequests().antMatchers(PermittedResources.ACTUATOR_WHITELIST)).permitAll().anyRequest()).authenticated();
        http.addFilterBefore((Filter)new DisableEndpointFilter(this.environment), BasicAuthenticationFilter.class);
    }

    @Bean
    @RequestScope
    public AccessToken getAccessToken() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        KeycloakAuthenticationToken token = (KeycloakAuthenticationToken)request.getUserPrincipal();
        KeycloakPrincipal principal = (KeycloakPrincipal)token.getPrincipal();
        KeycloakSecurityContext session = principal.getKeycloakSecurityContext();
        return session.getToken();
    }

    @Bean
    @RequestScope
    public AccessTokenTO getAccessTokenTO() {
        return WebSecurityConfigKeycloak.auth().map(arg_0 -> this.extractAccessToken(arg_0)).orElse(null);
    }

    @Bean
    @RequestScope
    public BearerTokenTO getBearerTokenTO() {
        return WebSecurityConfigKeycloak.auth().map(arg_0 -> this.extractBearerToken(arg_0)).orElse(null);
    }

    @Bean
    @RequestScope
    public Principal getPrincipal() {
        return WebSecurityConfigKeycloak.auth().orElse(null);
    }

    private static Optional<Authentication> auth() {
        return SecurityContextHolder.getContext() == null ? Optional.empty() : Optional.ofNullable(SecurityContextHolder.getContext().getAuthentication());
    }

    private AccessTokenTO extractAccessToken(Authentication authentication) {
        RefreshableKeycloakSecurityContext credentials = (RefreshableKeycloakSecurityContext)authentication.getCredentials();
        return this.authMapper.toAccessToken(credentials);
    }

    private BearerTokenTO extractBearerToken(Authentication authentication) {
        RefreshableKeycloakSecurityContext credentials = (RefreshableKeycloakSecurityContext)authentication.getCredentials();
        return this.authMapper.toBearer(credentials.getToken(), credentials.getTokenString());
    }

    public WebSecurityConfigKeycloak(KeycloakAuthMapper authMapper, Environment environment) {
        this.authMapper = authMapper;
        this.environment = environment;
    }
}

