/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.app.server.auth;

import de.adorsys.ledgers.keycloak.client.mapper.KeycloakAuthMapper;
import de.adorsys.ledgers.middleware.api.service.MiddlewareAccountManagementService;
import de.adorsys.ledgers.middleware.api.service.MiddlewarePaymentService;
import de.adorsys.ledgers.middleware.api.service.MiddlewareRedirectScaService;
import de.adorsys.ledgers.middleware.api.service.MiddlewareUserManagementService;
import de.adorsys.ledgers.middleware.rest.security.AccountAccessMethodSecurityExpressionHandler;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.method.configuration.GlobalMethodSecurityConfiguration;

@Configuration
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class MethodSecurityConfig
extends GlobalMethodSecurityConfiguration {
    private final MiddlewareAccountManagementService middlewareAccountService;
    private final MiddlewarePaymentService middlewareService;
    private final KeycloakAuthMapper authMapper;
    private final MiddlewareUserManagementService userManagementService;
    private final MiddlewareRedirectScaService scaService;

    protected MethodSecurityExpressionHandler createExpressionHandler() {
        return new AccountAccessMethodSecurityExpressionHandler(this.middlewareAccountService, this.middlewareService, this.userManagementService, this.authMapper, this.scaService);
    }

    public MethodSecurityConfig(MiddlewareAccountManagementService middlewareAccountService, MiddlewarePaymentService middlewareService, KeycloakAuthMapper authMapper, MiddlewareUserManagementService userManagementService, MiddlewareRedirectScaService scaService) {
        this.middlewareAccountService = middlewareAccountService;
        this.middlewareService = middlewareService;
        this.authMapper = authMapper;
        this.userManagementService = userManagementService;
        this.scaService = scaService;
    }
}

