/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.app.server.auth;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class DisableEndpointFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(DisableEndpointFilter.class);
    private static final List<String> EXCLUDED_URLS;
    private static final List<String> DEVELOP_PROFILES;
    private static final AntPathMatcher matcher;
    private final Environment environment;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.isAccessibleEndpoint(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            log.info("This endpoint is not accessible");
            response.setStatus(HttpStatus.NOT_FOUND.value());
        }
    }

    private boolean isAccessibleEndpoint(HttpServletRequest request) {
        List<String> activeProfiles = Arrays.asList(this.environment.getActiveProfiles());
        boolean isDevelopProfile = DEVELOP_PROFILES.stream().anyMatch(activeProfiles::contains);
        return isDevelopProfile || this.isExcludedEndpoint(request);
    }

    private boolean isExcludedEndpoint(HttpServletRequest request) {
        return !matcher.matchStart(request.getServletPath(), "/staff-access/data") || EXCLUDED_URLS.stream().anyMatch(p -> matcher.match(request.getServletPath(), p));
    }

    public DisableEndpointFilter(Environment environment) {
        this.environment = environment;
    }

    static {
        DEVELOP_PROFILES = Arrays.asList("develop", "sandbox");
        matcher = new AntPathMatcher();
        EXCLUDED_URLS = Arrays.asList("/staff-access/data/currencies", "/staff-access/data/branch");
    }
}

