/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.app.initiation;

import de.adorsys.ledgers.keycloak.client.api.KeycloakTokenService;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.StartScaOprTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.client.rest.AuthRequestInterceptor;
import de.adorsys.ledgers.middleware.client.rest.PaymentRestClient;
import de.adorsys.ledgers.middleware.client.rest.RedirectScaRestClient;
import de.adorsys.ledgers.util.Ids;
import feign.FeignException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PaymentRestInitiationService {
    private static final Logger log = LoggerFactory.getLogger(PaymentRestInitiationService.class);
    private final PaymentRestClient paymentRestClient;
    private final RedirectScaRestClient scaRestClient;
    private final AuthRequestInterceptor authRequestInterceptor;
    private final KeycloakTokenService tokenService;

    public PaymentRestInitiationService(PaymentRestClient paymentRestClient, RedirectScaRestClient scaRestClient, AuthRequestInterceptor authRequestInterceptor, KeycloakTokenService tokenService) {
        this.paymentRestClient = paymentRestClient;
        this.scaRestClient = scaRestClient;
        this.authRequestInterceptor = authRequestInterceptor;
        this.tokenService = tokenService;
    }

    public void executePayment(UserTO user, PaymentTO payment) {
        try {
            this.loginUser(user);
            SCAPaymentResponseTO initiationResponse = this.initiatePayment(payment);
            this.performScaIfRequired(initiationResponse);
            this.confirmPayment(initiationResponse.getPaymentId());
            this.authRequestInterceptor.setAccessToken(null);
        }
        catch (FeignException e) {
            log.error("Payment from: {}, failed due to: {},{}", new Object[]{user.getLogin(), e.contentUTF8(), e.getMessage()});
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    private void loginUser(UserTO user) {
        BearerTokenTO login = this.tokenService.login(user.getLogin(), user.getPin());
        log.info("Logged in user: {}", (Object)user.getLogin());
        this.authRequestInterceptor.setAccessToken(login.getAccess_token());
    }

    private SCAPaymentResponseTO initiatePayment(PaymentTO payment) {
        SCAPaymentResponseTO response = Optional.ofNullable((SCAPaymentResponseTO)this.paymentRestClient.initiatePayment(payment).getBody()).orElse(new SCAPaymentResponseTO());
        log.info("Payment for {} successfully initiated, ScaStatus: {}, transaction status: {}", new Object[]{payment.getDebtorAccount().getIban(), response.getScaStatus(), response.getTransactionStatus()});
        this.authRequestInterceptor.setAccessToken(response.getBearerToken().getAccess_token());
        return response;
    }

    private void performScaIfRequired(SCAPaymentResponseTO response) {
        if (response.getScaStatus() != ScaStatusTO.EXEMPTED) {
            GlobalScaResponseTO startSca = Optional.ofNullable(this.startSca(response)).orElse(new GlobalScaResponseTO());
            GlobalScaResponseTO selectMethod = Optional.ofNullable((GlobalScaResponseTO)this.scaRestClient.selectMethod(startSca.getAuthorisationId(), ((ScaUserDataTO)startSca.getScaMethods().iterator().next()).getId()).getBody()).orElse(new GlobalScaResponseTO());
            GlobalScaResponseTO scaFinalized = Optional.ofNullable((GlobalScaResponseTO)this.scaRestClient.validateScaCode(selectMethod.getAuthorisationId(), selectMethod.getTan()).getBody()).orElse(new GlobalScaResponseTO());
            this.authRequestInterceptor.setAccessToken(scaFinalized.getBearerToken().getAccess_token());
        }
    }

    private GlobalScaResponseTO startSca(SCAPaymentResponseTO response) {
        StartScaOprTO opr = new StartScaOprTO(response.getPaymentId(), null, Ids.id(), OpTypeTO.PAYMENT);
        this.authRequestInterceptor.setAccessToken(response.getBearerToken().getAccess_token());
        return (GlobalScaResponseTO)this.scaRestClient.startSca(opr).getBody();
    }

    private void confirmPayment(String paymentId) {
        SCAPaymentResponseTO response = Optional.ofNullable((SCAPaymentResponseTO)this.paymentRestClient.executePayment(paymentId).getBody()).orElse(new SCAPaymentResponseTO());
        log.info("Payment successfully executed! Transaction status: {}", (Object)response.getTransactionStatus());
    }
}

