/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.app.initiation;

import de.adorsys.ledgers.app.initiation.PaymentRestInitiationService;
import de.adorsys.ledgers.app.mock.AccountBalance;
import de.adorsys.ledgers.app.mock.BulkPaymentsData;
import de.adorsys.ledgers.app.mock.MockbankInitData;
import de.adorsys.ledgers.app.mock.SinglePaymentsData;
import de.adorsys.ledgers.deposit.api.domain.AmountBO;
import de.adorsys.ledgers.deposit.api.domain.BalanceBO;
import de.adorsys.ledgers.deposit.api.domain.DepositAccountBO;
import de.adorsys.ledgers.deposit.api.domain.DepositAccountDetailsBO;
import de.adorsys.ledgers.deposit.api.service.CurrencyExchangeRatesService;
import de.adorsys.ledgers.deposit.api.service.DepositAccountInitService;
import de.adorsys.ledgers.deposit.api.service.DepositAccountService;
import de.adorsys.ledgers.deposit.api.service.DepositAccountTransactionService;
import de.adorsys.ledgers.keycloak.client.api.KeycloakDataService;
import de.adorsys.ledgers.keycloak.client.config.KeycloakClientConfig;
import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTargetTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccountAccessTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.api.service.CurrencyService;
import de.adorsys.ledgers.middleware.api.service.MiddlewareUserManagementService;
import de.adorsys.ledgers.middleware.impl.converter.AccountDetailsMapper;
import de.adorsys.ledgers.middleware.impl.converter.KeycloakUserMapper;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.um.api.service.UserService;
import de.adorsys.ledgers.util.exception.DepositModuleException;
import de.adorsys.ledgers.util.exception.UserManagementModuleException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.ws.rs.ProcessingException;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class BankInitService {
    private static final Logger log = LoggerFactory.getLogger(BankInitService.class);
    private final MockbankInitData mockbankInitData;
    private final UserService userService;
    private final MiddlewareUserManagementService middlewareUserService;
    private final DepositAccountInitService depositAccountInitService;
    private final DepositAccountService depositAccountService;
    private final DepositAccountTransactionService transactionService;
    private final AccountDetailsMapper accountDetailsMapper;
    private final PaymentRestInitiationService restInitiationService;
    private final CurrencyService currencyService;
    private final CurrencyExchangeRatesService exchangeRatesService;
    private final KeycloakDataService dataService;
    private final ApplicationContext context;
    private final KeycloakClientConfig keycloakConfig;
    private final KeycloakUserMapper keycloakUserMapper;
    private static final String ADMIN = "admin";
    private static final String ADMIN_P = "admin123";
    private static final String ACCOUNT_NOT_FOUND_MSG = "Account {} not Found! Should never happen while initiating mock data!";
    private static final String NO_USER_BY_IBAN = "Could not get User By Iban {}! Should never happen while initiating mock data!";
    private static final LocalDateTime START_DATE = LocalDateTime.of(2018, 1, 1, 1, 1);

    public void init() {
        this.depositAccountInitService.initConfigData();
        this.configureIDP();
        this.createAdmin();
        try {
            this.exchangeRatesService.updateRates();
        }
        catch (IOException e) {
            log.error("ExchangeRate update failed for external service and default values on: {}, service is discontinued until Rate Service is fixed!", (Object)LocalDateTime.now());
            SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0});
        }
    }

    private void configureIDP() {
        boolean clientExists;
        try {
            clientExists = this.dataService.clientExists();
        }
        catch (ProcessingException e) {
            log.error("Cannot connect to Keycloak IDP on host: {}. Ledgers is shutting down.", (Object)this.keycloakConfig.getAuthServerUrl());
            throw e;
        }
        if (!clientExists) {
            this.dataService.createDefaultSchema();
            this.copyUsers();
        }
    }

    private void copyUsers() {
        List users = this.userService.listUsers(0, Integer.MAX_VALUE);
        users.stream().map(u -> {
            String pin = "12345";
            if (u.getLogin().equals(ADMIN)) {
                pin = ADMIN_P;
            }
            u.setPin(pin);
            return u;
        }).map(arg_0 -> ((KeycloakUserMapper)this.keycloakUserMapper).toKeycloakUser(arg_0)).forEach(arg_0 -> ((KeycloakDataService)this.dataService).createUser(arg_0));
        log.info("All users passwords are RESET to 12345 due to migration to new IDP");
    }

    public void uploadTestData() {
        this.createAccounts();
        this.createUsers();
        this.performTransactions();
    }

    private void createAdmin() {
        try {
            this.userService.findByLogin(ADMIN);
            log.info("Admin user is already present. Skipping creation");
        }
        catch (UserManagementModuleException e) {
            UserTO admin = new UserTO(ADMIN, "admin@example.com", ADMIN_P);
            admin.setUserRoles(Collections.singleton(UserRoleTO.SYSTEM));
            this.createUser(admin);
        }
    }

    private void performTransactions() {
        List users = this.mockbankInitData.getUsers();
        this.performSinglePayments(users);
        this.performBulkPayments(users);
    }

    private void performSinglePayments(List<UserTO> users) {
        for (SinglePaymentsData paymentsData : this.mockbankInitData.getSinglePayments()) {
            PaymentTO payment = paymentsData.getSinglePayment();
            try {
                if (!this.isAbsentTransactionRegular(payment.getDebtorAccount().getIban(), payment.getDebtorAccount().getCurrency(), ((PaymentTargetTO)payment.getTargets().get(0)).getEndToEndIdentification())) continue;
                UserTO user = this.getUserByIban(users, payment.getDebtorAccount().getIban());
                this.restInitiationService.executePayment(user, payment);
            }
            catch (DepositModuleException e) {
                log.error(ACCOUNT_NOT_FOUND_MSG, (Object)payment.getDebtorAccount().getIban());
            }
            catch (UserManagementModuleException e) {
                log.error(NO_USER_BY_IBAN, (Object)payment.getDebtorAccount().getIban());
            }
        }
    }

    private void performBulkPayments(List<UserTO> users) {
        for (BulkPaymentsData paymentsData : this.mockbankInitData.getBulkPayments()) {
            PaymentTO payment = paymentsData.getBulkPayment();
            AccountReferenceTO debtorAccount = payment.getDebtorAccount();
            try {
                boolean isAbsentTransaction = Optional.ofNullable(payment.getBatchBookingPreferred()).orElse(false) != false ? this.isAbsentTransactionBatch(payment) : this.isAbsentTransactionRegular(debtorAccount.getIban(), debtorAccount.getCurrency(), ((PaymentTargetTO)payment.getTargets().iterator().next()).getEndToEndIdentification());
                if (!isAbsentTransaction) continue;
                UserTO user = this.getUserByIban(users, debtorAccount.getIban());
                this.restInitiationService.executePayment(user, payment);
            }
            catch (DepositModuleException e) {
                log.error(ACCOUNT_NOT_FOUND_MSG, (Object)debtorAccount.getIban());
            }
            catch (UserManagementModuleException e) {
                log.error(NO_USER_BY_IBAN, (Object)debtorAccount.getIban());
            }
        }
    }

    private boolean isAbsentTransactionBatch(PaymentTO payment) {
        DepositAccountBO account = this.depositAccountService.getAccountByIbanAndCurrency(payment.getDebtorAccount().getIban(), payment.getDebtorAccount().getCurrency());
        List transactions = this.depositAccountService.getTransactionsByDates(account.getId(), START_DATE, LocalDateTime.now());
        BigDecimal total = BigDecimal.ZERO.subtract(payment.getTargets().stream().map(PaymentTargetTO::getInstructedAmount).map(AmountTO::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP));
        return transactions.stream().noneMatch(t -> t.getTransactionAmount().getAmount().equals(total));
    }

    private boolean isAbsentTransactionRegular(String iban, Currency currency, String entToEndId) {
        DepositAccountBO account = this.depositAccountService.getAccountByIbanAndCurrency(iban, currency);
        List transactions = this.depositAccountService.getTransactionsByDates(account.getId(), START_DATE, LocalDateTime.now());
        return transactions.stream().noneMatch(t -> entToEndId.equals(t.getEndToEndId()));
    }

    private UserTO getUserByIban(List<UserTO> users, String iban) {
        return users.stream().filter(user -> this.isAccountContainedInAccess(user.getAccountAccesses(), iban)).findFirst().orElseThrow(() -> UserManagementModuleException.builder().build());
    }

    private void createAccounts() {
        for (AccountDetailsTO details : this.mockbankInitData.getAccounts()) {
            DepositAccountDetailsBO account;
            if (!this.currencyService.isCurrencyValid(details.getCurrency())) {
                throw new IllegalArgumentException("Currency is not supported: " + details.getCurrency());
            }
            try {
                account = this.depositAccountService.getAccountDetailsByIbanAndCurrency(details.getIban(), details.getCurrency(), LocalDateTime.now(), true);
            }
            catch (DepositModuleException e) {
                details.setCreditLimit(BigDecimal.ZERO);
                account = this.createAccount(details);
            }
            this.updateBalanceIfRequired(details, account);
        }
    }

    private void updateBalanceIfRequired(AccountDetailsTO details, DepositAccountDetailsBO account) {
        this.getBalanceFromInitData(details).ifPresent(b -> this.checkAndUpdateBalance(details, account, b));
    }

    private void checkAndUpdateBalance(AccountDetailsTO details, DepositAccountDetailsBO account, BigDecimal balanceValue) {
        AmountBO amount = new AmountBO(details.getCurrency(), balanceValue);
        try {
            if (((BalanceBO)account.getBalances().iterator().next()).getAmount().getAmount().compareTo(amount.getAmount()) < 0) {
                this.transactionService.depositCash(account.getAccount().getId(), amount, "SYSTEM");
            }
        }
        catch (DepositModuleException e) {
            log.error("Unable to deposit cash to account: {} {}", (Object)details.getIban(), (Object)details.getCurrency());
        }
    }

    private Optional<BigDecimal> getBalanceFromInitData(AccountDetailsTO details) {
        return this.mockbankInitData.getBalances().stream().filter(this.getAccountBalancePredicate(details)).findFirst().map(AccountBalance::getBalance);
    }

    @NotNull
    private Predicate<AccountBalance> getAccountBalancePredicate(AccountDetailsTO details) {
        return b -> StringUtils.equals((CharSequence)b.getAccNbr(), (CharSequence)details.getIban()) && b.getCurrency().equals(details.getCurrency());
    }

    private DepositAccountDetailsBO createAccount(AccountDetailsTO details) {
        String userName = this.getUserNameByIban(details.getIban());
        DepositAccountBO accountBO = this.accountDetailsMapper.toDepositAccountBO(details);
        DepositAccountBO account = this.depositAccountService.createNewAccount(accountBO, userName, "");
        this.userService.findUsersByIban(details.getIban()).forEach(u -> this.updateAccess(u, account.getIban(), account.getId()));
        return this.depositAccountService.getAccountDetailsById(account.getId(), LocalDateTime.now(), true);
    }

    private void updateAccess(UserBO user, String iban, String accountId) {
        List accesses = user.getAccountAccesses();
        accesses.stream().filter(a -> a.getIban().equals(iban)).findAny().ifPresent(a -> a.setAccountId(accountId));
        this.userService.updateAccountAccess(user.getLogin(), accesses);
    }

    private String getUserNameByIban(String iban) {
        return this.mockbankInitData.getUsers().stream().filter(u -> this.isAccountContainedInAccess(u.getAccountAccesses(), iban)).findFirst().map(UserTO::getLogin).orElseThrow(() -> UserManagementModuleException.builder().build());
    }

    private boolean isAccountContainedInAccess(List<AccountAccessTO> access, String iban) {
        return access.stream().anyMatch(a -> a.getIban().equals(iban));
    }

    private void createUsers() {
        for (UserTO user : this.mockbankInitData.getUsers()) {
            try {
                this.userService.findByLogin(user.getLogin());
            }
            catch (UserManagementModuleException e) {
                user.getUserRoles().add(UserRoleTO.CUSTOMER);
                this.createUser(user);
            }
        }
    }

    private void createUser(UserTO user) {
        try {
            user.getAccountAccesses().stream().filter(a -> a.getAccountId() == null).forEach(a -> {
                DepositAccountBO depositAccountBO = this.depositAccountService.getAccountByIbanAndCurrency(a.getIban(), a.getCurrency());
                if (depositAccountBO != null) {
                    a.setAccountId(depositAccountBO.getId());
                }
            });
            this.middlewareUserService.create(user);
        }
        catch (UserManagementModuleException e1) {
            log.error("User already exists! Should never happen while initiating mock data!");
        }
    }

    public BankInitService(MockbankInitData mockbankInitData, UserService userService, MiddlewareUserManagementService middlewareUserService, DepositAccountInitService depositAccountInitService, DepositAccountService depositAccountService, DepositAccountTransactionService transactionService, AccountDetailsMapper accountDetailsMapper, PaymentRestInitiationService restInitiationService, CurrencyService currencyService, CurrencyExchangeRatesService exchangeRatesService, KeycloakDataService dataService, ApplicationContext context, KeycloakClientConfig keycloakConfig, KeycloakUserMapper keycloakUserMapper) {
        this.mockbankInitData = mockbankInitData;
        this.userService = userService;
        this.middlewareUserService = middlewareUserService;
        this.depositAccountInitService = depositAccountInitService;
        this.depositAccountService = depositAccountService;
        this.transactionService = transactionService;
        this.accountDetailsMapper = accountDetailsMapper;
        this.restInitiationService = restInitiationService;
        this.currencyService = currencyService;
        this.exchangeRatesService = exchangeRatesService;
        this.dataService = dataService;
        this.context = context;
        this.keycloakConfig = keycloakConfig;
        this.keycloakUserMapper = keycloakUserMapper;
    }
}

