/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.app.server.auth;

import de.adorsys.ledgers.app.server.auth.DisableEndpointFilter;
import de.adorsys.ledgers.app.server.auth.PermittedResources;
import de.adorsys.ledgers.middleware.api.domain.um.AccessTokenTO;
import de.adorsys.ledgers.middleware.rest.security.JWTAuthenticationFilter;
import de.adorsys.ledgers.middleware.rest.security.MiddlewareAuthentication;
import de.adorsys.ledgers.middleware.rest.security.TokenAuthenticationService;
import de.adorsys.ledgers.um.api.service.UserService;
import java.security.Principal;
import java.util.Optional;
import javax.servlet.Filter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.web.context.annotation.RequestScope;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@EnableWebSecurity
public class WebSecurityConfig
extends WebSecurityConfigurerAdapter {
    private final Environment environment;
    private final TokenAuthenticationService tokenAuthenticationService;
    private final UserService userService;

    protected void configure(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(PermittedResources.APP_WHITELIST)).permitAll().and()).authorizeRequests().antMatchers(PermittedResources.INDEX_WHITELIST)).permitAll().and()).authorizeRequests().antMatchers(PermittedResources.SWAGGER_WHITELIST)).permitAll().and()).authorizeRequests().antMatchers(PermittedResources.CONSOLE_WHITELIST)).permitAll().and()).authorizeRequests().antMatchers(PermittedResources.ACTUATOR_WHITELIST)).permitAll().and()).cors().and()).authorizeRequests().anyRequest()).authenticated();
        ((HttpSecurity)http.csrf().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        http.headers().frameOptions().disable();
        http.addFilterBefore((Filter)new DisableEndpointFilter(this.environment), BasicAuthenticationFilter.class);
        http.addFilterBefore((Filter)new JWTAuthenticationFilter(this.tokenAuthenticationService), BasicAuthenticationFilter.class);
    }

    @Bean
    @RequestScope
    public Principal getPrincipal() {
        return WebSecurityConfig.auth().orElse(null);
    }

    @Bean
    @RequestScope
    public AccessTokenTO getAccessTokenTO() {
        return WebSecurityConfig.auth().map(arg_0 -> this.extractToken(arg_0)).orElse(null);
    }

    private static Optional<MiddlewareAuthentication> auth() {
        return SecurityContextHolder.getContext() == null ? Optional.empty() : Optional.ofNullable((MiddlewareAuthentication)SecurityContextHolder.getContext().getAuthentication());
    }

    private AccessTokenTO extractToken(MiddlewareAuthentication authentication) {
        return authentication.getBearerToken().getAccessTokenObject();
    }

    public WebSecurityConfig(Environment environment, TokenAuthenticationService tokenAuthenticationService, UserService userService) {
        this.environment = environment;
        this.tokenAuthenticationService = tokenAuthenticationService;
        this.userService = userService;
    }
}

