/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.app.server;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import de.adorsys.ledgers.app.server.FileReader;
import de.adorsys.ledgers.middleware.rest.annotation.MiddlewareResetResource;
import de.adorsys.ledgers.middleware.rest.annotation.MiddlewareUserResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.info.BuildProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import springfox.bean.validators.configuration.BeanValidatorPluginsConfiguration;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
@Import(value={BeanValidatorPluginsConfiguration.class})
public class SwaggerConfig {
    private static final String API_KEY = "apiKey";
    private static final String API_INFO = "api_info.txt";
    private final FileReader fileReader;
    private final BuildProperties buildProperties;
    private final Environment env;

    @Bean
    public Docket productApi() {
        return new Docket(DocumentationType.SWAGGER_2).groupName("001 - LEDGERS API").select().apis(this.resolvePredicates()).paths(PathSelectors.any()).build().pathMapping("/").apiInfo(this.metaData()).securitySchemes(Collections.singletonList(this.apiKey())).securityContexts(Collections.singletonList(this.securityContext()));
    }

    private Predicate<RequestHandler> resolvePredicates() {
        List<String> profiles = Arrays.asList(this.env.getActiveProfiles());
        return profiles.contains("develop") || profiles.contains("sandbox") ? Predicates.or((Predicate)RequestHandlerSelectors.withClassAnnotation(MiddlewareUserResource.class), (Predicate)RequestHandlerSelectors.withClassAnnotation(MiddlewareResetResource.class)) : RequestHandlerSelectors.withClassAnnotation(MiddlewareUserResource.class);
    }

    private ApiKey apiKey() {
        return new ApiKey(API_KEY, "Authorization", "header");
    }

    private SecurityContext securityContext() {
        return SecurityContext.builder().securityReferences(this.defaultAuth()).forPaths(PathSelectors.regex((String)"/*")).build();
    }

    private List<SecurityReference> defaultAuth() {
        AuthorizationScope authorizationScope = new AuthorizationScope("global", "accessEverything");
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{authorizationScope};
        return Collections.singletonList(new SecurityReference(API_KEY, authorizationScopes));
    }

    private ApiInfo metaData() {
        Contact contact = new Contact("Adorsys GmbH", "https://www.adorsys.de", "fpo@adorsys.de");
        return new ApiInfo("Ledgers", this.fileReader.getStringFromFile(API_INFO), this.buildProperties.getVersion() + " " + this.buildProperties.get("build.number"), "Terms of Service: to be edited...", contact, "Apache License Version 2.0", "https://www.apache.org/licenses/LICENSE-2.0", new ArrayList());
    }

    public SwaggerConfig(FileReader fileReader, BuildProperties buildProperties, Environment env) {
        this.fileReader = fileReader;
        this.buildProperties = buildProperties;
        this.env = env;
    }
}

