/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.app.server.auth;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class DisableEndpointFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(DisableEndpointFilter.class);
    private static final String SUFFIX = "/**";
    private static final List<String> EXCLUDED_URLS = Collections.singletonList("/staff-access/data/**");
    private static final List<String> PROFILES = Arrays.asList("develop", "sandbox");
    private static final AntPathMatcher matcher = new AntPathMatcher();
    private final Environment environment;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.isNotAccessibleEndpoint(request)) {
            log.info("This endpoint is not accessible");
            response.setStatus(HttpStatus.NOT_FOUND.value());
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private boolean isNotAccessibleEndpoint(HttpServletRequest request) {
        List<String> activeProfiles = Arrays.asList(this.environment.getActiveProfiles());
        boolean isNoneMatchedProfile = PROFILES.stream().noneMatch(activeProfiles::contains);
        return isNoneMatchedProfile && this.isExcludedEndpoint(request);
    }

    private boolean isExcludedEndpoint(HttpServletRequest request) {
        return EXCLUDED_URLS.stream().anyMatch(p -> matcher.match(p, request.getServletPath()));
    }

    public DisableEndpointFilter(Environment environment) {
        this.environment = environment;
    }
}

