/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.app.initiation;

import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCALoginResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.client.rest.AuthRequestInterceptor;
import de.adorsys.ledgers.middleware.client.rest.PaymentRestClient;
import de.adorsys.ledgers.middleware.client.rest.UserMgmtRestClient;
import de.adorsys.ledgers.util.Ids;
import feign.FeignException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PaymentRestInitiationService {
    private final UserMgmtRestClient userMgmtRestClient;
    private final PaymentRestClient paymentRestClient;
    private final AuthRequestInterceptor authRequestInterceptor;
    private final Logger logger = LoggerFactory.getLogger(PaymentRestInitiationService.class);

    public PaymentRestInitiationService(UserMgmtRestClient userMgmtRestClient, PaymentRestClient paymentRestClient, AuthRequestInterceptor authRequestInterceptor) {
        this.userMgmtRestClient = userMgmtRestClient;
        this.paymentRestClient = paymentRestClient;
        this.authRequestInterceptor = authRequestInterceptor;
    }

    public void executePayment(UserTO user, PaymentTypeTO paymentType, PaymentTO payment) {
        try {
            this.loginUser(user);
            SCAPaymentResponseTO response = (SCAPaymentResponseTO)this.paymentRestClient.initiatePayment(paymentType, payment).getBody();
            this.logger.info("Payment from: {}, successfully committed, payment ID: {}, transaction status: {}", new Object[]{user.getLogin(), response.getPaymentId(), response.getTransactionStatus()});
            this.performScaIfRequired(response);
        }
        catch (FeignException e) {
            this.logger.error("Payment from: {}, failed due to: {}", (Object)user.getLogin(), (Object)e.getMessage());
        }
    }

    private void performScaIfRequired(SCAPaymentResponseTO response) {
        try {
            if (response.getScaStatus() == ScaStatusTO.PSUAUTHENTICATED) {
                response = (SCAPaymentResponseTO)this.paymentRestClient.selectMethod(response.getPaymentId(), response.getAuthorisationId(), ((ScaUserDataTO)response.getScaMethods().iterator().next()).getId()).getBody();
                this.authRequestInterceptor.setAccessToken(response.getBearerToken().getAccess_token());
            }
            if (response.getScaStatus() == ScaStatusTO.SCAMETHODSELECTED) {
                this.paymentRestClient.authorizePayment(response.getPaymentId(), response.getAuthorisationId(), "123456").getBody();
                this.authRequestInterceptor.setAccessToken(null);
                this.logger.info("Payment finalized!");
            }
        }
        catch (FeignException e) {
            this.logger.error("Failed authorising payment: {}, authId: {}", (Object)response.getPaymentId(), (Object)response.getAuthorisationId());
        }
    }

    private void loginUser(UserTO user) {
        try {
            String id = Ids.id();
            SCALoginResponseTO response = (SCALoginResponseTO)this.userMgmtRestClient.authoriseForConsent(user.getLogin(), user.getPin(), id, id, OpTypeTO.PAYMENT).getBody();
            this.authRequestInterceptor.setAccessToken(response.getBearerToken().getAccess_token());
        }
        catch (FeignException e) {
            this.logger.error("Could not Login user: {}, error: {}", (Object)user.getLogin(), (Object)e.getMessage());
        }
    }
}

