/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.app.initiation;

import de.adorsys.ledgers.app.initiation.PaymentRestInitiationService;
import de.adorsys.ledgers.app.mock.AccountBalance;
import de.adorsys.ledgers.app.mock.BulkPaymentsData;
import de.adorsys.ledgers.app.mock.MockbankInitData;
import de.adorsys.ledgers.app.mock.SinglePaymentsData;
import de.adorsys.ledgers.deposit.api.domain.AmountBO;
import de.adorsys.ledgers.deposit.api.domain.DepositAccountBO;
import de.adorsys.ledgers.deposit.api.domain.DepositAccountDetailsBO;
import de.adorsys.ledgers.deposit.api.exception.DepositModuleException;
import de.adorsys.ledgers.deposit.api.service.DepositAccountInitService;
import de.adorsys.ledgers.deposit.api.service.DepositAccountService;
import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.domain.payment.BulkPaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.SinglePaymentTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccountAccessTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.impl.converter.AccountDetailsMapper;
import de.adorsys.ledgers.middleware.impl.converter.UserMapper;
import de.adorsys.ledgers.um.api.exception.UserManagementModuleException;
import de.adorsys.ledgers.um.api.service.UserService;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BankInitService {
    private final Logger logger = LoggerFactory.getLogger(BankInitService.class);
    private final MockbankInitData mockbankInitData;
    private final UserService userService;
    private final UserMapper userMapper;
    private final DepositAccountInitService depositAccountInitService;
    private final DepositAccountService depositAccountService;
    private final AccountDetailsMapper accountDetailsMapper;
    private final PaymentRestInitiationService restInitiationService;
    private static final String ACCOUNT_NOT_FOUND_MSG = "Account not Found! Should never happen while initiating mock data!";
    private static final String NO_USER_BY_IBAN = "Could not get User By Iban {}";
    private static final LocalDateTime START_DATE = LocalDateTime.of(2018, 1, 1, 1, 1);

    @Autowired
    public BankInitService(MockbankInitData mockbankInitData, UserService userService, UserMapper userMapper, DepositAccountInitService depositAccountInitService, DepositAccountService depositAccountService, AccountDetailsMapper accountDetailsMapper, PaymentRestInitiationService restInitiationService) {
        this.mockbankInitData = mockbankInitData;
        this.userService = userService;
        this.userMapper = userMapper;
        this.depositAccountInitService = depositAccountInitService;
        this.depositAccountService = depositAccountService;
        this.accountDetailsMapper = accountDetailsMapper;
        this.restInitiationService = restInitiationService;
    }

    public void init() {
        this.depositAccountInitService.initConfigData();
        this.createAdmin();
    }

    public void uploadTestData() {
        this.createUsers();
        this.createAccounts();
        this.performTransactions();
    }

    private void createAdmin() {
        try {
            this.userService.findByLogin("admin");
            this.logger.error("Admin user is already present. Skipping creation");
        }
        catch (UserManagementModuleException e) {
            UserTO admin = new UserTO("admin", "admin@mail.de", "admin123");
            admin.setUserRoles(Collections.singleton(UserRoleTO.SYSTEM));
            this.createUser(admin);
        }
    }

    private void performTransactions() {
        List users = this.mockbankInitData.getUsers();
        this.performSinglePayments(users);
        this.performBulkPayments(users);
    }

    private void performSinglePayments(List<UserTO> users) {
        for (SinglePaymentsData paymentsData : this.mockbankInitData.getSinglePayments()) {
            SinglePaymentTO payment = paymentsData.getSinglePayment();
            try {
                if (!this.isAbsentTransactionRegular(payment.getDebtorAccount().getIban(), payment.getEndToEndIdentification())) continue;
                UserTO user = this.getUserByIban(users, payment.getDebtorAccount().getIban());
                this.restInitiationService.executePayment(user, PaymentTypeTO.SINGLE, (Object)payment);
            }
            catch (DepositModuleException e) {
                this.logger.error(ACCOUNT_NOT_FOUND_MSG);
            }
            catch (UserManagementModuleException e) {
                this.logger.error(NO_USER_BY_IBAN, (Object)payment.getDebtorAccount().getIban());
            }
        }
    }

    private void performBulkPayments(List<UserTO> users) {
        for (BulkPaymentsData paymentsData : this.mockbankInitData.getBulkPayments()) {
            BulkPaymentTO payment = paymentsData.getBulkPayment();
            try {
                boolean isAbsentTransaction = payment.getBatchBookingPreferred() != false ? this.isAbsentTransactionBatch(payment) : this.isAbsentTransactionRegular(payment.getDebtorAccount().getIban(), ((SinglePaymentTO)payment.getPayments().iterator().next()).getEndToEndIdentification());
                if (!isAbsentTransaction) continue;
                UserTO user = this.getUserByIban(users, payment.getDebtorAccount().getIban());
                this.restInitiationService.executePayment(user, PaymentTypeTO.BULK, (Object)payment);
            }
            catch (DepositModuleException e) {
                this.logger.error(ACCOUNT_NOT_FOUND_MSG);
            }
            catch (UserManagementModuleException e) {
                this.logger.error(NO_USER_BY_IBAN, (Object)payment.getDebtorAccount().getIban());
            }
        }
    }

    private boolean isAbsentTransactionBatch(BulkPaymentTO payment) {
        DepositAccountDetailsBO account = this.depositAccountService.getDepositAccountByIban(payment.getDebtorAccount().getIban(), LocalDateTime.now(), false);
        List transactions = this.depositAccountService.getTransactionsByDates(account.getAccount().getId(), START_DATE, LocalDateTime.now());
        BigDecimal total = BigDecimal.ZERO.subtract(payment.getPayments().stream().map(SinglePaymentTO::getInstructedAmount).map(AmountTO::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 5));
        boolean isAbsentTransaction = transactions.stream().noneMatch(t -> t.getTransactionAmount().getAmount().equals(total));
        return isAbsentTransaction;
    }

    private boolean isAbsentTransactionRegular(String iban, String entToEndId) {
        DepositAccountDetailsBO account = this.depositAccountService.getDepositAccountByIban(iban, LocalDateTime.now(), false);
        List transactions = this.depositAccountService.getTransactionsByDates(account.getAccount().getId(), START_DATE, LocalDateTime.now());
        return transactions.stream().noneMatch(t -> entToEndId.equals(t.getEndToEndId()));
    }

    private UserTO getUserByIban(List<UserTO> users, String iban) {
        return users.stream().filter(user -> this.isAccountContainedInAccess(user.getAccountAccesses(), iban)).findFirst().orElseThrow(() -> UserManagementModuleException.builder().build());
    }

    private void createAccounts() {
        for (AccountDetailsTO details : this.mockbankInitData.getAccounts()) {
            try {
                this.depositAccountService.getDepositAccountByIban(details.getIban(), LocalDateTime.now(), false);
            }
            catch (DepositModuleException e) {
                this.createAccount(details).ifPresent(a -> this.updateBalanceIfRequired(details, a));
            }
        }
    }

    private void updateBalanceIfRequired(AccountDetailsTO details, DepositAccountBO a) {
        this.getBalanceFromInitData(details).ifPresent(b -> this.updateBalance(details, a, b));
    }

    private void updateBalance(AccountDetailsTO details, DepositAccountBO a, BigDecimal b) {
        AmountBO amount = new AmountBO(Currency.getInstance("EUR"), b);
        try {
            this.depositAccountService.depositCash(a.getId(), amount, "SYSTEM");
        }
        catch (DepositModuleException e) {
            this.logger.error("Unable to deposit cash to account: {}", (Object)details.getIban());
        }
    }

    private Optional<BigDecimal> getBalanceFromInitData(AccountDetailsTO details) {
        return this.mockbankInitData.getBalances().stream().filter(b -> StringUtils.equals((CharSequence)b.getAccNbr(), (CharSequence)details.getIban())).findFirst().map(AccountBalance::getBalance);
    }

    private Optional<DepositAccountBO> createAccount(AccountDetailsTO details) {
        try {
            String userName = this.getUserNameByIban(details.getIban());
            DepositAccountBO accountBO = this.accountDetailsMapper.toDepositAccountBO(details);
            return Optional.of(this.depositAccountService.createDepositAccount(accountBO, userName));
        }
        catch (DepositModuleException e) {
            this.logger.error("Error creating Account For Mocked User");
            return Optional.empty();
        }
    }

    private String getUserNameByIban(String iban) {
        return this.mockbankInitData.getUsers().stream().filter(u -> this.isAccountContainedInAccess(u.getAccountAccesses(), iban)).findFirst().map(UserTO::getLogin).orElseThrow(() -> UserManagementModuleException.builder().build());
    }

    private boolean isAccountContainedInAccess(List<AccountAccessTO> access, String iban) {
        return access.stream().anyMatch(a -> a.getIban().equals(iban));
    }

    private void createUsers() {
        for (UserTO user : this.mockbankInitData.getUsers()) {
            try {
                this.userService.findByLogin(user.getLogin());
            }
            catch (UserManagementModuleException e) {
                user.getUserRoles().add(UserRoleTO.CUSTOMER);
                this.createUser(user);
            }
        }
    }

    private void createUser(UserTO user) {
        try {
            this.userService.create(this.userMapper.toUserBO(user));
        }
        catch (UserManagementModuleException e1) {
            this.logger.error("User already exists! Should never happen while initiating mock data!");
        }
    }
}

