/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.app.mock;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import de.adorsys.ledgers.deposit.api.service.domain.ASPSPConfigData;
import de.adorsys.ledgers.deposit.api.service.domain.ASPSPConfigSource;
import de.adorsys.ledgers.deposit.api.service.domain.LedgerAccountModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class MockBankConfigSource
implements ASPSPConfigSource {
    private ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public ASPSPConfigData aspspConfigData() {
        InputStream inputStream = MockBankConfigSource.class.getResourceAsStream("aspsps-config.yml");
        try {
            return (ASPSPConfigData)this.mapper.readValue(inputStream, ASPSPConfigData.class);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public List<LedgerAccountModel> chartOfAccount(String coaFile) {
        LedgerAccountModel[] ledgerAccounts;
        InputStream inputStream = MockBankConfigSource.class.getResourceAsStream(coaFile);
        try {
            ledgerAccounts = (LedgerAccountModel[])this.mapper.readValue(inputStream, LedgerAccountModel[].class);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return Arrays.asList(ledgerAccounts);
    }
}

