/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.app;

import de.adorsys.ledgers.deposit.api.service.EnableDepositAccountService;
import de.adorsys.ledgers.middleware.client.rest.AccountRestClient;
import de.adorsys.ledgers.middleware.impl.EnableLedgersMiddlewareService;
import de.adorsys.ledgers.middleware.rest.EnableLedgersMiddlewareRest;
import de.adorsys.ledgers.mockbank.simple.service.EnableMockBankSimple;
import de.adorsys.ledgers.mockbank.simple.service.MockBankSimpleInitService;
import de.adorsys.ledgers.postings.impl.EnablePostingService;
import de.adorsys.ledgers.sca.mock.MockSmtpServer;
import de.adorsys.ledgers.sca.service.EnableSCAService;
import de.adorsys.ledgers.um.impl.EnableUserManagementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;

@EnableScheduling
@SpringBootApplication
@EnableUserManagementService
@EnableSCAService
@EnablePostingService
@EnableDepositAccountService
@EnableLedgersMiddlewareService
@EnableLedgersMiddlewareRest
@EnableMockBankSimple
@EnableFeignClients(basePackageClasses={AccountRestClient.class})
public class LedgersApplication
implements ApplicationListener<ApplicationReadyEvent> {
    @Autowired
    private ApplicationContext context;
    @Value(value="${ledgers.mockbank.data.load:false}")
    private boolean loadMockData;

    public static void main(String[] args) {
        new SpringApplicationBuilder(new Class[]{LedgersApplication.class}).run(args);
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        if (this.loadMockData) {
            ((MockBankSimpleInitService)this.context.getBean(MockBankSimpleInitService.class)).runInit();
        }
    }

    @Bean
    @ConditionalOnClass(name={"org.subethamail.smtp.server.SMTPServer"})
    MockSmtpServer mockSmtpServer() {
        return new MockSmtpServer();
    }
}

