/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.app.server;

import de.adorsys.ledgers.app.server.CorsConfigProperties;
import de.adorsys.ledgers.middleware.api.domain.um.AccessTokenTO;
import de.adorsys.ledgers.middleware.rest.security.JWTAuthenticationFilter;
import de.adorsys.ledgers.middleware.rest.security.MiddlewareAuthentication;
import de.adorsys.ledgers.middleware.rest.security.TokenAuthenticationService;
import java.security.Principal;
import java.util.Optional;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@EnableWebSecurity
public class WebSecurityConfig
extends WebSecurityConfigurerAdapter {
    private final TokenAuthenticationService tokenAuthenticationService;
    private final CorsConfigProperties corsConfigProperties;

    @Autowired
    public WebSecurityConfig(TokenAuthenticationService tokenAuthenticationService, CorsConfigProperties corsConfigProperties) {
        this.tokenAuthenticationService = tokenAuthenticationService;
        this.corsConfigProperties = corsConfigProperties;
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/", "/management/app/admin", "/management/app/ping", "/users/login", "/users/register", "/users/loginForConsent", "/data-test/upload-mockbank-data", "/data-test/db-flush", "/staff-access/users/register", "/staff-access/users/login"})).permitAll().and()).authorizeRequests().antMatchers(new String[]{"/index.css", "/img/*", "/favicon.ico"})).permitAll().and()).authorizeRequests().antMatchers(new String[]{"/v2/api-docs", "/swagger-resources", "/swagger-ui.html", "/webjars/**"})).permitAll().and()).authorizeRequests().antMatchers(new String[]{"/console/**"})).permitAll().and()).cors().and()).authorizeRequests().anyRequest()).authenticated();
        ((HttpSecurity)http.csrf().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        http.headers().frameOptions().disable();
        http.addFilterBefore((Filter)new JWTAuthenticationFilter(this.tokenAuthenticationService), BasicAuthenticationFilter.class);
    }

    @Bean
    @Scope(scopeName="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public Principal getPrincipal() {
        return WebSecurityConfig.auth().orElse(null);
    }

    @Bean
    @Scope(scopeName="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public AccessTokenTO getAccessTokenTO() {
        return WebSecurityConfig.auth().map(arg_0 -> this.extractToken(arg_0)).orElse(null);
    }

    private static Optional<MiddlewareAuthentication> auth() {
        return SecurityContextHolder.getContext() == null ? Optional.empty() : Optional.ofNullable((MiddlewareAuthentication)SecurityContextHolder.getContext().getAuthentication());
    }

    private AccessTokenTO extractToken(MiddlewareAuthentication authentication) {
        return authentication.getBearerToken().getAccessTokenObject();
    }

    @Bean
    CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration().applyPermitDefaultValues();
        configuration.setAllowedOrigins(this.corsConfigProperties.getAllowedOrigins());
        configuration.setAllowedMethods(this.corsConfigProperties.getAllowedMethods());
        configuration.setAllowedHeaders(this.corsConfigProperties.getAllowedHeaders());
        configuration.setAllowCredentials(this.corsConfigProperties.getAllowCredentials());
        configuration.setMaxAge(Long.valueOf(this.corsConfigProperties.getMaxAge()));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return source;
    }
}

