/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.token.exchange;

import de.adorsys.ledgers.token.exchange.TokenConfiguration;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.OAuthErrorException;
import org.keycloak.TokenVerifier;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.resource.RealmResourceProvider;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.util.DefaultClientSessionContext;

public class ConfigurableTokenResourceProvider
implements RealmResourceProvider {
    static final String ID = "configurable-token";
    private static final Logger LOG = Logger.getLogger(ConfigurableTokenResourceProvider.class);
    private final KeycloakSession session;
    private final TokenManager tokenManager;

    ConfigurableTokenResourceProvider(KeycloakSession session) {
        this.session = session;
        this.tokenManager = new TokenManager();
    }

    public Object getResource() {
        return this;
    }

    public void close() {
    }

    @OPTIONS
    public Response preflight(@Context HttpRequest request) {
        return Cors.add((HttpRequest)request, (Response.ResponseBuilder)Response.ok()).auth().preflight().allowedMethods(new String[]{"POST", "OPTIONS"}).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createToken(TokenConfiguration tokenConfiguration, @Context HttpRequest request) {
        try {
            AccessToken accessToken = this.validateTokenAndUpdateSession(request);
            UserSessionModel userSession = this.findSession();
            AccessTokenResponse response = this.createAccessToken(userSession, accessToken, tokenConfiguration);
            return this.buildCorsResponse(request, response);
        }
        catch (ConfigurableTokenException e) {
            LOG.error((Object)"An error occurred when fetching an access token", (Throwable)e);
            return ErrorResponse.error((String)e.getMessage(), (Response.Status)Response.Status.BAD_REQUEST);
        }
    }

    private AccessTokenResponse createAccessToken(UserSessionModel userSession, AccessToken accessToken, TokenConfiguration tokenConfiguration) {
        RealmModel realm = this.session.getContext().getRealm();
        ClientModel client = realm.getClientByClientId(accessToken.getIssuedFor());
        LOG.infof("Configurable token requested for username=%s and client=%s on realm=%s", (Object)userSession.getUser().getUsername(), (Object)client.getClientId(), (Object)realm.getName());
        AuthenticatedClientSessionModel clientSession = userSession.getAuthenticatedClientSessionByClient(client.getId());
        DefaultClientSessionContext clientSessionContext = DefaultClientSessionContext.fromClientSessionScopeParameter((AuthenticatedClientSessionModel)clientSession, (KeycloakSession)this.session);
        AccessToken newToken = this.tokenManager.createClientAccessToken(this.session, realm, client, userSession.getUser(), userSession, (ClientSessionContext)clientSessionContext);
        this.updateTokenExpiration(newToken, tokenConfiguration);
        this.updateScope(newToken, tokenConfiguration);
        return this.buildResponse(realm, userSession, client, clientSession, newToken);
    }

    private AccessToken validateTokenAndUpdateSession(HttpRequest request) throws ConfigurableTokenException {
        try {
            RealmModel realm = this.session.getContext().getRealm();
            String tokenString = this.readAccessTokenFrom(request);
            TokenVerifier verifier = TokenVerifier.create((String)tokenString, AccessToken.class).withChecks(new TokenVerifier.Predicate[]{TokenVerifier.IS_ACTIVE, new TokenVerifier.RealmUrlCheck(Urls.realmIssuer((URI)this.session.getContext().getUri().getBaseUri(), (String)realm.getName()))});
            SignatureVerifierContext verifierContext = ((SignatureProvider)this.session.getProvider(SignatureProvider.class, verifier.getHeader().getAlgorithm().name())).verifier(verifier.getHeader().getKeyId());
            verifier.verifierContext(verifierContext);
            AccessToken accessToken = (AccessToken)verifier.verify().getToken();
            if (!this.tokenManager.checkTokenValidForIntrospection(this.session, realm, accessToken)) {
                throw new VerificationException("introspection_failed");
            }
            return accessToken;
        }
        catch (ConfigurableTokenException e) {
            throw e;
        }
        catch (OAuthErrorException | VerificationException e) {
            LOG.warn((Object)"Keycloak-ConfigurableToken: introspection of token failed", e);
            throw new ConfigurableTokenException("access_token_introspection_failed: " + e.getMessage());
        }
    }

    private String readAccessTokenFrom(HttpRequest request) throws ConfigurableTokenException {
        String authorization = request.getHttpHeaders().getHeaderString("Authorization");
        if (authorization == null || !authorization.startsWith("Bearer ")) {
            LOG.warn((Object)"Keycloak-ConfigurableToken: no authorization header with bearer token");
            throw new ConfigurableTokenException("bearer_token_missing_in_authorization_header");
        }
        String token = authorization.substring(7);
        if (token.isEmpty()) {
            LOG.warn((Object)"Keycloak-ConfigurableToken: empty access token");
            throw new ConfigurableTokenException("missing_access_token");
        }
        return token;
    }

    private UserSessionModel findSession() throws ConfigurableTokenException {
        RealmModel realm = this.session.getContext().getRealm();
        AuthenticationManager.AuthResult authenticated = new AppAuthManager().authenticateBearerToken(this.session, realm);
        if (authenticated == null) {
            LOG.warn((Object)"Keycloak-ConfigurableToken: user not authenticated");
            throw new ConfigurableTokenException("not_authenticated");
        }
        if (authenticated.getToken().getRealmAccess() == null) {
            LOG.warn((Object)"Keycloak-ConfigurableToken: no realm associated with authorization");
            throw new ConfigurableTokenException("wrong_realm");
        }
        UserModel user = authenticated.getUser();
        if (user == null || !user.isEnabled()) {
            LOG.warn((Object)"Keycloak-ConfigurableToken: user does not exist or is not enabled");
            throw new ConfigurableTokenException("invalid_user");
        }
        UserSessionModel userSession = authenticated.getSession();
        if (userSession == null) {
            LOG.warn((Object)"Keycloak-ConfigurableToken: user does not have any active session");
            throw new ConfigurableTokenException("missing_user_session");
        }
        return userSession;
    }

    private Response buildCorsResponse(@Context HttpRequest request, AccessTokenResponse response) {
        Cors cors = Cors.add((HttpRequest)request).auth().allowedMethods(new String[]{"POST"}).auth().exposedHeaders(new String[]{"Access-Control-Allow-Methods", "Access-Control-Allow-Origin"}).allowAllOrigins();
        return cors.builder(Response.ok((Object)response).type(MediaType.APPLICATION_JSON_TYPE)).build();
    }

    private AccessTokenResponse buildResponse(RealmModel realm, UserSessionModel userSession, ClientModel client, AuthenticatedClientSessionModel clientSession, AccessToken token) {
        EventBuilder eventBuilder = new EventBuilder(realm, this.session, this.session.getContext().getConnection());
        DefaultClientSessionContext clientSessionContext = DefaultClientSessionContext.fromClientSessionScopeParameter((AuthenticatedClientSessionModel)clientSession, (KeycloakSession)this.session);
        return this.tokenManager.responseBuilder(realm, client, eventBuilder, this.session, userSession, (ClientSessionContext)clientSessionContext).accessToken(token).build();
    }

    private void updateTokenExpiration(AccessToken token, TokenConfiguration tokenConfiguration) {
        token.expiration(tokenConfiguration.computeTokenExpiration(token.getExpiration(), true));
    }

    private void updateScope(AccessToken token, TokenConfiguration tokenConfiguration) {
        String offlineAccess = token.getScope().contains("offline_access") ? " offline_access" : "";
        String updatedScope = token.getScope() + " " + tokenConfiguration.getScope() + offlineAccess;
        token.setScope(updatedScope.trim());
    }

    static class ConfigurableTokenException
    extends Exception {
        public ConfigurableTokenException(String message) {
            super(message);
        }
    }
}

