/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.keycloak.client.mapper;

import de.adorsys.ledgers.keycloak.client.mapper.KeycloakDataMapper;
import de.adorsys.ledgers.keycloak.client.model.KeycloakRealm;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.representations.idm.RealmRepresentation;
import org.springframework.stereotype.Component;

@Component
public class KeycloakDataMapperImpl
implements KeycloakDataMapper {
    @Override
    public RealmRepresentation createRealmRepresentation(KeycloakRealm source) {
        if (source == null) {
            return null;
        }
        RealmRepresentation realmRepresentation = new RealmRepresentation();
        realmRepresentation.setRealm(source.getRealm());
        realmRepresentation.setEnabled(Boolean.valueOf(source.isEnabled()));
        realmRepresentation.setAccessTokenLifespan(source.getAccessTokenLifespan());
        realmRepresentation.setAccessTokenLifespanForImplicitFlow(source.getAccessTokenLifespanForImplicitFlow());
        realmRepresentation.setOfflineSessionIdleTimeout(source.getOfflineSessionIdleTimeout());
        realmRepresentation.setOfflineSessionMaxLifespanEnabled(Boolean.valueOf(source.isOfflineSessionMaxLifespanEnabled()));
        realmRepresentation.setOfflineSessionMaxLifespan(source.getOfflineSessionMaxLifespan());
        realmRepresentation.setClientSessionIdleTimeout(source.getClientSessionIdleTimeout());
        realmRepresentation.setClientSessionMaxLifespan(source.getClientSessionMaxLifespan());
        realmRepresentation.setClientOfflineSessionIdleTimeout(source.getClientOfflineSessionIdleTimeout());
        realmRepresentation.setClientOfflineSessionMaxLifespan(source.getClientOfflineSessionMaxLifespan());
        realmRepresentation.setRegistrationAllowed(Boolean.valueOf(source.isRegistrationAllowed()));
        realmRepresentation.setRegistrationEmailAsUsername(Boolean.valueOf(source.isRegistrationEmailAsUsername()));
        realmRepresentation.setVerifyEmail(Boolean.valueOf(source.isVerifyEmail()));
        realmRepresentation.setLoginWithEmailAllowed(Boolean.valueOf(source.isLoginWithEmailAllowed()));
        realmRepresentation.setDuplicateEmailsAllowed(Boolean.valueOf(source.isDuplicateEmailsAllowed()));
        realmRepresentation.setResetPasswordAllowed(Boolean.valueOf(source.isResetPasswordAllowed()));
        realmRepresentation.setEditUsernameAllowed(Boolean.valueOf(source.isEditUsernameAllowed()));
        Map<String, String> map = source.getSmtpServer();
        if (map != null) {
            realmRepresentation.setSmtpServer(new HashMap<String, String>(map));
        }
        return realmRepresentation;
    }
}

