/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.keycloak.client.mapper;

import de.adorsys.ledgers.middleware.api.domain.um.AccessTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper(componentModel="spring")
public interface KeycloakAuthMapper {
    @Mappings(value={@Mapping(target="act", ignore=true), @Mapping(target="scaId", ignore=true), @Mapping(target="consent", ignore=true), @Mapping(target="authorisationId", ignore=true), @Mapping(target="iat", source="source.token.issuedAt"), @Mapping(target="role", expression="java(getLedgersUserRoles(source.getToken()))"), @Mapping(target="sub", source="source.token.subject"), @Mapping(target="scopes", source="source.token.scope"), @Mapping(target="login", source="source.token.name"), @Mapping(target="exp", source="source.token.exp"), @Mapping(target="jti", source="source.token.id"), @Mapping(target="accessToken", source="source.tokenString"), @Mapping(target="tokenUsage", expression="java(de.adorsys.ledgers.middleware.api.domain.um.TokenUsageTO.DIRECT_ACCESS)")})
    public AccessTokenTO toAccessToken(RefreshableKeycloakSecurityContext var1);

    @Mappings(value={@Mapping(target="accessTokenObject", ignore=true), @Mapping(target="scopes", source="source.scope"), @Mapping(target="access_token", source="token"), @Mapping(target="expires_in", source="expiresIn"), @Mapping(target="refresh_token", source="refreshToken"), @Mapping(target="token_type", source="tokenType")})
    public BearerTokenTO toBearerTokenTO(AccessTokenResponse var1);

    default public Set<String> toScopes(String scope) {
        return Optional.ofNullable(scope).map(s -> new HashSet<String>(Arrays.asList(s.split(" ")))).orElse(new HashSet());
    }

    default public BearerTokenTO toBearer(AccessToken source, String token) {
        AccessTokenTO to = this.toTokenTO(source, token);
        long ttl = (to.getExp().getTime() - new Date().getTime()) / 1000L;
        return new BearerTokenTO(token, "Bearer", (int)ttl, null, to, to.getScopes());
    }

    @Mappings(value={@Mapping(target="scaId", ignore=true), @Mapping(target="consent", ignore=true), @Mapping(target="authorisationId", ignore=true), @Mapping(target="act", ignore=true), @Mapping(target="exp", source="source.exp"), @Mapping(target="jti", source="source.id"), @Mapping(target="sub", source="source.subject"), @Mapping(target="iat", source="source.iat"), @Mapping(target="accessToken", source="token"), @Mapping(target="scopes", source="source.scope"), @Mapping(target="role", source="source"), @Mapping(target="login", source="source.name"), @Mapping(target="tokenUsage", expression="java(de.adorsys.ledgers.middleware.api.domain.um.TokenUsageTO.DIRECT_ACCESS)")})
    public AccessTokenTO toTokenTO(AccessToken var1, String var2);

    default public Date toDate(long source) {
        return new Date(source * 1000L);
    }

    default public UserRoleTO getLedgersUserRoles(AccessToken token) {
        Set tokenizedRoles = Optional.ofNullable(token.getRealmAccess()).map(AccessToken.Access::getRoles).orElseGet(Collections::emptySet);
        Collection roles = CollectionUtils.intersection((Iterable)tokenizedRoles.stream().map(UserRoleTO::getByValue).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()), Arrays.asList(UserRoleTO.values()));
        return roles.isEmpty() ? null : (UserRoleTO)UserRoleTO.getByValue((String)((UserRoleTO)roles.iterator().next()).toString()).orElse(null);
    }
}

