/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.keycloak.client.model;

import de.adorsys.ledgers.middleware.api.domain.Constants;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;

public class KeycloakRealm {
    private String realm;
    private boolean enabled = true;
    private Integer accessTokenLifespan;
    private Integer accessTokenLifespanForImplicitFlow;
    private Integer clientSessionIdleTimeout;
    private Integer clientSessionMaxLifespan;
    private boolean offlineSessionMaxLifespanEnabled = true;
    private Integer offlineSessionIdleTimeout;
    private Integer offlineSessionMaxLifespan;
    private Integer clientOfflineSessionIdleTimeout;
    private Integer clientOfflineSessionMaxLifespan;
    private boolean registrationAllowed = false;
    private boolean registrationEmailAsUsername = false;
    private boolean verifyEmail = true;
    private boolean loginWithEmailAllowed = true;
    private boolean duplicateEmailsAllowed = false;
    private boolean resetPasswordAllowed = true;
    private boolean editUsernameAllowed = true;
    private Map<String, String> smtpServer;

    public KeycloakRealm(String realmName, Integer loginTokenTTL, Integer offlineTokenTTL, Map<String, String> smtpServer) {
        this.realm = realmName;
        this.accessTokenLifespan = loginTokenTTL;
        this.accessTokenLifespanForImplicitFlow = loginTokenTTL;
        this.clientSessionIdleTimeout = loginTokenTTL;
        this.clientSessionMaxLifespan = loginTokenTTL;
        this.offlineSessionIdleTimeout = offlineTokenTTL;
        this.offlineSessionMaxLifespan = offlineTokenTTL;
        this.clientOfflineSessionIdleTimeout = offlineTokenTTL;
        this.clientOfflineSessionMaxLifespan = offlineTokenTTL;
        this.smtpServer = smtpServer;
    }

    public boolean notPresentRealm(List<RealmRepresentation> allRealms) {
        if (!allRealms.isEmpty()) {
            return allRealms.stream().map(RealmRepresentation::getRealm).noneMatch(this.realm::equals);
        }
        return true;
    }

    public List<String> getScopesToAdd(List<ClientScopeRepresentation> scopes) {
        List<String> list = scopes.stream().map(ClientScopeRepresentation::getName).collect(Collectors.toList());
        return this.filter(list, Constants.ALL_SCOPES);
    }

    public List<String> getRolesToAdd(List<RoleRepresentation> roles) {
        List<String> list = roles.stream().map(RoleRepresentation::getName).collect(Collectors.toList());
        return this.filter(list, UserRoleTO.ALL_ROLES);
    }

    private List<String> filter(List<String> filteredList, List<String> streamedSource) {
        return streamedSource.stream().filter(s -> !filteredList.contains(s)).collect(Collectors.toList());
    }

    private KeycloakRealm() {
    }

    public String getRealm() {
        return this.realm;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Integer getAccessTokenLifespan() {
        return this.accessTokenLifespan;
    }

    public Integer getAccessTokenLifespanForImplicitFlow() {
        return this.accessTokenLifespanForImplicitFlow;
    }

    public Integer getClientSessionIdleTimeout() {
        return this.clientSessionIdleTimeout;
    }

    public Integer getClientSessionMaxLifespan() {
        return this.clientSessionMaxLifespan;
    }

    public boolean isOfflineSessionMaxLifespanEnabled() {
        return this.offlineSessionMaxLifespanEnabled;
    }

    public Integer getOfflineSessionIdleTimeout() {
        return this.offlineSessionIdleTimeout;
    }

    public Integer getOfflineSessionMaxLifespan() {
        return this.offlineSessionMaxLifespan;
    }

    public Integer getClientOfflineSessionIdleTimeout() {
        return this.clientOfflineSessionIdleTimeout;
    }

    public Integer getClientOfflineSessionMaxLifespan() {
        return this.clientOfflineSessionMaxLifespan;
    }

    public boolean isRegistrationAllowed() {
        return this.registrationAllowed;
    }

    public boolean isRegistrationEmailAsUsername() {
        return this.registrationEmailAsUsername;
    }

    public boolean isVerifyEmail() {
        return this.verifyEmail;
    }

    public boolean isLoginWithEmailAllowed() {
        return this.loginWithEmailAllowed;
    }

    public boolean isDuplicateEmailsAllowed() {
        return this.duplicateEmailsAllowed;
    }

    public boolean isResetPasswordAllowed() {
        return this.resetPasswordAllowed;
    }

    public boolean isEditUsernameAllowed() {
        return this.editUsernameAllowed;
    }

    public Map<String, String> getSmtpServer() {
        return this.smtpServer;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setAccessTokenLifespan(Integer accessTokenLifespan) {
        this.accessTokenLifespan = accessTokenLifespan;
    }

    public void setAccessTokenLifespanForImplicitFlow(Integer accessTokenLifespanForImplicitFlow) {
        this.accessTokenLifespanForImplicitFlow = accessTokenLifespanForImplicitFlow;
    }

    public void setClientSessionIdleTimeout(Integer clientSessionIdleTimeout) {
        this.clientSessionIdleTimeout = clientSessionIdleTimeout;
    }

    public void setClientSessionMaxLifespan(Integer clientSessionMaxLifespan) {
        this.clientSessionMaxLifespan = clientSessionMaxLifespan;
    }

    public void setOfflineSessionMaxLifespanEnabled(boolean offlineSessionMaxLifespanEnabled) {
        this.offlineSessionMaxLifespanEnabled = offlineSessionMaxLifespanEnabled;
    }

    public void setOfflineSessionIdleTimeout(Integer offlineSessionIdleTimeout) {
        this.offlineSessionIdleTimeout = offlineSessionIdleTimeout;
    }

    public void setOfflineSessionMaxLifespan(Integer offlineSessionMaxLifespan) {
        this.offlineSessionMaxLifespan = offlineSessionMaxLifespan;
    }

    public void setClientOfflineSessionIdleTimeout(Integer clientOfflineSessionIdleTimeout) {
        this.clientOfflineSessionIdleTimeout = clientOfflineSessionIdleTimeout;
    }

    public void setClientOfflineSessionMaxLifespan(Integer clientOfflineSessionMaxLifespan) {
        this.clientOfflineSessionMaxLifespan = clientOfflineSessionMaxLifespan;
    }

    public void setRegistrationAllowed(boolean registrationAllowed) {
        this.registrationAllowed = registrationAllowed;
    }

    public void setRegistrationEmailAsUsername(boolean registrationEmailAsUsername) {
        this.registrationEmailAsUsername = registrationEmailAsUsername;
    }

    public void setVerifyEmail(boolean verifyEmail) {
        this.verifyEmail = verifyEmail;
    }

    public void setLoginWithEmailAllowed(boolean loginWithEmailAllowed) {
        this.loginWithEmailAllowed = loginWithEmailAllowed;
    }

    public void setDuplicateEmailsAllowed(boolean duplicateEmailsAllowed) {
        this.duplicateEmailsAllowed = duplicateEmailsAllowed;
    }

    public void setResetPasswordAllowed(boolean resetPasswordAllowed) {
        this.resetPasswordAllowed = resetPasswordAllowed;
    }

    public void setEditUsernameAllowed(boolean editUsernameAllowed) {
        this.editUsernameAllowed = editUsernameAllowed;
    }

    public void setSmtpServer(Map<String, String> smtpServer) {
        this.smtpServer = smtpServer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeycloakRealm)) {
            return false;
        }
        KeycloakRealm other = (KeycloakRealm)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$realm = this.getRealm();
        String other$realm = other.getRealm();
        if (this$realm == null ? other$realm != null : !this$realm.equals(other$realm)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        Integer this$accessTokenLifespan = this.getAccessTokenLifespan();
        Integer other$accessTokenLifespan = other.getAccessTokenLifespan();
        if (this$accessTokenLifespan == null ? other$accessTokenLifespan != null : !((Object)this$accessTokenLifespan).equals(other$accessTokenLifespan)) {
            return false;
        }
        Integer this$accessTokenLifespanForImplicitFlow = this.getAccessTokenLifespanForImplicitFlow();
        Integer other$accessTokenLifespanForImplicitFlow = other.getAccessTokenLifespanForImplicitFlow();
        if (this$accessTokenLifespanForImplicitFlow == null ? other$accessTokenLifespanForImplicitFlow != null : !((Object)this$accessTokenLifespanForImplicitFlow).equals(other$accessTokenLifespanForImplicitFlow)) {
            return false;
        }
        Integer this$clientSessionIdleTimeout = this.getClientSessionIdleTimeout();
        Integer other$clientSessionIdleTimeout = other.getClientSessionIdleTimeout();
        if (this$clientSessionIdleTimeout == null ? other$clientSessionIdleTimeout != null : !((Object)this$clientSessionIdleTimeout).equals(other$clientSessionIdleTimeout)) {
            return false;
        }
        Integer this$clientSessionMaxLifespan = this.getClientSessionMaxLifespan();
        Integer other$clientSessionMaxLifespan = other.getClientSessionMaxLifespan();
        if (this$clientSessionMaxLifespan == null ? other$clientSessionMaxLifespan != null : !((Object)this$clientSessionMaxLifespan).equals(other$clientSessionMaxLifespan)) {
            return false;
        }
        if (this.isOfflineSessionMaxLifespanEnabled() != other.isOfflineSessionMaxLifespanEnabled()) {
            return false;
        }
        Integer this$offlineSessionIdleTimeout = this.getOfflineSessionIdleTimeout();
        Integer other$offlineSessionIdleTimeout = other.getOfflineSessionIdleTimeout();
        if (this$offlineSessionIdleTimeout == null ? other$offlineSessionIdleTimeout != null : !((Object)this$offlineSessionIdleTimeout).equals(other$offlineSessionIdleTimeout)) {
            return false;
        }
        Integer this$offlineSessionMaxLifespan = this.getOfflineSessionMaxLifespan();
        Integer other$offlineSessionMaxLifespan = other.getOfflineSessionMaxLifespan();
        if (this$offlineSessionMaxLifespan == null ? other$offlineSessionMaxLifespan != null : !((Object)this$offlineSessionMaxLifespan).equals(other$offlineSessionMaxLifespan)) {
            return false;
        }
        Integer this$clientOfflineSessionIdleTimeout = this.getClientOfflineSessionIdleTimeout();
        Integer other$clientOfflineSessionIdleTimeout = other.getClientOfflineSessionIdleTimeout();
        if (this$clientOfflineSessionIdleTimeout == null ? other$clientOfflineSessionIdleTimeout != null : !((Object)this$clientOfflineSessionIdleTimeout).equals(other$clientOfflineSessionIdleTimeout)) {
            return false;
        }
        Integer this$clientOfflineSessionMaxLifespan = this.getClientOfflineSessionMaxLifespan();
        Integer other$clientOfflineSessionMaxLifespan = other.getClientOfflineSessionMaxLifespan();
        if (this$clientOfflineSessionMaxLifespan == null ? other$clientOfflineSessionMaxLifespan != null : !((Object)this$clientOfflineSessionMaxLifespan).equals(other$clientOfflineSessionMaxLifespan)) {
            return false;
        }
        if (this.isRegistrationAllowed() != other.isRegistrationAllowed()) {
            return false;
        }
        if (this.isRegistrationEmailAsUsername() != other.isRegistrationEmailAsUsername()) {
            return false;
        }
        if (this.isVerifyEmail() != other.isVerifyEmail()) {
            return false;
        }
        if (this.isLoginWithEmailAllowed() != other.isLoginWithEmailAllowed()) {
            return false;
        }
        if (this.isDuplicateEmailsAllowed() != other.isDuplicateEmailsAllowed()) {
            return false;
        }
        if (this.isResetPasswordAllowed() != other.isResetPasswordAllowed()) {
            return false;
        }
        if (this.isEditUsernameAllowed() != other.isEditUsernameAllowed()) {
            return false;
        }
        Map<String, String> this$smtpServer = this.getSmtpServer();
        Map<String, String> other$smtpServer = other.getSmtpServer();
        return !(this$smtpServer == null ? other$smtpServer != null : !((Object)this$smtpServer).equals(other$smtpServer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KeycloakRealm;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $realm = this.getRealm();
        result = result * 59 + ($realm == null ? 43 : $realm.hashCode());
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        Integer $accessTokenLifespan = this.getAccessTokenLifespan();
        result = result * 59 + ($accessTokenLifespan == null ? 43 : ((Object)$accessTokenLifespan).hashCode());
        Integer $accessTokenLifespanForImplicitFlow = this.getAccessTokenLifespanForImplicitFlow();
        result = result * 59 + ($accessTokenLifespanForImplicitFlow == null ? 43 : ((Object)$accessTokenLifespanForImplicitFlow).hashCode());
        Integer $clientSessionIdleTimeout = this.getClientSessionIdleTimeout();
        result = result * 59 + ($clientSessionIdleTimeout == null ? 43 : ((Object)$clientSessionIdleTimeout).hashCode());
        Integer $clientSessionMaxLifespan = this.getClientSessionMaxLifespan();
        result = result * 59 + ($clientSessionMaxLifespan == null ? 43 : ((Object)$clientSessionMaxLifespan).hashCode());
        result = result * 59 + (this.isOfflineSessionMaxLifespanEnabled() ? 79 : 97);
        Integer $offlineSessionIdleTimeout = this.getOfflineSessionIdleTimeout();
        result = result * 59 + ($offlineSessionIdleTimeout == null ? 43 : ((Object)$offlineSessionIdleTimeout).hashCode());
        Integer $offlineSessionMaxLifespan = this.getOfflineSessionMaxLifespan();
        result = result * 59 + ($offlineSessionMaxLifespan == null ? 43 : ((Object)$offlineSessionMaxLifespan).hashCode());
        Integer $clientOfflineSessionIdleTimeout = this.getClientOfflineSessionIdleTimeout();
        result = result * 59 + ($clientOfflineSessionIdleTimeout == null ? 43 : ((Object)$clientOfflineSessionIdleTimeout).hashCode());
        Integer $clientOfflineSessionMaxLifespan = this.getClientOfflineSessionMaxLifespan();
        result = result * 59 + ($clientOfflineSessionMaxLifespan == null ? 43 : ((Object)$clientOfflineSessionMaxLifespan).hashCode());
        result = result * 59 + (this.isRegistrationAllowed() ? 79 : 97);
        result = result * 59 + (this.isRegistrationEmailAsUsername() ? 79 : 97);
        result = result * 59 + (this.isVerifyEmail() ? 79 : 97);
        result = result * 59 + (this.isLoginWithEmailAllowed() ? 79 : 97);
        result = result * 59 + (this.isDuplicateEmailsAllowed() ? 79 : 97);
        result = result * 59 + (this.isResetPasswordAllowed() ? 79 : 97);
        result = result * 59 + (this.isEditUsernameAllowed() ? 79 : 97);
        Map<String, String> $smtpServer = this.getSmtpServer();
        result = result * 59 + ($smtpServer == null ? 43 : ((Object)$smtpServer).hashCode());
        return result;
    }

    public String toString() {
        return "KeycloakRealm(realm=" + this.getRealm() + ", enabled=" + this.isEnabled() + ", accessTokenLifespan=" + this.getAccessTokenLifespan() + ", accessTokenLifespanForImplicitFlow=" + this.getAccessTokenLifespanForImplicitFlow() + ", clientSessionIdleTimeout=" + this.getClientSessionIdleTimeout() + ", clientSessionMaxLifespan=" + this.getClientSessionMaxLifespan() + ", offlineSessionMaxLifespanEnabled=" + this.isOfflineSessionMaxLifespanEnabled() + ", offlineSessionIdleTimeout=" + this.getOfflineSessionIdleTimeout() + ", offlineSessionMaxLifespan=" + this.getOfflineSessionMaxLifespan() + ", clientOfflineSessionIdleTimeout=" + this.getClientOfflineSessionIdleTimeout() + ", clientOfflineSessionMaxLifespan=" + this.getClientOfflineSessionMaxLifespan() + ", registrationAllowed=" + this.isRegistrationAllowed() + ", registrationEmailAsUsername=" + this.isRegistrationEmailAsUsername() + ", verifyEmail=" + this.isVerifyEmail() + ", loginWithEmailAllowed=" + this.isLoginWithEmailAllowed() + ", duplicateEmailsAllowed=" + this.isDuplicateEmailsAllowed() + ", resetPasswordAllowed=" + this.isResetPasswordAllowed() + ", editUsernameAllowed=" + this.isEditUsernameAllowed() + ", smtpServer=" + this.getSmtpServer() + ")";
    }
}

