/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.keycloak.client.model;

import de.adorsys.ledgers.keycloak.client.config.KeycloakClientConfig;
import de.adorsys.ledgers.middleware.api.domain.Constants;
import java.util.Arrays;
import java.util.List;
import org.keycloak.representations.idm.ClientRepresentation;

public class KeycloakClient {
    private String clientId;
    private String clientSecret;
    private List<String> redirectUrls;
    private List<String> scopes;
    private List<String> webOrigins;
    private boolean publicClient;
    private boolean fullScopeAllowed = true;

    public KeycloakClient(KeycloakClientConfig configuration, List<String> redirectUrls) {
        this.clientId = configuration.getExternalClientId();
        this.clientSecret = configuration.isPublicClient() ? null : configuration.getClientSecret();
        this.redirectUrls = redirectUrls;
        this.scopes = Constants.ALL_SCOPES;
        this.webOrigins = Arrays.asList("*", "http://localhost:8080");
        this.publicClient = configuration.isPublicClient();
    }

    public boolean notPresent(List<ClientRepresentation> allClients) {
        if (!allClients.isEmpty()) {
            return allClients.stream().map(ClientRepresentation::getName).noneMatch(this.clientId::equals);
        }
        return true;
    }

    private KeycloakClient() {
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public List<String> getRedirectUrls() {
        return this.redirectUrls;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public List<String> getWebOrigins() {
        return this.webOrigins;
    }

    public boolean isPublicClient() {
        return this.publicClient;
    }

    public boolean isFullScopeAllowed() {
        return this.fullScopeAllowed;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setRedirectUrls(List<String> redirectUrls) {
        this.redirectUrls = redirectUrls;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public void setWebOrigins(List<String> webOrigins) {
        this.webOrigins = webOrigins;
    }

    public void setPublicClient(boolean publicClient) {
        this.publicClient = publicClient;
    }

    public void setFullScopeAllowed(boolean fullScopeAllowed) {
        this.fullScopeAllowed = fullScopeAllowed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeycloakClient)) {
            return false;
        }
        KeycloakClient other = (KeycloakClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        List<String> this$redirectUrls = this.getRedirectUrls();
        List<String> other$redirectUrls = other.getRedirectUrls();
        if (this$redirectUrls == null ? other$redirectUrls != null : !((Object)this$redirectUrls).equals(other$redirectUrls)) {
            return false;
        }
        List<String> this$scopes = this.getScopes();
        List<String> other$scopes = other.getScopes();
        if (this$scopes == null ? other$scopes != null : !((Object)this$scopes).equals(other$scopes)) {
            return false;
        }
        List<String> this$webOrigins = this.getWebOrigins();
        List<String> other$webOrigins = other.getWebOrigins();
        if (this$webOrigins == null ? other$webOrigins != null : !((Object)this$webOrigins).equals(other$webOrigins)) {
            return false;
        }
        if (this.isPublicClient() != other.isPublicClient()) {
            return false;
        }
        return this.isFullScopeAllowed() == other.isFullScopeAllowed();
    }

    protected boolean canEqual(Object other) {
        return other instanceof KeycloakClient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        List<String> $redirectUrls = this.getRedirectUrls();
        result = result * 59 + ($redirectUrls == null ? 43 : ((Object)$redirectUrls).hashCode());
        List<String> $scopes = this.getScopes();
        result = result * 59 + ($scopes == null ? 43 : ((Object)$scopes).hashCode());
        List<String> $webOrigins = this.getWebOrigins();
        result = result * 59 + ($webOrigins == null ? 43 : ((Object)$webOrigins).hashCode());
        result = result * 59 + (this.isPublicClient() ? 79 : 97);
        result = result * 59 + (this.isFullScopeAllowed() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "KeycloakClient(clientId=" + this.getClientId() + ", clientSecret=" + this.getClientSecret() + ", redirectUrls=" + this.getRedirectUrls() + ", scopes=" + this.getScopes() + ", webOrigins=" + this.getWebOrigins() + ", publicClient=" + this.isPublicClient() + ", fullScopeAllowed=" + this.isFullScopeAllowed() + ")";
    }
}

