/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.keycloak.client.mapper;

import de.adorsys.ledgers.keycloak.client.mapper.KeycloakAuthMapper;
import de.adorsys.ledgers.middleware.api.domain.um.AccessTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.TokenUsageTO;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.springframework.stereotype.Component;

@Component
public class KeycloakAuthMapperImpl
implements KeycloakAuthMapper {
    @Override
    public AccessTokenTO toAccessToken(RefreshableKeycloakSecurityContext source) {
        if (source == null) {
            return null;
        }
        AccessTokenTO accessTokenTO = new AccessTokenTO();
        Integer issuedAt = this.sourceTokenIssuedAt(source);
        if (issuedAt != null) {
            accessTokenTO.setIat(this.toDate(issuedAt.longValue()));
        }
        accessTokenTO.setSub(this.sourceTokenSubject(source));
        String scope = this.sourceTokenScope(source);
        accessTokenTO.setScopes(this.toScopes(scope));
        accessTokenTO.setLogin(this.sourceTokenName(source));
        Long exp = this.sourceTokenExp(source);
        if (exp != null) {
            accessTokenTO.setExp(this.toDate(exp));
        }
        accessTokenTO.setJti(this.sourceTokenId(source));
        accessTokenTO.setAccessToken(source.getTokenString());
        accessTokenTO.setRole(this.getLedgersUserRoles(source.getToken()));
        accessTokenTO.setTokenUsage(TokenUsageTO.DIRECT_ACCESS);
        return accessTokenTO;
    }

    @Override
    public BearerTokenTO toBearerTokenTO(AccessTokenResponse source) {
        if (source == null) {
            return null;
        }
        BearerTokenTO bearerTokenTO = new BearerTokenTO();
        bearerTokenTO.setScopes(this.toScopes(source.getScope()));
        bearerTokenTO.setAccess_token(source.getToken());
        bearerTokenTO.setExpires_in((int)source.getExpiresIn());
        bearerTokenTO.setRefresh_token(source.getRefreshToken());
        bearerTokenTO.setToken_type(source.getTokenType());
        return bearerTokenTO;
    }

    @Override
    public AccessTokenTO toTokenTO(AccessToken source, String token) {
        if (source == null && token == null) {
            return null;
        }
        AccessTokenTO accessTokenTO = new AccessTokenTO();
        if (source != null) {
            if (source.getExp() != null) {
                accessTokenTO.setExp(this.toDate(source.getExp()));
            }
            accessTokenTO.setJti(source.getId());
            accessTokenTO.setSub(source.getSubject());
            if (source.getIat() != null) {
                accessTokenTO.setIat(this.toDate(source.getIat()));
            }
            accessTokenTO.setScopes(this.toScopes(source.getScope()));
            accessTokenTO.setRole(this.getLedgersUserRoles(source));
            accessTokenTO.setLogin(source.getName());
        }
        if (token != null) {
            accessTokenTO.setAccessToken(token);
        }
        accessTokenTO.setTokenUsage(TokenUsageTO.DIRECT_ACCESS);
        return accessTokenTO;
    }

    private Integer sourceTokenIssuedAt(RefreshableKeycloakSecurityContext refreshableKeycloakSecurityContext) {
        if (refreshableKeycloakSecurityContext == null) {
            return null;
        }
        AccessToken token = refreshableKeycloakSecurityContext.getToken();
        if (token == null) {
            return null;
        }
        int issuedAt = token.getIssuedAt();
        return issuedAt;
    }

    private String sourceTokenSubject(RefreshableKeycloakSecurityContext refreshableKeycloakSecurityContext) {
        if (refreshableKeycloakSecurityContext == null) {
            return null;
        }
        AccessToken token = refreshableKeycloakSecurityContext.getToken();
        if (token == null) {
            return null;
        }
        String subject = token.getSubject();
        if (subject == null) {
            return null;
        }
        return subject;
    }

    private String sourceTokenScope(RefreshableKeycloakSecurityContext refreshableKeycloakSecurityContext) {
        if (refreshableKeycloakSecurityContext == null) {
            return null;
        }
        AccessToken token = refreshableKeycloakSecurityContext.getToken();
        if (token == null) {
            return null;
        }
        String scope = token.getScope();
        if (scope == null) {
            return null;
        }
        return scope;
    }

    private String sourceTokenName(RefreshableKeycloakSecurityContext refreshableKeycloakSecurityContext) {
        if (refreshableKeycloakSecurityContext == null) {
            return null;
        }
        AccessToken token = refreshableKeycloakSecurityContext.getToken();
        if (token == null) {
            return null;
        }
        String name = token.getName();
        if (name == null) {
            return null;
        }
        return name;
    }

    private Long sourceTokenExp(RefreshableKeycloakSecurityContext refreshableKeycloakSecurityContext) {
        if (refreshableKeycloakSecurityContext == null) {
            return null;
        }
        AccessToken token = refreshableKeycloakSecurityContext.getToken();
        if (token == null) {
            return null;
        }
        Long exp = token.getExp();
        if (exp == null) {
            return null;
        }
        return exp;
    }

    private String sourceTokenId(RefreshableKeycloakSecurityContext refreshableKeycloakSecurityContext) {
        if (refreshableKeycloakSecurityContext == null) {
            return null;
        }
        AccessToken token = refreshableKeycloakSecurityContext.getToken();
        if (token == null) {
            return null;
        }
        String id = token.getId();
        if (id == null) {
            return null;
        }
        return id;
    }
}

