/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.keycloak.client.rest;

import de.adorsys.ledgers.keycloak.client.model.TokenConfiguration;
import feign.Headers;
import java.util.List;
import java.util.Map;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

@FeignClient(value="keycloakTokenRestClient", url="${keycloak.auth-server-url}")
@Headers(value={"Content-Type: application/x-www-form-urlencoded"})
public interface KeycloakTokenRestClient {
    @PostMapping(value={"/realms/${keycloak.realm}/protocol/openid-connect/token"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<Map<String, ?>> login(MultiValueMap<String, Object> var1);

    @PostMapping(value={"/realms/${keycloak.realm}/configurable-token"})
    public ResponseEntity<AccessTokenResponse> exchangeToken(@RequestHeader(value="Authorization") String var1, @RequestBody TokenConfiguration var2);

    @PostMapping(value={"/realms/${keycloak.realm}/protocol/openid-connect/token/introspect"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<AccessToken> validate(MultiValueMap<String, Object> var1);

    @PutMapping(value={"/admin/realms/${keycloak.realm}/users/{user-id}/execute-actions-email"})
    public ResponseEntity<AccessTokenResponse> executeActionsEmail(@RequestHeader(value="Authorization") String var1, @PathVariable(value="user-id") String var2, @RequestBody List<String> var3);
}

