/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.keycloak.client.mapper;

import de.adorsys.ledgers.keycloak.client.model.KeycloakClient;
import de.adorsys.ledgers.keycloak.client.model.KeycloakRealm;
import de.adorsys.ledgers.keycloak.client.model.KeycloakUser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.mapstruct.Mapper;

@Mapper(componentModel="spring")
public interface KeycloakDataMapper {
    default public KeycloakUser toKeycloakUser(UserRepresentation userRepresentation) {
        return new KeycloakUser(userRepresentation.getId(), userRepresentation.getUsername(), null, userRepresentation.isEnabled(), userRepresentation.getFirstName(), userRepresentation.getLastName(), userRepresentation.getEmail(), userRepresentation.isEmailVerified(), userRepresentation.getRealmRoles());
    }

    default public UserRepresentation toUpdateUserPresentation(UserRepresentation userRepresentation, KeycloakUser user) {
        userRepresentation.setFirstName(user.getFirstName());
        userRepresentation.setLastName(user.getLastName());
        userRepresentation.setEnabled(user.getEnabled());
        userRepresentation.setEmailVerified(user.getEmailVerified());
        List<String> realmRoles = user.getRealmRoles();
        userRepresentation.setRealmRoles(CollectionUtils.isNotEmpty(realmRoles) ? realmRoles : Collections.emptyList());
        return userRepresentation;
    }

    public RealmRepresentation createRealmRepresentation(KeycloakRealm var1);

    default public RoleRepresentation createRoleRepresentation(String realmRole) {
        RoleRepresentation rr = new RoleRepresentation();
        rr.setName(realmRole);
        rr.setComposite(false);
        return rr;
    }

    default public ClientRepresentation createClientRepresentation(KeycloakClient client) {
        ClientRepresentation clientRepresentation = new ClientRepresentation();
        clientRepresentation.setClientId(client.getClientId());
        clientRepresentation.setName(client.getClientId());
        clientRepresentation.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
        clientRepresentation.setSecret(client.isPublicClient() ? null : client.getClientSecret());
        clientRepresentation.setWebOrigins(client.getWebOrigins());
        clientRepresentation.setPublicClient(Boolean.valueOf(client.isPublicClient()));
        clientRepresentation.setFullScopeAllowed(Boolean.valueOf(client.isFullScopeAllowed()));
        List<String> redirectUrls = client.getRedirectUrls();
        clientRepresentation.setRedirectUris(CollectionUtils.isNotEmpty(redirectUrls) ? redirectUrls : Collections.emptyList());
        return clientRepresentation;
    }

    default public UserRepresentation createUserRepresentation(KeycloakUser user) {
        UserRepresentation userRepresentation = new UserRepresentation();
        userRepresentation.setUsername(user.getLogin());
        userRepresentation.setFirstName(user.getFirstName());
        userRepresentation.setLastName(user.getLastName());
        userRepresentation.setEmail(user.getEmail());
        userRepresentation.setEnabled(user.getEnabled());
        userRepresentation.setClientRoles(new HashMap());
        List<String> realmRoles = user.getRealmRoles();
        userRepresentation.setRealmRoles(CollectionUtils.isNotEmpty(realmRoles) ? realmRoles : Collections.emptyList());
        userRepresentation.setEmailVerified(user.getEmailVerified());
        userRepresentation.setCredentials(new ArrayList());
        CredentialRepresentation credential = new CredentialRepresentation();
        credential.setType("password");
        credential.setValue(user.getPassword());
        credential.setTemporary(Boolean.valueOf(false));
        userRepresentation.getCredentials().add(credential);
        return userRepresentation;
    }

    default public ClientScopeRepresentation createClientScopeRepresentation(String name) {
        ClientScopeRepresentation clientScopeRepresentation = new ClientScopeRepresentation();
        clientScopeRepresentation.setName(name);
        clientScopeRepresentation.setProtocol("openid-connect");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("display.on.consent.screen", "true");
        attributes.put("include.in.token.scope", "true");
        clientScopeRepresentation.setAttributes(attributes);
        return clientScopeRepresentation;
    }
}

