/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.keycloak.client.mapper;

import de.adorsys.ledgers.keycloak.client.mapper.KeycloakAuthMapper;
import de.adorsys.ledgers.middleware.api.domain.um.AccessTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.TokenUsageTO;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.springframework.stereotype.Component;

@Component
public class KeycloakAuthMapperImpl
implements KeycloakAuthMapper {
    @Override
    public AccessTokenTO toAccessToken(RefreshableKeycloakSecurityContext source) {
        Integer issuedAt;
        if (source == null) {
            return null;
        }
        AccessTokenTO accessTokenTO = new AccessTokenTO();
        accessTokenTO.setSub(this.sourceTokenSubject(source));
        accessTokenTO.setLogin(this.sourceTokenPreferredUsername(source));
        accessTokenTO.setAccessToken(source.getTokenString());
        String scope = this.sourceTokenScope(source);
        accessTokenTO.setScopes(this.toScopes(scope));
        Long exp = this.sourceTokenExp(source);
        if (exp != null) {
            accessTokenTO.setExp(this.toDate(exp));
        }
        if ((issuedAt = this.sourceTokenIssuedAt(source)) != null) {
            accessTokenTO.setIat(this.toDate(issuedAt.longValue()));
        }
        accessTokenTO.setJti(this.sourceTokenId(source));
        accessTokenTO.setRole(this.getLedgersUserRoles(source.getToken()));
        accessTokenTO.setTokenUsage(TokenUsageTO.DIRECT_ACCESS);
        return accessTokenTO;
    }

    @Override
    public BearerTokenTO toBearerTokenTO(AccessTokenResponse source) {
        if (source == null) {
            return null;
        }
        BearerTokenTO bearerTokenTO = new BearerTokenTO();
        bearerTokenTO.setAccess_token(source.getToken());
        bearerTokenTO.setRefresh_token(source.getRefreshToken());
        bearerTokenTO.setScopes(this.toScopes(source.getScope()));
        bearerTokenTO.setToken_type(source.getTokenType());
        bearerTokenTO.setExpires_in((int)source.getExpiresIn());
        return bearerTokenTO;
    }

    @Override
    public AccessTokenTO toTokenTO(AccessToken source, String token) {
        if (source == null && token == null) {
            return null;
        }
        AccessTokenTO accessTokenTO = new AccessTokenTO();
        if (source != null) {
            accessTokenTO.setSub(source.getSubject());
            accessTokenTO.setRole(this.getLedgersUserRoles(source));
            accessTokenTO.setLogin(source.getPreferredUsername());
            accessTokenTO.setScopes(this.toScopes(source.getScope()));
            if (source.getExp() != null) {
                accessTokenTO.setExp(this.toDate(source.getExp()));
            }
            if (source.getIat() != null) {
                accessTokenTO.setIat(this.toDate(source.getIat()));
            }
            accessTokenTO.setJti(source.getId());
        }
        if (token != null) {
            accessTokenTO.setAccessToken(token);
        }
        accessTokenTO.setTokenUsage(TokenUsageTO.DIRECT_ACCESS);
        return accessTokenTO;
    }

    private String sourceTokenSubject(RefreshableKeycloakSecurityContext refreshableKeycloakSecurityContext) {
        if (refreshableKeycloakSecurityContext == null) {
            return null;
        }
        AccessToken token = refreshableKeycloakSecurityContext.getToken();
        if (token == null) {
            return null;
        }
        String subject = token.getSubject();
        if (subject == null) {
            return null;
        }
        return subject;
    }

    private String sourceTokenPreferredUsername(RefreshableKeycloakSecurityContext refreshableKeycloakSecurityContext) {
        if (refreshableKeycloakSecurityContext == null) {
            return null;
        }
        AccessToken token = refreshableKeycloakSecurityContext.getToken();
        if (token == null) {
            return null;
        }
        String preferredUsername = token.getPreferredUsername();
        if (preferredUsername == null) {
            return null;
        }
        return preferredUsername;
    }

    private String sourceTokenScope(RefreshableKeycloakSecurityContext refreshableKeycloakSecurityContext) {
        if (refreshableKeycloakSecurityContext == null) {
            return null;
        }
        AccessToken token = refreshableKeycloakSecurityContext.getToken();
        if (token == null) {
            return null;
        }
        String scope = token.getScope();
        if (scope == null) {
            return null;
        }
        return scope;
    }

    private Long sourceTokenExp(RefreshableKeycloakSecurityContext refreshableKeycloakSecurityContext) {
        if (refreshableKeycloakSecurityContext == null) {
            return null;
        }
        AccessToken token = refreshableKeycloakSecurityContext.getToken();
        if (token == null) {
            return null;
        }
        Long exp = token.getExp();
        if (exp == null) {
            return null;
        }
        return exp;
    }

    private Integer sourceTokenIssuedAt(RefreshableKeycloakSecurityContext refreshableKeycloakSecurityContext) {
        if (refreshableKeycloakSecurityContext == null) {
            return null;
        }
        AccessToken token = refreshableKeycloakSecurityContext.getToken();
        if (token == null) {
            return null;
        }
        int issuedAt = token.getIssuedAt();
        return issuedAt;
    }

    private String sourceTokenId(RefreshableKeycloakSecurityContext refreshableKeycloakSecurityContext) {
        if (refreshableKeycloakSecurityContext == null) {
            return null;
        }
        AccessToken token = refreshableKeycloakSecurityContext.getToken();
        if (token == null) {
            return null;
        }
        String id = token.getId();
        if (id == null) {
            return null;
        }
        return id;
    }
}

