/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.keycloak.client.impl;

import de.adorsys.ledgers.keycloak.client.api.KeycloakTokenService;
import de.adorsys.ledgers.keycloak.client.mapper.KeycloakAuthMapper;
import de.adorsys.ledgers.keycloak.client.model.TokenConfiguration;
import de.adorsys.ledgers.keycloak.client.rest.KeycloakTokenRestClient;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import java.util.Map;
import java.util.Objects;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Service
public class KeycloakTokenServiceImpl
implements KeycloakTokenService {
    private static final Logger log = LoggerFactory.getLogger(KeycloakTokenServiceImpl.class);
    @Value(value="${keycloak.resource:}")
    private String clientId;
    @Value(value="${keycloak.credentials.secret:}")
    private String clientSecret;
    private final KeycloakTokenRestClient keycloakTokenRestClient;
    private final KeycloakAuthMapper authMapper;

    @Override
    public BearerTokenTO login(String username, String password) {
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        formParams.add((Object)"grant_type", (Object)"password");
        formParams.add((Object)"username", (Object)username);
        formParams.add((Object)"password", (Object)password);
        formParams.add((Object)"client_id", (Object)this.clientId);
        formParams.add((Object)"client_secret", (Object)this.clientSecret);
        ResponseEntity<Map<String, ?>> resp = this.keycloakTokenRestClient.login((MultiValueMap<String, Object>)formParams);
        HttpStatus statusCode = resp.getStatusCode();
        if (HttpStatus.OK != statusCode) {
            log.error("Could not obtain token by user credentials [{}]", (Object)username);
        }
        Map body = (Map)Objects.requireNonNull(resp).getBody();
        BearerTokenTO bearerTokenTO = new BearerTokenTO();
        bearerTokenTO.setAccess_token((String)Objects.requireNonNull(body).get("access_token"));
        return bearerTokenTO;
    }

    @Override
    public BearerTokenTO exchangeToken(String oldToken, Integer timeToLive, String scope) {
        AccessTokenResponse response = (AccessTokenResponse)this.keycloakTokenRestClient.exchangeToken("Bearer " + oldToken, new TokenConfiguration(timeToLive, scope)).getBody();
        return this.validate(response.getToken());
    }

    @Override
    public BearerTokenTO validate(String token) {
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        formParams.add((Object)"token", (Object)token);
        formParams.add((Object)"client_id", (Object)this.clientId);
        formParams.add((Object)"client_secret", (Object)this.clientSecret);
        ResponseEntity<AccessToken> resp = this.keycloakTokenRestClient.validate((MultiValueMap<String, Object>)formParams);
        HttpStatus statusCode = resp.getStatusCode();
        if (HttpStatus.OK != statusCode) {
            log.error("Could not validate token");
        }
        if (((AccessToken)resp.getBody()).getOtherClaims().get("active").equals(false)) {
            throw new AccessDeniedException("Token Expired!");
        }
        return this.authMapper.toBearer((AccessToken)resp.getBody(), token);
    }

    public KeycloakTokenServiceImpl(KeycloakTokenRestClient keycloakTokenRestClient, KeycloakAuthMapper authMapper) {
        this.keycloakTokenRestClient = keycloakTokenRestClient;
        this.authMapper = authMapper;
    }
}

