/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.keycloak.client.impl;

import de.adorsys.ledgers.keycloak.client.api.KeycloakDataService;
import de.adorsys.ledgers.keycloak.client.config.KeycloakClientConfig;
import de.adorsys.ledgers.keycloak.client.mapper.KeycloakDataMapper;
import de.adorsys.ledgers.keycloak.client.model.KeycloakClient;
import de.adorsys.ledgers.keycloak.client.model.KeycloakRealm;
import de.adorsys.ledgers.keycloak.client.model.KeycloakUser;
import de.adorsys.ledgers.keycloak.client.model.RequiredAction;
import de.adorsys.ledgers.keycloak.client.rest.KeycloakTokenRestClient;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.CollectionUtils;
import org.keycloak.admin.client.CreatedResponseUtil;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientScopesResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.RealmsResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class KeycloakDataServiceImpl
implements KeycloakDataService {
    private static final Logger log = LoggerFactory.getLogger(KeycloakDataServiceImpl.class);
    private static final String USER_NOT_FOUND_IN_KEYCLOAK = "User[login: {}] was not found in keycloak.";
    private final Keycloak keycloak;
    private final KeycloakDataMapper mapper;
    private final KeycloakClientConfig configuration;
    private final KeycloakTokenRestClient keycloakTokenRestClient;
    @Value(value="${local.server.port:8088}")
    private int port;
    @Value(value="${ledgers.token.lifetime.seconds.login:600}")
    private int loginTokenTTL;
    @Value(value="${ledgers.token.lifetime.seconds.full:600}")
    private int fullTokenTTL;

    @Override
    public void createDefaultSchema() {
        KeycloakRealm realm = new KeycloakRealm(this.configuration.getClientRealm(), this.loginTokenTTL, this.fullTokenTTL, this.configuration.getSmtpServer());
        this.createRealm(realm);
        this.createRealmScopes(realm);
        this.createRealmRoles(realm);
        this.createClient(realm.getRealm());
    }

    private void createRealm(KeycloakRealm realm) {
        RealmsResource realmsResource = this.keycloak.realms();
        if (realm.notPresentRealm(realmsResource.findAll())) {
            realmsResource.create(this.mapper.createRealmRepresentation(realm));
            log.info("Realm [{}] was created", (Object)realm.getRealm());
        }
    }

    private void createRealmScopes(KeycloakRealm realm) {
        ClientScopesResource clientScopesResource = this.keycloak.realm(realm.getRealm()).clientScopes();
        realm.getScopesToAdd(clientScopesResource.findAll()).forEach(s -> {
            clientScopesResource.create(this.mapper.createClientScopeRepresentation((String)s));
            log.info("Client scope [{}] was added to realm [{}]", s, (Object)realm.getRealm());
        });
    }

    private void createRealmRoles(KeycloakRealm realm) {
        RolesResource rolesResource = this.keycloak.realms().realm(realm.getRealm()).roles();
        realm.getRolesToAdd(rolesResource.list()).forEach(r -> {
            rolesResource.create(this.mapper.createRoleRepresentation((String)r));
            log.info("Realm role [{}] was created in realm [{}]", r, (Object)realm.getRealm());
        });
    }

    private void createClient(String realm) {
        ClientsResource clientsResource = this.keycloak.realm(realm).clients();
        KeycloakClient client = new KeycloakClient(this.configuration, this.getRedirectUrls());
        if (client.notPresent(clientsResource.findAll())) {
            Response response = clientsResource.create(this.mapper.createClientRepresentation(client));
            log.info("Client [{}] was created in realm [{}]", (Object)client.getClientId(), (Object)realm);
            this.addClientScopes(realm, client, clientsResource, response);
        }
    }

    private void addClientScopes(String realm, KeycloakClient client, ClientsResource clientsResource, Response response) {
        String createdId = CreatedResponseUtil.getCreatedId((Response)response);
        ClientResource clientResource = clientsResource.get(createdId);
        client.getScopes().forEach(s -> {
            String clientScopeId = this.getClientScopeId(realm, (String)s);
            if (clientScopeId != null) {
                clientResource.addOptionalClientScope(clientScopeId);
                log.info("Client scope [{}] were assigned to client [{}] in realm [{}]", new Object[]{s, client.getClientId(), realm});
            }
        });
    }

    @Override
    public boolean clientExists() {
        try {
            List byClientId = this.keycloak.realm(this.configuration.getClientRealm()).clients().findByClientId(this.configuration.getExternalClientId());
            return CollectionUtils.isNotEmpty((Collection)byClientId);
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    @Override
    public Optional<KeycloakUser> getUser(String realm, String login) {
        List search = this.keycloak.realm(realm).users().search(login);
        if (CollectionUtils.isNotEmpty((Collection)search)) {
            return Optional.of(this.mapper.toKeycloakUser((UserRepresentation)search.get(0)));
        }
        return Optional.empty();
    }

    @Override
    public void createUser(KeycloakUser user) {
        UsersResource usersResource = this.keycloak.realm(this.configuration.getClientRealm()).users();
        try (Response response = usersResource.create(this.mapper.createUserRepresentation(user));){
            if (HttpStatus.CREATED.value() == response.getStatus()) {
                String userId = CreatedResponseUtil.getCreatedId((Response)response);
                log.info("User[{}] is created with id: {}", (Object)user.getLogin(), (Object)userId);
                this.assignUserRoles(this.configuration.getClientRealm(), userId, user.getRealmRoles());
            }
        }
    }

    @Override
    public void updateUser(KeycloakUser user) {
        UsersResource usersResource = this.keycloak.realm(this.configuration.getClientRealm()).users();
        List search = usersResource.search(user.getLogin());
        if (CollectionUtils.isNotEmpty((Collection)search)) {
            String userId = ((UserRepresentation)search.get(0)).getId();
            UserResource userResource = usersResource.get(userId);
            userResource.update(this.mapper.toUpdateUserPresentation(userResource.toRepresentation(), user));
            log.debug("User[{}] was updated in keycloak.", (Object)user.getLogin());
            this.assignUserRoles(this.configuration.getClientRealm(), userId, user.getRealmRoles());
            return;
        }
        log.info(USER_NOT_FOUND_IN_KEYCLOAK, (Object)user.getLogin());
    }

    @Override
    public void deleteUser(String login) {
        UsersResource usersResource = this.keycloak.realm(this.configuration.getClientRealm()).users();
        List search = usersResource.search(login);
        if (CollectionUtils.isNotEmpty((Collection)search)) {
            String userId = ((UserRepresentation)search.get(0)).getId();
            usersResource.delete(userId);
            log.info("User[{}] was deleted from keycloak.", (Object)login);
            return;
        }
        log.info(USER_NOT_FOUND_IN_KEYCLOAK, (Object)login);
    }

    @Override
    public boolean userExists(String login) {
        List search = this.keycloak.realm(this.configuration.getClientRealm()).users().search(login);
        return CollectionUtils.isNotEmpty((Collection)search);
    }

    @Override
    public void resetPassword(String login, String password) {
        CredentialRepresentation passwordCred = new CredentialRepresentation();
        passwordCred.setTemporary(Boolean.valueOf(false));
        passwordCred.setType("password");
        passwordCred.setValue(password);
        UsersResource usersResource = this.keycloak.realm(this.configuration.getClientRealm()).users();
        List search = usersResource.search(login);
        if (CollectionUtils.isNotEmpty((Collection)search)) {
            String userId = ((UserRepresentation)search.get(0)).getId();
            UserResource userResource = usersResource.get(userId);
            userResource.resetPassword(passwordCred);
            log.info("User[{}] was password reset.", (Object)login);
        }
        log.info(USER_NOT_FOUND_IN_KEYCLOAK, (Object)login);
    }

    @Override
    public void resetPasswordViaEmail(String login) {
        Optional<KeycloakUser> user = this.getUser(this.configuration.getClientRealm(), login);
        if (user.isPresent()) {
            String accessToken = this.keycloak.tokenManager().getAccessToken().getToken();
            this.keycloakTokenRestClient.executeActionsEmail("Bearer " + accessToken, user.get().getId(), Collections.singletonList(RequiredAction.UPDATE_PASSWORD.name()));
            log.info("User[{}] email for updating password was sent", (Object)login);
        }
        log.info(USER_NOT_FOUND_IN_KEYCLOAK, (Object)login);
    }

    @Override
    public void assignRealmRoleToUser(String login, List<String> realmRoles) {
        UsersResource usersResource = this.keycloak.realm(this.configuration.getClientRealm()).users();
        List search = usersResource.search(login);
        if (CollectionUtils.isNotEmpty((Collection)search)) {
            String userId = ((UserRepresentation)search.get(0)).getId();
            this.assignUserRoles(this.configuration.getClientRealm(), userId, realmRoles);
            log.info("Realm roles {} were assigned to User[realm: {}, login: {}] ", new Object[]{realmRoles, this.configuration.getClientRealm(), login});
            return;
        }
        log.info(USER_NOT_FOUND_IN_KEYCLOAK, (Object)login);
    }

    @Override
    public void removeRealmRoleFromUser(String login, List<String> realmRoles) {
        UsersResource usersResource = this.keycloak.realm(this.configuration.getClientRealm()).users();
        List search = usersResource.search(login);
        if (CollectionUtils.isNotEmpty((Collection)search)) {
            String userId = ((UserRepresentation)search.get(0)).getId();
            UserResource userResource = usersResource.get(userId);
            realmRoles.forEach(r -> userResource.roles().realmLevel().remove(Collections.singletonList(this.getRealmRole(this.configuration.getClientRealm(), (String)r))));
            log.info("Realm roles {} were assigned to User[realm: {}, login: {}] ", new Object[]{realmRoles, this.configuration.getClientRealm(), login});
            return;
        }
        log.info(USER_NOT_FOUND_IN_KEYCLOAK, (Object)login);
    }

    private RoleRepresentation getRealmRole(String realm, String realmRole) {
        return this.keycloak.realm(realm).roles().get(realmRole).toRepresentation();
    }

    private String getClientScopeId(String realm, String clientScope) {
        List all = this.keycloak.realm(realm).clientScopes().findAll();
        for (ClientScopeRepresentation clientScopeRepresentation : all) {
            if (!clientScopeRepresentation.getName().equals(clientScope)) continue;
            return clientScopeRepresentation.getId();
        }
        return null;
    }

    private void assignUserRoles(String realm, String userId, List<String> realmRoles) {
        UserResource userResource = this.keycloak.realm(realm).users().get(userId);
        realmRoles.forEach(r -> userResource.roles().realmLevel().add(Collections.singletonList(this.getRealmRole(realm, (String)r))));
    }

    private List<String> getRedirectUrls() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String host = InetAddress.getLocalHost().getHostAddress();
            list.add(host + ":" + this.port);
        }
        catch (UnknownHostException e) {
            log.error("Could not retrieve host! Fallback to http://localhost:8088 setup!");
        }
        list.add("http://localhost:8088");
        list.add("*");
        return list;
    }

    public KeycloakDataServiceImpl(Keycloak keycloak, KeycloakDataMapper mapper, KeycloakClientConfig configuration, KeycloakTokenRestClient keycloakTokenRestClient) {
        this.keycloak = keycloak;
        this.mapper = mapper;
        this.configuration = configuration;
        this.keycloakTokenRestClient = keycloakTokenRestClient;
    }
}

