/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.keycloak.client.config;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class KeycloakClientConfig {
    public static final String DEFAULT_ADMIN_CLIENT = "admin-cli";
    private String masterRealm = "master";
    @Value(value="${keycloak.auth-server-url:}")
    private String authServerUrl;
    @Value(value="${keycloak-sync.admin.username:}")
    private String userName;
    @Value(value="${keycloak-sync.admin.password:}")
    private String password;
    @Value(value="${keycloak.resource:admin-cli}")
    private String adminClient;
    @Value(value="${keycloak.resource}")
    private String externalClientId;
    @Value(value="${keycloak.credentials.secret:}")
    private String clientSecret;
    @Value(value="${keycloak.realm}")
    private String clientRealm;
    @Value(value="${keycloak.public-client}")
    private boolean publicClient;
    @Value(value="${spring.mail.host:}")
    private String emailHost;
    @Value(value="${spring.mail.port:}")
    private String emailPort;
    @Value(value="${spring.mail.properties.mail.ssl:false}")
    private String emailSsl;
    @Value(value="${spring.mail.properties.mail.auth:false}")
    private String emailAuth;
    @Value(value="${spring.mail.username:}")
    private String emailUser;
    @Value(value="${spring.mail.password:}")
    private String emailPassword;
    @Value(value="${spring.mail.properties.mail.from:}")
    private String emailFrom;
    @Value(value="${spring.mail.properties.mail.fromDisplayName:}")
    private String emailFromDisplayName;
    private Map<String, String> smtpServer = new HashMap<String, String>();

    @PostConstruct
    public void doInit() {
        this.smtpServer.put("host", this.emailHost);
        this.smtpServer.put("port", this.emailPort);
        this.smtpServer.put("auth", this.emailAuth);
        this.smtpServer.put("ssl", this.emailSsl);
        this.smtpServer.put("from", this.emailFrom);
        this.smtpServer.put("fromDisplayName", this.emailFromDisplayName);
        this.smtpServer.put("user", this.emailUser);
        this.smtpServer.put("password", this.emailPassword);
    }

    public String getMasterRealm() {
        return this.masterRealm;
    }

    public String getAuthServerUrl() {
        return this.authServerUrl;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getAdminClient() {
        return this.adminClient;
    }

    public String getExternalClientId() {
        return this.externalClientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getClientRealm() {
        return this.clientRealm;
    }

    public boolean isPublicClient() {
        return this.publicClient;
    }

    public String getEmailHost() {
        return this.emailHost;
    }

    public String getEmailPort() {
        return this.emailPort;
    }

    public String getEmailSsl() {
        return this.emailSsl;
    }

    public String getEmailAuth() {
        return this.emailAuth;
    }

    public String getEmailUser() {
        return this.emailUser;
    }

    public String getEmailPassword() {
        return this.emailPassword;
    }

    public String getEmailFrom() {
        return this.emailFrom;
    }

    public String getEmailFromDisplayName() {
        return this.emailFromDisplayName;
    }

    public void setMasterRealm(String masterRealm) {
        this.masterRealm = masterRealm;
    }

    public void setAuthServerUrl(String authServerUrl) {
        this.authServerUrl = authServerUrl;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setAdminClient(String adminClient) {
        this.adminClient = adminClient;
    }

    public void setExternalClientId(String externalClientId) {
        this.externalClientId = externalClientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setClientRealm(String clientRealm) {
        this.clientRealm = clientRealm;
    }

    public void setPublicClient(boolean publicClient) {
        this.publicClient = publicClient;
    }

    public void setEmailHost(String emailHost) {
        this.emailHost = emailHost;
    }

    public void setEmailPort(String emailPort) {
        this.emailPort = emailPort;
    }

    public void setEmailSsl(String emailSsl) {
        this.emailSsl = emailSsl;
    }

    public void setEmailAuth(String emailAuth) {
        this.emailAuth = emailAuth;
    }

    public void setEmailUser(String emailUser) {
        this.emailUser = emailUser;
    }

    public void setEmailPassword(String emailPassword) {
        this.emailPassword = emailPassword;
    }

    public void setEmailFrom(String emailFrom) {
        this.emailFrom = emailFrom;
    }

    public void setEmailFromDisplayName(String emailFromDisplayName) {
        this.emailFromDisplayName = emailFromDisplayName;
    }

    public void setSmtpServer(Map<String, String> smtpServer) {
        this.smtpServer = smtpServer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeycloakClientConfig)) {
            return false;
        }
        KeycloakClientConfig other = (KeycloakClientConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$masterRealm = this.getMasterRealm();
        String other$masterRealm = other.getMasterRealm();
        if (this$masterRealm == null ? other$masterRealm != null : !this$masterRealm.equals(other$masterRealm)) {
            return false;
        }
        String this$authServerUrl = this.getAuthServerUrl();
        String other$authServerUrl = other.getAuthServerUrl();
        if (this$authServerUrl == null ? other$authServerUrl != null : !this$authServerUrl.equals(other$authServerUrl)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$adminClient = this.getAdminClient();
        String other$adminClient = other.getAdminClient();
        if (this$adminClient == null ? other$adminClient != null : !this$adminClient.equals(other$adminClient)) {
            return false;
        }
        String this$externalClientId = this.getExternalClientId();
        String other$externalClientId = other.getExternalClientId();
        if (this$externalClientId == null ? other$externalClientId != null : !this$externalClientId.equals(other$externalClientId)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        String this$clientRealm = this.getClientRealm();
        String other$clientRealm = other.getClientRealm();
        if (this$clientRealm == null ? other$clientRealm != null : !this$clientRealm.equals(other$clientRealm)) {
            return false;
        }
        if (this.isPublicClient() != other.isPublicClient()) {
            return false;
        }
        String this$emailHost = this.getEmailHost();
        String other$emailHost = other.getEmailHost();
        if (this$emailHost == null ? other$emailHost != null : !this$emailHost.equals(other$emailHost)) {
            return false;
        }
        String this$emailPort = this.getEmailPort();
        String other$emailPort = other.getEmailPort();
        if (this$emailPort == null ? other$emailPort != null : !this$emailPort.equals(other$emailPort)) {
            return false;
        }
        String this$emailSsl = this.getEmailSsl();
        String other$emailSsl = other.getEmailSsl();
        if (this$emailSsl == null ? other$emailSsl != null : !this$emailSsl.equals(other$emailSsl)) {
            return false;
        }
        String this$emailAuth = this.getEmailAuth();
        String other$emailAuth = other.getEmailAuth();
        if (this$emailAuth == null ? other$emailAuth != null : !this$emailAuth.equals(other$emailAuth)) {
            return false;
        }
        String this$emailUser = this.getEmailUser();
        String other$emailUser = other.getEmailUser();
        if (this$emailUser == null ? other$emailUser != null : !this$emailUser.equals(other$emailUser)) {
            return false;
        }
        String this$emailPassword = this.getEmailPassword();
        String other$emailPassword = other.getEmailPassword();
        if (this$emailPassword == null ? other$emailPassword != null : !this$emailPassword.equals(other$emailPassword)) {
            return false;
        }
        String this$emailFrom = this.getEmailFrom();
        String other$emailFrom = other.getEmailFrom();
        if (this$emailFrom == null ? other$emailFrom != null : !this$emailFrom.equals(other$emailFrom)) {
            return false;
        }
        String this$emailFromDisplayName = this.getEmailFromDisplayName();
        String other$emailFromDisplayName = other.getEmailFromDisplayName();
        if (this$emailFromDisplayName == null ? other$emailFromDisplayName != null : !this$emailFromDisplayName.equals(other$emailFromDisplayName)) {
            return false;
        }
        Map<String, String> this$smtpServer = this.getSmtpServer();
        Map<String, String> other$smtpServer = other.getSmtpServer();
        return !(this$smtpServer == null ? other$smtpServer != null : !((Object)this$smtpServer).equals(other$smtpServer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KeycloakClientConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $masterRealm = this.getMasterRealm();
        result = result * 59 + ($masterRealm == null ? 43 : $masterRealm.hashCode());
        String $authServerUrl = this.getAuthServerUrl();
        result = result * 59 + ($authServerUrl == null ? 43 : $authServerUrl.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $adminClient = this.getAdminClient();
        result = result * 59 + ($adminClient == null ? 43 : $adminClient.hashCode());
        String $externalClientId = this.getExternalClientId();
        result = result * 59 + ($externalClientId == null ? 43 : $externalClientId.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        String $clientRealm = this.getClientRealm();
        result = result * 59 + ($clientRealm == null ? 43 : $clientRealm.hashCode());
        result = result * 59 + (this.isPublicClient() ? 79 : 97);
        String $emailHost = this.getEmailHost();
        result = result * 59 + ($emailHost == null ? 43 : $emailHost.hashCode());
        String $emailPort = this.getEmailPort();
        result = result * 59 + ($emailPort == null ? 43 : $emailPort.hashCode());
        String $emailSsl = this.getEmailSsl();
        result = result * 59 + ($emailSsl == null ? 43 : $emailSsl.hashCode());
        String $emailAuth = this.getEmailAuth();
        result = result * 59 + ($emailAuth == null ? 43 : $emailAuth.hashCode());
        String $emailUser = this.getEmailUser();
        result = result * 59 + ($emailUser == null ? 43 : $emailUser.hashCode());
        String $emailPassword = this.getEmailPassword();
        result = result * 59 + ($emailPassword == null ? 43 : $emailPassword.hashCode());
        String $emailFrom = this.getEmailFrom();
        result = result * 59 + ($emailFrom == null ? 43 : $emailFrom.hashCode());
        String $emailFromDisplayName = this.getEmailFromDisplayName();
        result = result * 59 + ($emailFromDisplayName == null ? 43 : $emailFromDisplayName.hashCode());
        Map<String, String> $smtpServer = this.getSmtpServer();
        result = result * 59 + ($smtpServer == null ? 43 : ((Object)$smtpServer).hashCode());
        return result;
    }

    public String toString() {
        return "KeycloakClientConfig(masterRealm=" + this.getMasterRealm() + ", authServerUrl=" + this.getAuthServerUrl() + ", userName=" + this.getUserName() + ", password=" + this.getPassword() + ", adminClient=" + this.getAdminClient() + ", externalClientId=" + this.getExternalClientId() + ", clientSecret=" + this.getClientSecret() + ", clientRealm=" + this.getClientRealm() + ", publicClient=" + this.isPublicClient() + ", emailHost=" + this.getEmailHost() + ", emailPort=" + this.getEmailPort() + ", emailSsl=" + this.getEmailSsl() + ", emailAuth=" + this.getEmailAuth() + ", emailUser=" + this.getEmailUser() + ", emailPassword=" + this.getEmailPassword() + ", emailFrom=" + this.getEmailFrom() + ", emailFromDisplayName=" + this.getEmailFromDisplayName() + ", smtpServer=" + this.getSmtpServer() + ")";
    }

    public Map<String, String> getSmtpServer() {
        return this.smtpServer;
    }
}

