/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.gateway.config;

import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.info.BuildProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spring.web.plugins.Docket;

@Component
@DependsOn(value={"api"})
public class Xs2aSwaggerConfig {
    @Value(value="${xs2a.license.url:}")
    private String licenseUrl;
    private final BuildProperties buildProperties;
    private final ApplicationContext applicationContext;

    @PostConstruct
    public void init() {
        ((Docket)this.applicationContext.getBean("api", Docket.class)).apiInfo(this.apiInfo());
    }

    public ApiInfo apiInfo() {
        return new ApiInfoBuilder().title("XS2A Core rest API").contact(new Contact("Adorsys GmbH", "http://www.adorsys.de", "fpo@adorsys.de")).version(this.buildProperties.getVersion() + " " + this.buildProperties.get("build.number")).license("Apache License 2.0").licenseUrl(this.licenseUrl).build();
    }

    public Xs2aSwaggerConfig(BuildProperties buildProperties, ApplicationContext applicationContext) {
        this.buildProperties = buildProperties;
        this.applicationContext = applicationContext;
    }
}

