/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.gateway.config;

import de.adorsys.ledgers.gateway.config.ServiceInstanceIdEventListener;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HibernateListenerConfig {
    @PersistenceUnit
    private EntityManagerFactory entityManagerFactory;
    private final ServiceInstanceIdEventListener serviceInstanceIdEventListener;

    @PostConstruct
    public void registerListeners() {
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)this.entityManagerFactory.unwrap(SessionFactoryImplementor.class);
        EventListenerRegistry registry = (EventListenerRegistry)sessionFactory.getServiceRegistry().getService(EventListenerRegistry.class);
        registry.getEventListenerGroup(EventType.PRE_INSERT).appendListener((Object)this.serviceInstanceIdEventListener);
    }

    public HibernateListenerConfig(ServiceInstanceIdEventListener serviceInstanceIdEventListener) {
        this.serviceInstanceIdEventListener = serviceInstanceIdEventListener;
    }
}

