/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.gateway.config;

import de.adorsys.psd2.consent.domain.InstanceDependableEntity;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.event.spi.PreInsertEvent;
import org.hibernate.event.spi.PreInsertEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ServiceInstanceIdEventListener
implements PreInsertEventListener {
    private static final Logger log = LoggerFactory.getLogger(ServiceInstanceIdEventListener.class);
    private static final String SERVICE_INSTANCE_ID_PROPERTY = "instanceId";
    @Value(value="${xs2a.cms.service.instance-id:UNDEFINED}")
    private String serviceInstanceId;

    public boolean onPreInsert(PreInsertEvent event) {
        InstanceDependableEntity entity;
        Object object = event.getEntity();
        if (object instanceof InstanceDependableEntity && StringUtils.isEmpty((CharSequence)(entity = (InstanceDependableEntity)object).getInstanceId())) {
            Object[] propertyNames = event.getPersister().getEntityMetamodel().getPropertyNames();
            Object[] currentState = event.getState();
            int serviceInstanceIdPropertyIndex = ArrayUtils.indexOf((Object[])propertyNames, (Object)SERVICE_INSTANCE_ID_PROPERTY);
            this.doUpdateServiceInstanceIdProperty(entity, currentState, serviceInstanceIdPropertyIndex);
        }
        return false;
    }

    private void doUpdateServiceInstanceIdProperty(InstanceDependableEntity entity, Object[] currentState, int serviceInstanceIdPropertyIndex) {
        if (serviceInstanceIdPropertyIndex >= 0) {
            currentState[serviceInstanceIdPropertyIndex] = this.serviceInstanceId;
        } else {
            log.error("Field 'instanceId' not found on entity '" + entity.getClass().getName() + "'.");
        }
    }
}

