/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.data.upload.service;

import de.adorsys.ledgers.data.upload.model.AccountBalance;
import de.adorsys.ledgers.data.upload.model.DataPayload;
import de.adorsys.ledgers.data.upload.utils.IbanGenerator;
import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.general.AddressTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.domain.payment.BulkPaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentProductTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.SinglePaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Currency;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class TestsDataGenerationService {
    private static final String TEST_CREDITOR_IBAN = "DE68370400440000000000";
    private Random random = new Random();

    public DataPayload generateData(DataPayload data, String branch, boolean generatePayments) {
        Map detailsMap = this.getNotNullList(data.getAccounts()).stream().map(a -> this.generateDetails((AccountDetailsTO)a, branch)).collect(Collectors.toMap(this::getLastTwoSymbols, Function.identity()));
        data.setAccounts(new ArrayList<AccountDetailsTO>(detailsMap.values()));
        List<AccountBalance> balances = this.getNotNullList(data.getBalancesList()).stream().map(b -> this.generateBalances((AccountBalance)b, branch, detailsMap)).collect(Collectors.toList());
        data.setBalancesList(balances);
        List<UserTO> users = this.getNotNullList(data.getUsers()).stream().map(u -> this.generateUsers((UserTO)u, branch, detailsMap)).collect(Collectors.toList());
        data.setUsers(users);
        data.setGeneratePayments(generatePayments);
        data.setBranch(branch);
        return data;
    }

    private <T> List<T> getNotNullList(List<T> list) {
        return Optional.ofNullable(list).orElse(Collections.emptyList());
    }

    private String getLastTwoSymbols(AccountDetailsTO a) {
        return a.getIban().substring(a.getIban().length() - 2);
    }

    private AccountBalance generateBalances(AccountBalance balance, String branch, Map<String, AccountDetailsTO> detailsMap) {
        String iban = this.getGeneratedIbanOrNew(balance.getIban(), branch, detailsMap);
        balance.setIban(iban);
        return balance;
    }

    private AccountDetailsTO generateDetails(AccountDetailsTO details, String branch) {
        String iban = this.generateIban(branch, details.getIban());
        details.setIban(iban);
        return details;
    }

    private UserTO generateUsers(UserTO user, String branch, Map<String, AccountDetailsTO> detailsMap) {
        user.setId(this.addBranchPrefix(branch, user.getId()));
        user.setEmail(this.addBranchPrefix(branch, user.getEmail()));
        user.setLogin(this.addBranchPrefix(branch, user.getLogin()));
        user.getScaUserData().forEach(d -> d.setMethodValue(this.addBranchPrefix(branch, d.getMethodValue())));
        user.getAccountAccesses().forEach(a -> a.setIban(this.getGeneratedIbanOrNew(a.getIban(), branch, detailsMap)));
        return user;
    }

    private String addBranchPrefix(String branch, String concatObj) {
        return branch + "_" + concatObj;
    }

    private String generateIban(String branch, String iban) {
        return IbanGenerator.generateIban(branch, iban);
    }

    private String getGeneratedIbanOrNew(String iban, String branch, Map<String, AccountDetailsTO> detailsMap) {
        return detailsMap.containsKey(iban) ? detailsMap.get(iban).getIban() : this.generateIban(branch, iban);
    }

    public Map<PaymentTypeTO, Object> generatePayments(AccountBalance balance, String branch) {
        EnumMap<PaymentTypeTO, Object> map = new EnumMap<PaymentTypeTO, Object>(PaymentTypeTO.class);
        map.put(PaymentTypeTO.SINGLE, (Object)this.generateSinglePayment(balance, branch));
        map.put(PaymentTypeTO.BULK, (Object)this.generateBulkPayment(balance, branch));
        return map;
    }

    private BulkPaymentTO generateBulkPayment(AccountBalance balance, String branch) {
        return new BulkPaymentTO(null, Boolean.valueOf(false), this.generateReference(balance.getIban(), balance.getCurrency()), LocalDate.now(), TransactionStatusTO.RCVD, Arrays.asList(this.generateSinglePayment(balance, branch), this.generateSinglePayment(balance, branch)), PaymentProductTO.INSTANT_SEPA);
    }

    private SinglePaymentTO generateSinglePayment(AccountBalance balance, String branch) {
        String endToEndId = this.generateEndToEndId(branch);
        return new SinglePaymentTO(null, endToEndId, this.generateReference(balance.getIban(), balance.getCurrency()), this.generateAmount(balance), this.generateReference(TEST_CREDITOR_IBAN, balance.getCurrency()), "adorsys GmbH & CO KG", "adorsys GmbH & CO KG", this.getTestCreditorAddress(), null, TransactionStatusTO.RCVD, PaymentProductTO.INSTANT_SEPA, LocalDate.now(), null);
    }

    private AmountTO generateAmount(AccountBalance balance) {
        AmountTO amount = new AmountTO();
        amount.setCurrency(balance.getCurrency());
        int balanceAmount = balance.getAmount().intValue();
        int maxAmount = balanceAmount < 3 ? 3 : balanceAmount / 3;
        int rand = this.random.nextInt(maxAmount - 1) + 1;
        amount.setAmount(BigDecimal.valueOf(rand));
        return amount;
    }

    private AddressTO getTestCreditorAddress() {
        return new AddressTO("F\u00fcrther Str.", "246a", "N\u00fcrnberg", "90429", "Germany");
    }

    private AccountReferenceTO generateReference(String iban, Currency currency) {
        AccountReferenceTO reference = new AccountReferenceTO();
        reference.setIban(iban);
        reference.setCurrency(currency);
        return reference;
    }

    private String generateEndToEndId(String branchId) {
        return String.join((CharSequence)"_", branchId, String.valueOf(LocalDateTime.now().toEpochSecond(ZoneOffset.UTC)) + this.random.nextInt(9), String.valueOf(ThreadLocalRandom.current().nextLong(10000L, 99999L)));
    }
}

