/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.data.upload.service;

import de.adorsys.ledgers.data.upload.model.AccountBalance;
import de.adorsys.ledgers.data.upload.model.DataPayload;
import de.adorsys.ledgers.data.upload.service.ParseService;
import de.adorsys.ledgers.data.upload.service.RestExecutionService;
import de.adorsys.ledgers.data.upload.utils.IbanGenerator;
import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccessTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.api.exception.UserNotFoundMiddlewareException;
import de.adorsys.ledgers.um.api.exception.UserNotFoundException;
import de.adorsys.ledgers.um.api.service.UserService;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
public class TestsDataGenerationService {
    private final AccessTokenTO accessToken;
    private final UserService userService;
    private final ParseService parseService;
    private final RestExecutionService executionService;

    public TestsDataGenerationService(AccessTokenTO accessToken, UserService userService, ParseService parseService, RestExecutionService executionService) {
        this.accessToken = accessToken;
        this.userService = userService;
        this.parseService = parseService;
        this.executionService = executionService;
    }

    public byte[] generate(String token) throws UserNotFoundMiddlewareException, FileNotFoundException {
        try {
            String branch = this.userService.findByLogin(this.accessToken.getLogin()).getBranch();
            DataPayload dataPayload = this.parseService.getDefaultData().map(d -> this.generateData((DataPayload)d, branch)).orElseThrow(() -> new FileNotFoundException("Seems no data is present in file!"));
            this.executionService.updateLedgers(token, dataPayload);
            return this.parseService.getFile(dataPayload);
        }
        catch (UserNotFoundException e) {
            throw new UserNotFoundMiddlewareException((Throwable)e);
        }
    }

    private DataPayload generateData(DataPayload data, String branch) {
        Map<String, AccountDetailsTO> detailsMap = this.getNotNullList(data.getAccounts()).stream().map(a -> this.generateDetails((AccountDetailsTO)a, branch)).collect(Collectors.toMap(this::getLastTwoSymbols, a -> a));
        data.setAccounts(new ArrayList<AccountDetailsTO>(detailsMap.values()));
        List<AccountBalance> balances = this.getNotNullList(data.getBalancesList()).stream().map(b -> this.generateBalances((AccountBalance)b, branch, detailsMap)).collect(Collectors.toList());
        data.setBalancesList(balances);
        List<UserTO> users = this.getNotNullList(data.getUsers()).stream().map(u -> this.generateUsers((UserTO)u, branch, detailsMap)).collect(Collectors.toList());
        data.setUsers(users);
        return data;
    }

    private <T> List<T> getNotNullList(List<T> list) {
        return Optional.ofNullable(list).orElse(Collections.emptyList());
    }

    @NotNull
    private String getLastTwoSymbols(AccountDetailsTO a) {
        return a.getIban().substring(a.getIban().length() - 2);
    }

    private AccountBalance generateBalances(AccountBalance balance, String branch, Map<String, AccountDetailsTO> detailsMap) {
        String iban = this.getGeneratedIbanOrNew(balance.getIban(), branch, detailsMap);
        balance.setIban(iban);
        return balance;
    }

    private AccountDetailsTO generateDetails(AccountDetailsTO details, String branch) {
        String iban = this.generateIban(branch, details.getIban());
        details.setIban(iban);
        return details;
    }

    private UserTO generateUsers(UserTO user, String branch, Map<String, AccountDetailsTO> detailsMap) {
        user.setId(this.addBranchPrefix(branch, user.getId()));
        user.setEmail(this.addBranchPrefix(branch, user.getEmail()));
        user.setLogin(this.addBranchPrefix(branch, user.getLogin()));
        user.getScaUserData().forEach(d -> d.setMethodValue(this.addBranchPrefix(branch, d.getMethodValue())));
        user.getAccountAccesses().forEach(a -> a.setIban(this.getGeneratedIbanOrNew(a.getIban(), branch, detailsMap)));
        return user;
    }

    @NotNull
    private String addBranchPrefix(String branch, String concatObj) {
        return branch + "_" + concatObj;
    }

    private String generateIban(String branch, String iban) {
        return IbanGenerator.generateIban(branch, iban);
    }

    private String getGeneratedIbanOrNew(String iban, String branch, Map<String, AccountDetailsTO> detailsMap) {
        return detailsMap.containsKey(iban) ? detailsMap.get(iban).getIban() : this.generateIban(branch, iban);
    }
}

