/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.keyrotation.services;

import dagger.BindsInstance;
import dagger.Component;
import de.adorsys.keymanagement.api.KeyStoreManager;
import de.adorsys.keymanagement.api.config.keystore.KeyStoreConfig;
import de.adorsys.keymanagement.keyrotation.api.persistence.KeyStoreAccessDelegate;
import de.adorsys.keymanagement.keyrotation.api.persistence.KeyStorePersistence;
import de.adorsys.keymanagement.keyrotation.api.persistence.RotationLocker;
import de.adorsys.keymanagement.keyrotation.api.services.KeyView;
import de.adorsys.keymanagement.keyrotation.api.services.Rotation;
import de.adorsys.keymanagement.keyrotation.api.types.KeyRotationConfig;
import de.adorsys.keymanagement.keyrotation.modules.KeyStoreAccessModule;
import de.adorsys.keymanagement.keyrotation.modules.RotationModule;
import de.adorsys.keymanagement.keyrotation.modules.ViewModule;
import java.time.Clock;
import javax.annotation.Nullable;

@Component(modules={KeyStoreAccessModule.class, RotationModule.class, ViewModule.class})
public interface RotatedKeyStore {
    public Rotation forRotation();

    public KeyView keys();

    @Component.Builder
    public static interface Builder {
        @BindsInstance
        public Builder keyStoreConfig(@Nullable KeyStoreConfig var1);

        @BindsInstance
        public Builder keyStoreManager(@Nullable KeyStoreManager var1);

        @BindsInstance
        public Builder timeSource(@Nullable Clock var1);

        @BindsInstance
        public Builder accessDelegate(@Nullable KeyStoreAccessDelegate var1);

        @BindsInstance
        public Builder persistence(KeyStorePersistence var1);

        @BindsInstance
        public Builder distributedLock(RotationLocker var1);

        @BindsInstance
        public Builder rotationConfig(KeyRotationConfig var1);

        public RotatedKeyStore build();
    }
}

