/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.keyrotation.services;

import dagger.internal.DaggerGenerated;
import dagger.internal.Preconditions;
import de.adorsys.keymanagement.api.Juggler;
import de.adorsys.keymanagement.api.KeyStoreManager;
import de.adorsys.keymanagement.api.config.keystore.KeyStoreConfig;
import de.adorsys.keymanagement.keyrotation.api.persistence.KeyStoreAccess;
import de.adorsys.keymanagement.keyrotation.api.persistence.KeyStoreAccessDelegate;
import de.adorsys.keymanagement.keyrotation.api.persistence.KeyStorePersistence;
import de.adorsys.keymanagement.keyrotation.api.persistence.RotationLocker;
import de.adorsys.keymanagement.keyrotation.api.services.KeyView;
import de.adorsys.keymanagement.keyrotation.api.services.Rotation;
import de.adorsys.keymanagement.keyrotation.api.types.KeyRotationConfig;
import de.adorsys.keymanagement.keyrotation.impl.services.KeyGeneratorImpl;
import de.adorsys.keymanagement.keyrotation.impl.services.KeyStoreAccessImpl;
import de.adorsys.keymanagement.keyrotation.impl.services.KeyViewImpl;
import de.adorsys.keymanagement.keyrotation.impl.services.RotationImpl;
import de.adorsys.keymanagement.keyrotation.modules.KeyStoreAccessModule_AccessCaptorFactory;
import de.adorsys.keymanagement.keyrotation.modules.RotationModule_KeyStoreManagementFactory;
import de.adorsys.keymanagement.keyrotation.services.RotatedKeyStore;
import java.time.Clock;

@DaggerGenerated
public final class DaggerRotatedKeyStore {
    private DaggerRotatedKeyStore() {
    }

    public static RotatedKeyStore.Builder builder() {
        return new Builder();
    }

    private static final class Builder
    implements RotatedKeyStore.Builder {
        private KeyStoreConfig keyStoreConfig;
        private KeyStoreManager keyStoreManager;
        private Clock timeSource;
        private KeyStoreAccessDelegate accessDelegate;
        private KeyStorePersistence persistence;
        private RotationLocker distributedLock;
        private KeyRotationConfig rotationConfig;

        private Builder() {
        }

        @Override
        public Builder keyStoreConfig(KeyStoreConfig manager) {
            this.keyStoreConfig = manager;
            return this;
        }

        @Override
        public Builder keyStoreManager(KeyStoreManager manager) {
            this.keyStoreManager = manager;
            return this;
        }

        @Override
        public Builder timeSource(Clock timeSource) {
            this.timeSource = timeSource;
            return this;
        }

        @Override
        public Builder accessDelegate(KeyStoreAccessDelegate callCaptor) {
            this.accessDelegate = callCaptor;
            return this;
        }

        @Override
        public Builder persistence(KeyStorePersistence persistence) {
            this.persistence = (KeyStorePersistence)Preconditions.checkNotNull((Object)persistence);
            return this;
        }

        @Override
        public Builder distributedLock(RotationLocker locker) {
            this.distributedLock = (RotationLocker)Preconditions.checkNotNull((Object)locker);
            return this;
        }

        @Override
        public Builder rotationConfig(KeyRotationConfig config) {
            this.rotationConfig = (KeyRotationConfig)Preconditions.checkNotNull((Object)config);
            return this;
        }

        @Override
        public RotatedKeyStore build() {
            Preconditions.checkBuilderRequirement((Object)this.persistence, KeyStorePersistence.class);
            Preconditions.checkBuilderRequirement((Object)this.distributedLock, RotationLocker.class);
            Preconditions.checkBuilderRequirement((Object)this.rotationConfig, KeyRotationConfig.class);
            return new RotatedKeyStoreImpl(this.keyStoreConfig, this.keyStoreManager, this.timeSource, this.accessDelegate, this.persistence, this.distributedLock, this.rotationConfig);
        }
    }

    private static final class RotatedKeyStoreImpl
    implements RotatedKeyStore {
        private final KeyStoreManager keyStoreManager;
        private final KeyStoreConfig keyStoreConfig;
        private final KeyRotationConfig rotationConfig;
        private final Clock timeSource;
        private final KeyStoreAccessDelegate accessDelegate;
        private final KeyStorePersistence persistence;
        private final RotationLocker distributedLock;
        private final RotatedKeyStoreImpl rotatedKeyStoreImpl = this;

        private RotatedKeyStoreImpl(KeyStoreConfig keyStoreConfigParam, KeyStoreManager keyStoreManagerParam, Clock timeSourceParam, KeyStoreAccessDelegate accessDelegateParam, KeyStorePersistence persistenceParam, RotationLocker distributedLockParam, KeyRotationConfig rotationConfigParam) {
            this.keyStoreManager = keyStoreManagerParam;
            this.keyStoreConfig = keyStoreConfigParam;
            this.rotationConfig = rotationConfigParam;
            this.timeSource = timeSourceParam;
            this.accessDelegate = accessDelegateParam;
            this.persistence = persistenceParam;
            this.distributedLock = distributedLockParam;
        }

        private Juggler juggler() {
            return RotationModule_KeyStoreManagementFactory.keyStoreManagement(this.keyStoreManager, this.keyStoreConfig);
        }

        private KeyGeneratorImpl keyGeneratorImpl() {
            return new KeyGeneratorImpl(this.juggler(), this.rotationConfig);
        }

        private KeyStoreAccessImpl keyStoreAccessImpl() {
            return new KeyStoreAccessImpl(this.persistence, this.juggler(), this.rotationConfig);
        }

        private KeyStoreAccess keyStoreAccess() {
            return KeyStoreAccessModule_AccessCaptorFactory.accessCaptor(this.accessDelegate, this.keyStoreAccessImpl());
        }

        private RotationImpl rotationImpl() {
            return new RotationImpl(this.keyGeneratorImpl(), this.rotationConfig, this.juggler(), this.timeSource, this.keyStoreAccess(), this.distributedLock);
        }

        private KeyViewImpl keyViewImpl() {
            return new KeyViewImpl(this.rotationConfig, this.keyStoreAccess(), this.juggler());
        }

        @Override
        public Rotation forRotation() {
            return this.rotationImpl();
        }

        @Override
        public KeyView keys() {
            return this.keyViewImpl();
        }
    }
}

