/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.keyrotation.impl.services;

import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.QueryFactory;
import de.adorsys.keymanagement.api.Juggler;
import de.adorsys.keymanagement.api.types.ResultCollection;
import de.adorsys.keymanagement.api.types.entity.AliasWithMeta;
import de.adorsys.keymanagement.api.types.entity.KeyEntry;
import de.adorsys.keymanagement.api.types.entity.metadata.KeyMetadata;
import de.adorsys.keymanagement.api.types.source.KeySet;
import de.adorsys.keymanagement.api.types.template.ProvidedKeyTemplate;
import de.adorsys.keymanagement.api.view.EntryView;
import de.adorsys.keymanagement.keyrotation.api.persistence.KeyStoreAccess;
import de.adorsys.keymanagement.keyrotation.api.persistence.RotationLocker;
import de.adorsys.keymanagement.keyrotation.api.services.KeyGenerator;
import de.adorsys.keymanagement.keyrotation.api.services.Rotation;
import de.adorsys.keymanagement.keyrotation.api.types.KeyRotationConfig;
import de.adorsys.keymanagement.keyrotation.api.types.KeyState;
import de.adorsys.keymanagement.keyrotation.api.types.KeyStatus;
import de.adorsys.keymanagement.keyrotation.api.types.KeyType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.security.KeyStore;
import java.time.Clock;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RotationImpl
implements Rotation {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RotationImpl.class);
    private final KeyGenerator generator;
    private final KeyRotationConfig config;
    private final Juggler juggler;
    private final Clock timeSource;
    private final KeyStoreAccess access;
    private final RotationLocker locker;

    @Inject
    public RotationImpl(KeyGenerator generator, KeyRotationConfig config, Juggler juggler, @Nullable Clock timeSource, KeyStoreAccess access, RotationLocker locker) {
        this.generator = generator;
        this.config = config;
        this.juggler = juggler;
        this.timeSource = null == timeSource ? Clock.systemUTC() : timeSource;
        this.access = access;
        this.locker = locker;
    }

    @Override
    public void rotate() {
        this.locker.executeWithLock(this::doRotate);
    }

    private void doRotate() {
        Instant now = this.timeSource.instant();
        KeyStore ks = this.readOrCreateKeystoreIfMissing();
        EntryView keys = this.juggler.readKeys().fromKeyStore(ks, id -> this.config.keyPassword().get()).entries();
        this.moveValidToLegacy(now, (EntryView<Query<KeyEntry>>)keys);
        this.moveLegacyToExpired(now, (EntryView<Query<KeyEntry>>)keys);
        this.dropExpired((EntryView<Query<KeyEntry>>)keys);
        this.ensureThereAreEnoughValidKeys(now, (EntryView<Query<KeyEntry>>)keys);
        this.access.write(ks);
    }

    private void moveValidToLegacy(Instant now, EntryView<Query<KeyEntry>> keys) {
        ResultCollection legacy = keys.retrieve((Object)QueryFactory.and((Query)QueryFactory.in(KeyState.TYPE, this.config.getEnabledFor()), KeyState.BECAME_LEGACY.apply(now))).toCollection();
        keys.update((Collection)legacy.stream().map(it -> this.toStatus((KeyEntry)it, KeyStatus.LEGACY)).collect(Collectors.toList()));
        log.info("Moved valid to legacy ids: {}", this.nameAndType((ResultCollection<KeyEntry>)legacy));
    }

    private void moveLegacyToExpired(Instant now, EntryView<Query<KeyEntry>> keys) {
        ResultCollection expired = keys.retrieve((Object)QueryFactory.and((Query)QueryFactory.in(KeyState.TYPE, this.config.getEnabledFor()), KeyState.BECAME_EXPIRED.apply(now))).toCollection();
        keys.update((Collection)expired.stream().map(it -> this.toStatus((KeyEntry)it, KeyStatus.EXPIRED)).collect(Collectors.toList()));
        log.info("Moved legacy to expired ids: {}", this.nameAndType((ResultCollection<KeyEntry>)expired));
    }

    private void dropExpired(EntryView<Query<KeyEntry>> keys) {
        ResultCollection expired = keys.retrieve((Object)QueryFactory.and((Query)QueryFactory.in(KeyState.TYPE, this.config.getEnabledFor()), (Query)QueryFactory.equal(KeyState.STATUS, (Object)((Object)KeyStatus.EXPIRED)))).toCollection();
        keys.remove((Collection)expired);
        log.info("Removed expired ids: {}", this.nameAndType((ResultCollection<KeyEntry>)expired));
    }

    private void ensureThereAreEnoughValidKeys(Instant now, EntryView<Query<KeyEntry>> keys) {
        for (KeyType forType : this.config.getEnabledFor()) {
            int countValidForType = keys.retrieve((Object)QueryFactory.and((Query)QueryFactory.equal(KeyState.TYPE, (Object)((Object)forType)), (Query)QueryFactory.equal(KeyState.STATUS, (Object)((Object)KeyStatus.VALID)))).toCollection().size();
            int missing = this.config.getCountValidByType().get((Object)forType) - countValidForType;
            this.generateKeysIfNeeded(now, keys, forType, missing);
        }
    }

    private void generateKeysIfNeeded(Instant now, EntryView<Query<KeyEntry>> keys, KeyType forType, int missing) {
        if (missing <= 0) {
            return;
        }
        List<ProvidedKeyTemplate> generatedKeys = this.generateKeysForType(now, forType, missing);
        keys.add(generatedKeys);
        log.info("Generated keys: {}", this.nameAndType(generatedKeys));
    }

    private List<ProvidedKeyTemplate> generateKeysForType(Instant now, KeyType forType, int count) {
        return IntStream.range(0, count).boxed().map(it -> this.generator.generateValidKey(now, forType)).collect(Collectors.toList());
    }

    private KeyStore readOrCreateKeystoreIfMissing() {
        KeyStore keyStore = this.access.read();
        if (null == keyStore) {
            log.info("KeyStore does not exists, generating empty");
            return this.juggler.toKeystore().generate(KeySet.builder().build());
        }
        return keyStore;
    }

    private AliasWithMeta<KeyState> toStatus(KeyEntry key, KeyStatus status) {
        AliasWithMeta current = key.aliasWithMeta(KeyState.class);
        return current.toBuilder().metadata((KeyMetadata)((KeyState)current.getMetadata()).toBuilder().status(status).build()).build();
    }

    private List<String> nameAndType(ResultCollection<KeyEntry> collection) {
        return collection.stream().map(it -> ((KeyState)it.getMeta(KeyState.class)).getType().name() + ":" + it.getAlias()).collect(Collectors.toList());
    }

    private List<String> nameAndType(List<ProvidedKeyTemplate> collection) {
        return collection.stream().map(it -> ((KeyState)it.getMetadata()).getType().name() + ":" + it.generateName()).collect(Collectors.toList());
    }
}

