/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.keyrotation.impl.services;

import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.QueryFactory;
import de.adorsys.keymanagement.api.Juggler;
import de.adorsys.keymanagement.api.types.ResultCollection;
import de.adorsys.keymanagement.api.types.entity.KeyEntry;
import de.adorsys.keymanagement.api.view.EntryView;
import de.adorsys.keymanagement.keyrotation.api.persistence.KeyStoreAccess;
import de.adorsys.keymanagement.keyrotation.api.services.KeyViewWithValidity;
import de.adorsys.keymanagement.keyrotation.api.types.KeyRotationConfig;
import de.adorsys.keymanagement.keyrotation.api.types.KeyState;
import de.adorsys.keymanagement.keyrotation.api.types.KeyStatus;
import de.adorsys.keymanagement.keyrotation.api.types.KeyType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class KeyViewWithValidityImpl
implements KeyViewWithValidity {
    private final KeyRotationConfig config;
    private final Juggler juggler;
    private final KeyStoreAccess access;
    private final Map<KeyType, Collection<KeyStatus>> validityMap;

    @Override
    public ResultCollection<KeyEntry> all() {
        EntryView<Query<KeyEntry>> entries = this.getEntriesView();
        return this.applyValidityFilter(this.validityMap, entries);
    }

    @Override
    public ResultCollection<KeyEntry> encryptionKeys() {
        EntryView<Query<KeyEntry>> entries = this.getEntriesView();
        return this.applyValidityFilter(this.filteredValidityMap(KeyType.ENCRYPTING), entries);
    }

    @Override
    public ResultCollection<KeyEntry> signingKeys() {
        EntryView<Query<KeyEntry>> entries = this.getEntriesView();
        return this.applyValidityFilter(this.filteredValidityMap(KeyType.SIGNING), entries);
    }

    @Override
    public ResultCollection<KeyEntry> secretKeys() {
        EntryView<Query<KeyEntry>> entries = this.getEntriesView();
        return this.applyValidityFilter(this.filteredValidityMap(KeyType.SECRET), entries);
    }

    private Map<KeyType, Collection<KeyStatus>> filteredValidityMap(KeyType forType) {
        return this.validityMap.entrySet().stream().filter(it -> it.getKey() == forType).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private ResultCollection<KeyEntry> applyValidityFilter(Map<KeyType, Collection<KeyStatus>> validityMap, EntryView<Query<KeyEntry>> entries) {
        HashSet result = new HashSet();
        for (Map.Entry<KeyType, Collection<KeyStatus>> entry : validityMap.entrySet()) {
            result.addAll(entries.retrieve((Object)QueryFactory.and((Query)QueryFactory.equal(KeyState.TYPE, (Object)((Object)entry.getKey())), (Query)QueryFactory.in(KeyState.STATUS, entry.getValue()))).toCollection());
        }
        return new ResultCollection(result);
    }

    private EntryView<Query<KeyEntry>> getEntriesView() {
        return this.juggler.readKeys().fromKeyStore(this.access.read(), id -> this.config.keyPassword().get()).entries();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public KeyViewWithValidityImpl(KeyRotationConfig config, Juggler juggler, KeyStoreAccess access, Map<KeyType, Collection<KeyStatus>> validityMap) {
        this.config = config;
        this.juggler = juggler;
        this.access = access;
        this.validityMap = validityMap;
    }
}

