/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.keyrotation.impl.services;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.query.QueryFactory;
import de.adorsys.keymanagement.api.Juggler;
import de.adorsys.keymanagement.api.types.entity.KeyEntry;
import de.adorsys.keymanagement.core.view.EntryViewImpl;
import de.adorsys.keymanagement.keyrotation.api.persistence.KeyStoreAccess;
import de.adorsys.keymanagement.keyrotation.api.services.KeyView;
import de.adorsys.keymanagement.keyrotation.api.services.KeyViewWithValidity;
import de.adorsys.keymanagement.keyrotation.api.types.KeyRotationConfig;
import de.adorsys.keymanagement.keyrotation.api.types.KeyStatus;
import de.adorsys.keymanagement.keyrotation.api.types.KeyType;
import de.adorsys.keymanagement.keyrotation.impl.services.KeyViewWithValidityImpl;
import java.security.KeyStore;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;

public class KeyViewImpl
implements KeyView {
    private final KeyRotationConfig config;
    private final KeyStoreAccess access;
    private final Juggler juggler;

    @Inject
    public KeyViewImpl(KeyRotationConfig config, KeyStoreAccess access, Juggler juggler) {
        this.config = config;
        this.access = access;
        this.juggler = juggler;
    }

    @Override
    public KeyViewWithValidity withValidity(Map<KeyType, Collection<KeyStatus>> validityMap) {
        return new KeyViewWithValidityImpl(this.config, this.juggler, this.access, validityMap);
    }

    @Override
    public KeyEntry keyById(String id) {
        return (KeyEntry)this.juggler.readKeys().fromKeyStore(this.keyStore(), keyId -> this.config.keyPassword().get()).entries().uniqueResult((Object)QueryFactory.equal((Attribute)EntryViewImpl.A_ID, (Object)id));
    }

    @Override
    public KeyStore keyStore() {
        return this.access.read();
    }
}

